<?php

/**
 * This is the model class for table "zonasbeds".
 *
 * The followings are the available columns in table 'zonasbeds':
 * @property integer $idZona
 * @property integer $zoneCode
 * @property string $name
 * @property string $destinationsCode
 *
 * The followings are the available model relations:
 * @property Destinations $destinationsCode0
 */
class Zonasbeds extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Zonasbeds the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'zonasbeds';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('zoneCode, name, destinationsCode', 'required'),
			array('zoneCode', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>100),
			array('destinationsCode', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('idZona, zoneCode, name, destinationsCode', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'destinationsCode0' => array(self::BELONGS_TO, 'Destinations', 'destinationsCode'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idZona' => 'Id Zona',
			'zoneCode' => 'Zone Code',
			'name' => 'Name',
			'destinationsCode' => 'Destinations Code',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('idZona',$this->idZona);
		$criteria->compare('zoneCode',$this->zoneCode);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('destinationsCode',$this->destinationsCode,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}