<div id="detalle_vue" class="container" style="margin-top: 2em;">
	<span v-show="loading">Cargando datos...</span>
	<div v-show="show">
		<h1 v-text="'Boda: ' + roominglist.novios"></h1>
		<div class="row">
			<div class="col">
				<p>
					<strong>Hotel: </strong><label v-text="roominglist.nombre_hotel"></label>
				</p>
				<p>
					<strong>Tipo habitación: </strong><label v-text="roominglist.tipo_habitacion"></label>
				</p>
				<p>
					<strong>Habitaciones: </strong><label v-text="roominglist.numero_habitaciones"></label>
				</p>
			</div>
			<div class="col">
				<p>
					<strong>Inicio: </strong><label v-text="parseDate(roominglist.fecha_inicio)"></label>
				</p>
				<p>
					<strong>Final: </strong><label v-text="parseDate(roominglist.fecha_final)"></label>
				</p>
			</div>
		</div>
		<div class="accordion_styled" id="accordion">
		  	<div class="card" v-for="(room, index) in roominglist.RoomingList">
				<div class="card-header">
				  	<h4>
						<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" :href="'#collapse' + index" v-text="'Habitación No. ' + (index + 1)"><i class="indicator icon-plus float-right"></i></a>
				  	</h4>
				</div>
				<div :id="'collapse' + index" class="collapse" data-parent="#accordion">
				  	<div class="card-body">
						<div class="row">
	        				<div class="col-3">
	        					<p>
	        						<strong>Roominglist: </strong><label v-text="room.id_roominglist"></label>
	        					</p>
	        					<p>
	        						<strong>Inicio: </strong>
	        						<label v-if="room.fecha_inicio == null || room.fecha_inicio == ''" v-text="">Sin registro</label>
	        						<label v-else v-text="parseDate(room.fecha_inicio)"></label>
	        					</p>
	        					<p>
	        						<strong>Fin: </strong>
	        						<label v-if="room.fecha_final == null || room.fecha_final == ''" v-text="">Sin registro</label>
	        						<label v-else v-text="parseDate(room.fecha_final)"></label>
	        					</p>
	        					<p>
	        						<strong>Noches: </strong>
	        						<label v-if="room.noches == null || room.noches == ''" v-text="">Sin registro</label>
	        						<label v-else v-text="room.noches"></label>
	        					</p>
	        				</div>
	        				<div class="col">
	        					<table class="table table-striped table-sm">
										<thead class="thead-dark">
										<tr>
	  										<th scope="col">Nombre</th>
	  										<th scope="col">Tipo</th>
										</tr>
										</thead>
									<tbody>
	    							<tr v-for="adulto in room.adultos">
	      								<td v-text="adulto.nombre"></td>
	      								<td>Adulto</td>
	    							</tr>
	    							<tr v-for="menor in room.menores">
	      								<td v-text="menor.nombre"></td>
	      								<td v-text="'Menor - ' + menor.edad + ' años'"></td>
	    							</tr>
									</tbody>
							</table>
	        				</div>
	        				<div class="col-2">
	        					<button type="button" class="btn btn-outline-info" @click="getIndexRoom(index,room.id_roominglist)" data-toggle="modal" data-target=".bd-example-modal-lg">Editar habitación</button>
	        				</div>
	        			</div>
				  	</div>
				</div>
		  	</div>
		</div>
		<!-- Modal -->
		<div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
	  		<div class="modal-dialog modal-lg">
	    		<div class="modal-content">
	      			<div class="modal-header">
	        			<h5 class="modal-title" id="exampleModalLabel" v-text="texto_editar"></h5>
	        			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
	          				<span aria-hidden="true">&times;</span>
	        			</button>
	      			</div>
	      			<div class="modal-body">
	      				<div class="form-group row" v-for="(pax, index) in aux_array" v-if="pax.tipo == 'adulto'">
    						<label class="col-sm-2 col-form-label">Nombre</label>
							<div class="col-sm-9">
      							<input type="text" class="form-control" v-model="pax.nombre">
    						</div>
    						<div class="col-sm-1">
    							<button type="button" class="btn btn-danger" @click="deletePax(index)"><span class="fa fa-trash"></span></button>
    						</div>
  						</div>
  						<div class="form-group row" v-else>
							<label class="col-sm-2 col-form-label">Nombre</label>
							<div class="col-sm-5">
  								<input type="text" class="form-control" v-model="pax.nombre">
							</div>
							<label class="col-sm-2 col-form-label">Edad</label>
							<div class="col-sm-2">
  								<input type="text" class="form-control" v-model="pax.edad">
							</div>
							<div class="col-sm-1">
								<button type="button" class="btn btn-danger" @click="deletePax(index)"><span class="fa fa-trash"></span></button>
							</div>
						</div>
	      			</div>
	      			<div class="modal-footer">
	        			<div class="btn-group" v-if="validateRoom() < 4">
							<button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Agregar pasajero</button>
							<div class="dropdown-menu">
								<span class="dropdown-item" data-pax="adulto" @click="addPax">Adulto</span>
								<span class="dropdown-item" data-pax="menor" @click="addPax">Menor</span>
							</div>
						</div>
						<button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
    					<button type="button" id="btn_update" class="btn btn-primary" @click="updateRoom">Aceptar</button>
	      			</div>
				</div>
	  		</div>
		</div>
	</div>
</div>
<?php Yii::app()->clientScript->registerScript('id', 'id_boda = '. $_GET["boda"], CClientScript::POS_HEAD); 
Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/sweetalert2@8', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/vue/casateconmigo/detalleboda.js?v='. time(), CClientScript::POS_END); ?>