<?php



class DefaultController extends Controller
{
	public $layout='//layouts/altair';
	
	public function actionIndex()
	{

		$resumen =  new Venta;
		
		// $resumen->id_agencias = "42,869,1865";
		$id_agencias = array();
		$id_agentes = array();
		// $id_agentes = array();
		$id_sucursal = "";
		$log=3;
		$campoxOrdenar = "cuartosNoches";
		
		// 'AND id_hotel IN(".$resumen->hoteles.")'
		// 'AND id_agente IN(".$resumen->agentes.")'
		// 'AND proveedor IN(0,2,4,5,6)'
		// 'AND proveedor IN(1,3)'
		
		if(!empty($id_agencias)){
			$resumen->id_agencias = '';
			$i=0;
			foreach ($id_agencias as $agencia) {
				if ($i!=0) {
					$resumen->id_agencias.=',';
				}else{
					$i=1;
				}

				$resumen->id_agencias .= $agencia;
			}

			$resumen->id_agencias = ' AND id_agencia IN('.$resumen->id_agencias.')';
		}

		if (!empty($id_agentes)) {
			$resumen->id_agentes = '';
			$i=0;
			foreach ($id_agentes as $agente) {
				if ($i!=0) {
					$resumen->id_agentes.=',';
				}else{
					$i=1;
				}

				$resumen->id_agentes .= $agente;
			}

			$resumen->id_agentes = ' AND id_agente IN('.$resumen->id_agentes.')';
		}

		if (!empty($log)) {
			$resumen->log = $this->getFechas($log);
		}else{
			$resumen->log = $this->getFechas(1);
		}

		$reservaciones = Reservacion::model()->findAll($resumen->log.$resumen->id_agencias.$resumen->id_agentes.' AND estatus!="C"');


		$resumen->totalReservaciones=$resumen->getTotalReservaciones($reservaciones);
		
		$resumen->importeTotal=$resumen->getImporteTotal($reservaciones);
		
		$resumen->agencias = $this->getAgencias($reservaciones,$id_agencias,$resumen->log);
		
		$resumen->agentes = $this->getAgentes($reservaciones,$id_agentes);

		###################################################

		$activitys = ActivityReservacion::model()->findAll($resumen->log.$resumen->id_agencias.' AND estatus!="C"');
		$resumen->agenciasActivity = $this->getAgenciasActivity($activitys);

		$tours = TourReservacion::model()->findAll($resumen->log.$resumen->id_agencias.' AND estatus!="C"');
		$resumen->agenciasTour = $this->getAgenciasTours($tours);

		$this->render('index',array('resumen'=>$resumen));
		//$this->render('reporteEjecutivo',array('resumen'=>$resumen, 'reservacionesxvencer'=>$reservacionesxvencer));

	}

	public function getSaldoHotelInd($data){
		$resumen = new Venta;
		$importeHotel = $this->getPagosHotelesInd($data);
		$data = (object) $data;
		// echo "<br>".$data->saldo_h;
		if ($data->total == $data->saldo_h) {
		 	$totalSaldoHotel = $this->getPagoHotelTotal($data->total,$data->idHotel->proveedor,$data->idHotel->comision) - $importeHotel;
		 }else{
			$totalSaldoHotel = $importeHotel + $data->saldo_h;
		 } 

		return $totalSaldoHotel;
	}


	public function getPagosHotelesInd($datos){
			$comprobantes = OrdenesPagoDetalles::model()->findAll('id_reservacion='.$datos->id_reservacion);
			if (!empty($comprobantes)) {
				foreach ($comprobantes as $total) {
					if ($total->idOrdenPago->estado!='C') {
						$totalPagado += $total->importe;
					}
				}
			}
		return $totalPagado;
	}

	public function getPagoHotelTotal($total,$proveedor,$comision_hotel){
		$reservacion = Yii::app()->createController('reservacion');
		$reservacion = $reservacion[0];
		switch ($proveedor) {
			case '0':
				$saldo_h = $reservacion->saldoHotel($total,$comision_hotel,"comision"); 
				break;
			case '1':
				$comision_hotel = Api::model()->findByPk(1)->markup;
				$saldo_h = $reservacion->saldoHotel($total,$comision_hotel,"Api");
				break;
			case '2':
				$saldo_h = $this->saldoHotel($total,$comision_hotel,"comision");
				break;
			case '3':
				$comision_hotel = Api::model()->findByPk(6)->markup;
				$saldo_h = $this->saldoHotel($total,$comision_hotel,"Api");
				break;
			case '4':
				$saldo_h = $this->saldoHotel($total,20,"comision");
				break;
			case '5':
				$saldo_h = $this->saldoHotel($total,$comision_hotel,"comision");
				break;
			case '6':
				$comision_hotel = Api::model()->findByPk(9)->markup;
				$saldo_h = $this->saldoHotel($total,$comision_hotel,"Api");
				break;
			default:
				# code...
				break;
		}

		return $saldo_h;
	}

	public function getPagosAgenciasInd($datos, $tipo){
			
			if ($tipo=="Indiv") {
				$tipoSql = "id_reservacion=".$datos->id_reservacion." AND tipo=''";
			}elseif ($tipo=="Tour") {
				$tipoSql = "id_reservacion=".$datos->id_tourReservacion." AND tipo='Tour'";
			}elseif ($tipo=="Activ") {
				$tipoSql = "id_reservacion=".$datos->id_reservacion." AND tipo='Activ'";
			}

			$recibos = ReciboDetalles::model()->findAll($tipoSql);
			if (!empty($recibos)) {
				foreach ($recibos as $total) {
					if ($total->idRecibo->estado!='C') {
						$totalPagado += $total->importe;
					}
				}
			}

		return $totalPagado;
	}


	public function getTotalComisionInd($total,$comision){
		
		$totalComision = $total*($comision/100);

		return $totalComision;
	}

	public function getUtilidadInd($reservaciones){
		$tipo = "Indiv";
		$importeHotel = $this->getPagosHotelesInd($reservaciones); 
		if ($reservaciones->total == $reservaciones->saldo_h) {
		 	$totalSaldoHotel = $this->getPagoHotelTotal($reservaciones->total,$reservaciones->idHotel->proveedor,$reservaciones->idHotel->comision) - $importeHotel;
		 }else{
			$totalSaldoHotel = $importeHotel + $reservaciones->saldo_h;
		 }
		$importeAgencia = $this->getPagosAgenciasInd($reservaciones,$tipo);
		$totalSaldoUtilidad = ($reservaciones->saldo + $importeAgencia) - $totalSaldoHotel;

		return $totalSaldoUtilidad;
	}

	public function getTotalTours($data,$log){
		$resumen = new Venta;
		$tour = TourReservacion::model()->findAll($log.' AND id_agencia='.$data.' AND estatus!="C"');
		$datos["totalReservaciones"] = count($tour);
		$tipo = "Tour";
		foreach ($tour as $row) {
			$datos["importeTotal"] += $row->importe;
			$datos["comision"] = $row->idAgencia->porcentaje_comision;
			$datos["totalComision"] += $this->getTotalComisionInd($row->importe,$row->comision);
			$datos["importeAgencia"] += $row->importe - $this->getTotalComisionInd($row->importe,$row->comision);
			$datos["comision"] = $data->idAgencia->porcentaje_comision;
			// $datos["saldoHotel"] += $this->getSaldoHotelInd($data);
			// $datos["totalUtilidad"] += $this->getUtilidadInd($data);
			$datos["pagadoAgencia"] += $this->getPagosAgenciasInd($row,$tipo);
			$datos["saldoAgencia"] += $row->saldo;
		}
		return $datos;
	}

	public function getTotalActivity($data,$log){
		$resumen = new Venta;
		$activity = ActivityReservacion::model()->findAll($log.' AND id_agencia='.$data.' AND estatus!="C"');
		$datos["totalReservaciones"] = count($activity);
		$tipo = "Activ";
		foreach ($activity as $row) {
			$datos["importeTotal"] += $row->total;
			$datos["comision"] = $row->idAgencia->porcentaje_comision;
			$datos["totalComision"] += $this->getTotalComisionInd($row->total,$row->comision);
			$datos["importeAgencia"] += $row->total - $this->getTotalComisionInd($row->total,$row->comision);
			$datos["comision"] = $data->idAgencia->porcentaje_comision;
			// $datos["saldoHotel"] += $this->getSaldoHotelInd($data);
			// $datos["totalUtilidad"] += $this->getUtilidadInd($data);
			$datos["pagadoAgencia"] += $this->getPagosAgenciasInd($row,$tipo);
			$datos["saldoAgencia"] += $row->saldo;
		}
		return $datos;
	}

	public function getAgenciasTours($datos){
		$resumen = new Venta;
		$idAgenciasTour = array();
		$tipo = "Tour";
		foreach ($datos as $data) {
			$idAgenciasTour[$data->id_agencia]["agencia"] = $data->idAgencia->nombre_agencia;
			$idAgenciasTour[$data->id_agencia]["totalReservaciones"] += $resumen->getTotalReservaciones($data);
			$idAgenciasTour[$data->id_agencia]["importeTotal"] += $data->importe;
			$idAgenciasTour[$data->id_agencia]["comision"] = $data->idAgencia->porcentaje_comision;
			$idAgenciasTour[$data->id_agencia]["totalComision"] += $this->getTotalComisionInd($data->importe,$data->comision);
			$idAgenciasTour[$data->id_agencia]["importeAgencia"] += $data->importe - $this->getTotalComisionInd($data->importe,$data->comision);
			// $idAgenciasTour[$data->id_agencia]["totalUtilidad"] += $this->getUtilidadInd($data);
			$idAgenciasTour[$data->id_agencia]["pagadoAgencia"] += $this->getPagosAgenciasInd($data,$tipo);
			$idAgenciasTour[$data->id_agencia]["saldoAgencia"] += $data->saldo;
		}

		return $idAgenciasTour;
	}

	public function getAgenciasActivity($datos){
		$resumen = new Venta;
		$idAgenciasActivity = array();
		$tipo = "Activ";
		foreach ($datos as $data) {
			$idAgenciasActivity[$data->id_agencia]["agencia"] = $data->idAgencia->nombre_agencia;
			$idAgenciasActivity[$data->id_agencia]["totalReservaciones"] += $resumen->getTotalReservaciones($data);
			$idAgenciasActivity[$data->id_agencia]["importeTotal"] += $data->total;
			$idAgenciasActivity[$data->id_agencia]["comision"] = $data->idAgencia->porcentaje_comision;
			$idAgenciasActivity[$data->id_agencia]["totalComision"] += $this->getTotalComisionInd($data->total,$data->comision);
			$idAgenciasActivity[$data->id_agencia]["importeAgencia"] += $data->total - $this->getTotalComisionInd($data->total,$data->comision);
			// $idAgenciasActivity[$data->id_agencia]["totalUtilidad"] += $this->getUtilidadInd($data);
			$idAgenciasActivity[$data->id_agencia]["pagadoAgencia"] += $this->getPagosAgenciasInd($data,$tipo);
			$idAgenciasActivity[$data->id_agencia]["saldoAgencia"] += $data->saldo;
		}

		return $idAgenciasActivity;
	}

	public function getFechas($filtroFecha){
		$fechaActual = date('Y-m-d');
		$mesActual = date('m');
		$añoActual = date('Y');
		
		##semana pasada
		$laSemanaPasada = date('Y-m-d', strtotime('-1 week'));
		##dias del mes pasado
		$diasMesPasado = date('t', strtotime('-1 month'));
		##mes pasado
		$mesPasado = date('Y-m', strtotime('-1 month'));
		##seisMesesAnterior
		$seisMesesAntes = date('Y-m', strtotime('-6 month'));
		##año anterior al actual
		$añoAnterior = date('Y', strtotime('-1 year'));
		##numero de dia perteneciente 
		$numDiaActual = date('w');
		$fechainicioSemana = strtotime('-'.($numDiaActual-1).' day', strtotime($fechaActual));
		## 1 1-1=0

		switch ($filtroFecha) {
			case 1:
				#hoy
				$log = "log LIKE '".$fechaActual."%'";
				break;
			case 2:
				#estaSemana
				$log = "log BETWEEN '".date('Y-m-d',$fechainicioSemana)." 00:00:00' AND '".date('Y-m-d')." 23:59:59'";
				break;
			case 3:
				#esteMes
				$log ="log BETWEEN '".date($añoActual.'-'.$mesActual.'-01')." 00:00:00' AND '".date('Y-m-d')." 23:59:59'";
				break;
			case 4:
				#elmesPasado
				$log="log BETWEEN '".date($mesPasado.'-01')." 00:00:00' AND '".date($mesPasado.'-'.$diasMesPasado)." 23:59:59'";
				break;
			case 5:
				#ultimosSeisMeses
				$log="log BETWEEN '".date($seisMesesAntes.'-01')." 00:00:00' AND '".date($mesPasado.'-'.$diasMesPasado)." 23:59:59'";
				break;
			case 6:
				#anioAnterior
				$log="log BETWEEN '".date($añoAnterior.'-01-01')." 00:00:00' AND '".date($añoAnterior.'-12-31')." 23:59:59'";
				break;
			default:
				#hoy
				$log = "log LIKE '".$fechaActual."%'";
				break;
		}
		
		return $log;
	}
	

	public function array_sort_by($reservaciones, $col, $order = SORT_ASC)
	{
		$arrAux = array();
		foreach ($reservaciones as $key => $row)
		{
			$arrAux[$key] = is_object($row) ? $arrAux[$key] = $row->$col : $row[$col];
			$arrAux[$key] = strtolower($arrAux[$key]);
		}
		array_multisort($arrAux, $order, $reservaciones);

		$reservaciones = array_slice($reservaciones, 0, 10);

		return $reservaciones;
	}

	public function getAgencias($reservaciones,$agencias,$log){
		$resumen = new Venta;
		$idAgencias = array();
		$boda=1;$bloqueo=1;$grupo=1;$individual=1;$tipo="Indiv";
			foreach ($reservaciones as $data) {
				// if (in_array($data->id_agencia,$agencias)) {
					$idAgencias[$data->id_agencia]["agencia"] = $data->idAgencia->nombre_agencia;
					$idAgencias[$data->id_agencia]["totalReservaciones"] += $resumen->getTotalReservaciones($data);
					$idAgencias[$data->id_agencia]["cuartosNoches"] += $data->num_noches*$data->num_habitaciones;
					$idAgencias[$data->id_agencia]["importeTotal"] += $data->total;
					$idAgencias[$data->id_agencia]["comision"] = $data->idAgencia->porcentaje_comision;
					$idAgencias[$data->id_agencia]["totalComision"] += $this->getTotalComisionInd($data->total,$data->comision);
					$idAgencias[$data->id_agencia]["importeAgencia"] += $data->total - $this->getTotalComisionInd($data->total,$data->comision);
					$idAgencias[$data->id_agencia]["saldoHotel"] += $this->getSaldoHotelInd($data);
					$idAgencias[$data->id_agencia]["totalUtilidad"] += $this->getUtilidadInd($data);
					$idAgencias[$data->id_agencia]["pagadoAgencia"] += $this->getPagosAgenciasInd($data,$tipo);
					$idAgencias[$data->id_agencia]["saldoAgencia"] += $data->saldo;
					if (empty($idAgencias[$data->id_agencia]["Tours"])) {
						$idAgencias[$data->id_agencia]["Tours"] = $this->getTotalTours($data->id_agencia,$log);
					}
					if (empty($idAgencias[$data->id_agencia]["Activity"])) {
						$idAgencias[$data->id_agencia]["Activity"] = $this->getTotalActivity($data->id_agencia,$log); 
					}
					if ($data->id_bloqueo!=null) {
						switch ($data->idBloqueo->tipo) {
							case 'GRUPAL':
								if ($data->idBloqueo->idTarifa->precio == "BODA") {
									$idAgencias[$data->id_agencia]["bodas"]["totalReservaciones"] = $boda;
									$idAgencias[$data->id_agencia]["bodas"]["cuartosNoches"] += $data->num_noches*$data->num_habitaciones;
									$idAgencias[$data->id_agencia]["bodas"]["importeTotal"] += $data->total;
									$idAgencias[$data->id_agencia]["bodas"]["comision"] = $data->idAgencia->porcentaje_comision;
									$idAgencias[$data->id_agencia]["bodas"]["totalComision"] += $this->getTotalComisionInd($data->total,$data->comision);
									$idAgencias[$data->id_agencia]["bodas"]["importeAgencia"] += $data->total - $this->getTotalComisionInd($data->total,$data->comision);
									$idAgencias[$data->id_agencia]["bodas"]["saldoHotel"] += $this->getSaldoHotelInd($data);
									$idAgencias[$data->id_agencia]["bodas"]["totalUtilidad"] += $this->getUtilidadInd($data);
									$idAgencias[$data->id_agencia]["bodas"]["pagadoAgencia"] += $this->getPagosAgenciasInd($data,$tipo);
									$idAgencias[$data->id_agencia]["bodas"]["saldoAgencia"] += $data->saldo;
									$boda++;
								}else{
									$idAgencias[$data->id_agencia]["grupos"]["totalReservaciones"] = $grupo;
									$idAgencias[$data->id_agencia]["grupos"]["cuartosNoches"] += $data->num_noches*$data->num_habitaciones;
									$idAgencias[$data->id_agencia]["grupos"]["importeTotal"] += $data->total;
									$idAgencias[$data->id_agencia]["grupos"]["comision"] = $data->idAgencia->porcentaje_comision;
									$idAgencias[$data->id_agencia]["grupos"]["totalComision"] += $this->getTotalComisionInd($data->total,$data->comision);
									$idAgencias[$data->id_agencia]["grupos"]["importeAgencia"] += $data->total - $this->getTotalComisionInd($data->total,$data->comision);
									$idAgencias[$data->id_agencia]["grupos"]["saldoHotel"] += $this->getSaldoHotelInd($data);
									$idAgencias[$data->id_agencia]["grupos"]["totalUtilidad"] += $this->getUtilidadInd($data);
									$idAgencias[$data->id_agencia]["grupos"]["pagadoAgencia"] += $this->getPagosAgenciasInd($data,$tipo);
									$idAgencias[$data->id_agencia]["grupos"]["saldoAgencia"] += $data->saldo;
									$grupo++;
								}
								break;
							case 'BLOQUEO':
								$idAgencias[$data->id_agencia]["bloqueos"]["totalReservaciones"] = $bloqueo;
								$idAgencias[$data->id_agencia]["bloqueos"]["cuartosNoches"] += $data->num_noches*$data->num_habitaciones;
								$idAgencias[$data->id_agencia]["bloqueos"]["importeTotal"] += $data->total;
								$idAgencias[$data->id_agencia]["bloqueos"]["comision"] = $data->idAgencia->porcentaje_comision;
								$idAgencias[$data->id_agencia]["bloqueos"]["totalComision"] += $this->getTotalComisionInd($data->total,$data->comision);
								$idAgencias[$data->id_agencia]["bloqueos"]["importeAgencia"] += $data->total - $this->getTotalComisionInd($data->total,$data->comision);
								$idAgencias[$data->id_agencia]["bloqueos"]["saldoHotel"] += $this->getSaldoHotelInd($data);
								$idAgencias[$data->id_agencia]["bloqueos"]["totalUtilidad"] += $this->getUtilidadInd($data);
								$idAgencias[$data->id_agencia]["bloqueos"]["pagadoAgencia"] += $this->getPagosAgenciasInd($data,$tipo);
								$idAgencias[$data->id_agencia]["bloqueos"]["saldoAgencia"] += $data->saldo;
								$bloqueo++;
								break;
							default:
								break;
						}
					}

					if ($data->id_bloqueo==null) {
						$idAgencias[$data->id_agencia]["reservasIndividuales"] += $resumen->getTotalReservaciones($data);
					}
				// }
			}

		return $idAgencias;
	}


	public function getAgentes($reservaciones,$agentes){
		$resumen = new Venta;
		$idAgentes = array();
		$tipo = "Indiv";


			foreach ($reservaciones as $data) {
				// if ($row == $data->id_agente) {
					$idAgentes[$data->id_agente]["agente"] = $data->idAgente->nombre_usuario;
					$idAgentes[$data->id_agente]["totalReservaciones"] += $resumen->getTotalReservaciones($data);
					$idAgentes[$data->id_agente]["cuartosNoches"] += $data->num_noches*$data->num_habitaciones;
					$idAgentes[$data->id_agente]["pagadoAgencia"] += $this->getPagosAgenciasInd($data,$tipo);
					$idAgentes[$data->id_agente]["saldoAgencia"] += $data->saldo;
				// }
			}

		return $idAgentes;
	}
	
}