<?php $this->pageTitle=Yii::app()->name . ' - '.UserModule::t("Profile");
$this->breadcrumbs=array(
	UserModule::t("Profile"),
);
$this->menu=array(
    array('label'=>UserModule::t('Administrar Usuarios'), 'url'=>array('/user/admin/admin'), 'visible'=>UserModule::isAdmin()),
  //  array('label'=>UserModule::t('Lista de Usuarios'), 'url'=>array('/user/user/index')),
    array('label'=>UserModule::t('Editar Perfil'), 'url'=>array('edit')),
    array('label'=>UserModule::t('Cambiar Password'), 'url'=>array('changepassword')),
    array('label'=>UserModule::t('Salir'), 'url'=>array('/user/logout/logout')),
); ?>

<?php 
$this->beginWidget('zii.widgets.CPortlet', array(
	'htmlOptions'=>array(
		'class'=>'pull-right'
	)
));
$this->widget('bootstrap.widgets.TbMenu', array(
	'type'=>'pills',
	'items'=>$this->menu,
));
$this->endWidget();
?>
<h1><?php echo UserModule::t('Bienvenido'); ?></h1>

<?php
 
    $attributes = array(
        'username',
        'email',
    );
    
    $profileFields=ProfileField::model()->forOwner()->sort()->findAll();
    if ($profileFields) {
        foreach($profileFields as $field) {
            array_push($attributes,array(
                    'label' => UserModule::t($field->title),
                    'name' => $field->varname,
                    'type'=>'raw',
                    'value' => (($field->widgetView($model->profile))?$field->widgetView($model->profile):(($field->range)?Profile::range($field->range,$model->profile->getAttribute($field->varname)):$model->profile->getAttribute($field->varname))),
                ));
        }
    }
    
    array_push($attributes,
        'create_at',
        'lastvisit_at',
        array(
            'name' => 'status',
            'value' => User::itemAlias("UserStatus",$model->status),
        )
    );
    
    $this->widget('bootstrap.widgets.TbDetailView', array(
        'data'=>$model,
        'attributes'=>$attributes,
    ));
?>	