<?php
$questions = json_decode(json_encode($question));

$comments = json_decode($comments);

$dash = Yii::app()->createController('dashboard');
$dash = $dash[0];
$tasa_cambio = $dash->tasaCambioActual();
$currency = $tasa_cambio['importe'] ? $tasa_cambio['importe'] : 25.5;


$time = $formApi['startProcess'];
$startime = 20 + ((strtotime($time) - strtotime(date('H:i:s') . "+ 5 minutes")) / 60);
$segun = number_format($startime, 2);
$seg = explode('.', $segun);
$seg = $seg[1] / 100;
$segundo = (60 * $seg);

$referer = Yii::app()->request->urlReferrer;

?>

<section class="pt60 pb90 bgc-f7">
  <div class="container">
    <a class="fz16" href="<?= ($referer) ? $referer : Yii::app()->baseUrl ?>">Regresar</a>
    <br><br>
    <div class="row wrap wow fadeInUp justify-content-between" data-wow-delay="500ms">
      <div class="col-lg-7">
        <div class="ps-widget bgc-white bdrs12 p30 mb30 overflow-hidden position-relative">
          <div class="d-flex justify-content-between align-items-center mb0">
            <div>
              <h2 class="title fz24">Confirmar y pagar</h2>
            </div>
            <div id="tiempo_booking">
              <!-- <h4 id="numero">
							<b style="color:#565a5c">Tiempo:</b> 	
							<span class="minutos">
								<?= number_format($startime) ?>
							|</span>:<span class="seg"><?= $segundo ?></span>
						</h4>		 -->
              <div id="numero">
                <span style="font-size: 20px; width: 50px; display: inline-block;">
                  <!-- <b style="color:#565a5c">Tiempo:</b> -->
                  <span class="minutos">
                    <?= number_format($startime) ?>
                  </span>:<span class="seg"><?= $segundo ?></span>
                </span>
              </div>
            </div>
          </div>

          <hr>
          <div class="row">
            <div class="col-md-12">
              <div class="bsp_reveiw_wrt">
                <?php
                $form = $this->beginWidget('bootstrap.widgets.TbActiveForm', array(
                  'id' => 'reservacion-form',
                  'enableAjaxValidation' => false,
                  'method' => 'post',
                  'action' => Yii::app()->controller->createUrl('activities/create'),
                  'type' => '',
                  'htmlOptions' => array(
                    'enctype' => 'multipart/form-data',
                    'class' => 'comments_form'
                  )
                ));
                ?>

                <input type="hidden" value="<?= $comision ?>" id="agencia_comision" name="comision">
                <input type="hidden" value="<?= $formApi['currency'] ?>" id="currency" name="moneda">
                <input type="hidden" value="<?= round($formApi['total'], 2) ?>" id="total_reserva" name="total_reserva">
                <input type="hidden" value="<?= $formApi['ratekey'] ?>" id="rate" name="ratekey">

                <?php
                echo $form->hiddenField($model, 'fecha_inicial', array('data-date-format' => 'dd-mm-yyyy', 'value' => $formApi['travel_date']));
                ?>
                <?php if ($formApi['durationDays'] > 1 && $formApi['metricDays'] == "DAYS") : ?>
                  <?php
                  $fechaI = implode('-', array_reverse(explode('/', $formApi['travel_date'])));
                  $fechas = date('d/m/Y', strtotime($fechaI . '+' . $formApi['durationDays'] . ' day'));
                  ?>
                  <?php echo $form->hiddenField($model, 'fecha_final', array('readonly' => 'readonly', 'required' => 'required', 'value' => $fechas)); ?>
                <?php endif ?>
                <h5>Información del los pasajeros</h5>
                <br>
                <div class="row">
                  <!-- <div class="col-md-12">
                    <div class="mb-4">
                      <label class="fw600 ff-heading mb-2">Email</label>
                      <input type="email" class="form-control" placeholder="creativelayers088">
                    </div>
                  </div> -->
                  <div class="col-md-6">
                    <div class="mb-2">
                      <label class="fw600 ff-heading mb-2">Nombre cliente</label>
                      <!-- <input type="text" class="form-control" placeholder="Ingrese su nombre"> -->
                      <?php echo $form->textField($model, 'nombre_cliente', array('class' => 'form-control', 'maxlength' => 255, 'required' => 'required', 'id' => 'nombre_cliente')); ?>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="mb-2">
                      <label class="fw600 ff-heading mb-2">Apellido cliente</label>
                      <?php echo $form->textField($model, 'apellido_cliente', array('class' => 'form-control', 'rows' => '4',  'maxlength' => 255, 'required' => 'required', 'id' => 'apellido_cliente')); ?>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="mb-2">
                      <label class="fw600 ff-heading mb-2">Correo cliente</label>
                      <?php echo $form->textField($model, 'email_cliente', array('class' => 'form-control', 'required' => 'required', 'id' => 'Reservacion_email')); ?>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="mb-2">
                      <label class="fw600 ff-heading mb-2">Teléfono cliente</label>
                      <?php echo $form->textField($model, 'tel_cliente', array('class' => 'form-control', 'rows' => '4',  'maxlength' => 10, 'required' => 'required', 'id' => 'Reservacion_tel_cliente')); ?>
                    </div>
                  </div>

                </div>

                <input type="hidden" id="num_adultos" value="<?= $formApi['cotizacion']['num_adultos'] ?>">

                <?php $this->renderPartial('_adulto_activities', array('num_adultos' => $formApi['cotizacion']['num_adultos'], 'hab' => 1, 'n' => $n)); ?>
                <?php $this->renderPartial('_menor_activities', array('cotizacion' => $formApi['cotizacion'], 'hab' => 1, 'n' => $n, 'rango_ninio' => $formApi['rango_ninio'])); ?>

                <?php if ($questions) : ?>
                  <hr>
                  <h5>Información requerida por el proveedor</h5>
                  <br>
                  <div class="row">
                    <div class="col-md-12">

                      <?php $i = 0; ?>

                      <?php foreach ($questions as $pregunta) : ?>

                        <label id="question_text_<?= $i ?>">
                          <?=
                          $pregunta->text;
                          echo ($pregunta->required == true) ? '*' : '';
                          ?>
                        </label>

                        <div class="input-group">
                          <input id="question_<?= $i ?>" name="code_question[<?= $i; ?>]" type="hidden" value="<?= $pregunta->code; ?>">
                          <input id="answer_<?= $i ?>" name="answer[<?= $i; ?>]" <?php if ($pregunta->required == true) {
                                                                                    echo 'required';
                                                                                  } ?> type="text" class="form-control">
                        </div>

                        <?php $i++; ?>

                      <?php endforeach; ?>

                      <input name="num_question" id="num_question" type="hidden" value="<?= $i; ?>">
                    </div>

                  </div>
                  <hr>
                <?php endif; ?>

                <div class="row">
                  <div class="col-12">
                    <label for="codigoPromocion">Código de promoción</label>
                    <div class="input-group">
                      <input type="text" name="codigo_promocion" id="codigoPromocion" class="form-control">
                    </div>
                  </div>
                  <div class="col-md-12">
                    <label>Comentarios</label>
                    <div class="input-group">
                      <?php echo $form->textArea($model, 'comentarios', array('class' => 'form-control', 'rows' => 3, 'cols' => 50, 'style' => 'width:100%')); ?>
                    </div>
                  </div>
                </div>
                <textarea class="d-none" name="formApi"><?= base64_encode(json_encode($formApi)) ?></textarea>

                <?php if ($_POST['vendedor_referenciado'] != '') : ?>
                  <input type="hidden" name="ActivityReservacion[vendedor_referenciado]" value="<?= $_POST['vendedor_referenciado'] ?>">
                <?php endif; ?>
                
                <input type="hidden" name="tipo_reserva" value="tour">
                <p class="mt10">Al hacer click en el botón 'Realizar reserva', usted está aceptando las <a href="">Políticas de reservación</a> y el <a href="">aviso de privacidad</a></p>
                <?php $this->endWidget(); ?>
              </div>
            </div>
          </div>
        </div>

        <?php $this->renderPartial("/generales/pasarelas_pago/_openpay", array("key"=>"")); ?>

        
        <div class="btn-area text-end" id="btnReservaActivitie">
          <button type="submit" form="reservacion-form" class="ud-btn btn-white2">Realizar reserva <i class="fal fa-arrow-right-long"></i></button>
        </div>
      </div>
      <div class="col-lg-5">
        <div class="ps-widget bgc-white bdrs12 default-box-shadow2 p30 mb30 overflow-hidden position-relative">
          <!-- <h4 class="title fz17 mb30">Get More Information</h4> -->
          <div class="agent-single row align-items-center bdrb1 mb30 pb25">
            <div class="single-img mb20-sm col-md-4">
              <img class="w100 bdrs12" style="height: 110px; object-fit:cover;" src="<?= $formApi['foto']; ?>" alt="">
            </div>
            <div class="single-contant ml0-xs col-md-8">
              <h6 class="title mb-1"><?= $formApi['nombre_actividad'] ?></h6>
              <p><?= $formApi['destino_actividad'] ?></p>
            </div>
          </div>
          <div class="row">
            <div class="col-md-12">
              <h5>Resumen del servicio</h5>
              <div class="pd-list d-flex justify-content-between">
                <p class="text mb5">Fecha</p>
                <p class="text mb5"><?= ($fechas) ? $fechas : $formApi['travel_date'] ?></p>
              </div>
              <div class="pd-list d-flex justify-content-between">
                <p class="text mb5">Adultos</p>
                <p class="text mb5"><?= $formApi['num_adultos_D'] ?></p>
              </div>
              <div class="pd-list d-flex justify-content-between">
                <p class="text mb5">Menores</p>
                <p class="text mb5"><?= $formApi['num_ninios_D'] ?></p>
              </div>
              <div class="pd-list d-flex justify-content-between">
                <p class="text mb5">Precio por adulto</p>
                <p class="text mb5">$<?= number_format($formApi['precio_adulto'] / $markup, 2) . " " . $formApi['currency'] ?></p>
              </div>
              <div class="pd-list d-flex justify-content-between bdrb1 mb10">
                <p class="text mb10">Precio por menor</p>
                <p class="text mb20">$<?= number_format($formApi['precio_ninio'] / $markup, 2) . " " . $formApi['currency'] ?></p>
              </div>
              <!-- <hr> -->
              <div class="pd-list d-flex justify-content-between">
                <p class="text mb10"><b>Total</b></p>
                <p> $<?= number_format($formApi['total'], 2) . " " . $formApi['currency'] ?></p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<?php

Yii::app()->clientScript->registerScript('varsReservaActivitie', '
var baseUrl = "' . Yii::app()->baseUrl . '";
', CClientScript::POS_HEAD);

Yii::app()->clientScript->registerScriptFile('//cdn.jsdelivr.net/npm/sweetalert2@10', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/js/form_reserva_activities.js?v=" . time(), CClientScript::POS_END);
?>