<?php $assets= Yii::app()->baseUrl."/template/ansonika/assets"; 


?>
<link rel="stylesheet" href="<?=$assets.'/css/admin.css';?>">

<style>
	@media (max-width: 767px) {
		.margin_60 {
			padding-top: 70px;
		}
	}

	@media (min-width: 768px) {
		.margin_60 {
			padding-top: 120px;
			padding-bottom: 60px;
		}
	}
</style>

<main>
	<div id="info_agencia" class="margin_60 container">
		<div id="tabs" class="tabs">
		
			<nav>
				<ul>
					<li><a href="#section-1" class="icon-profile"><span>General</span></a>
					</li>
					<li><a href="#section-2" class="icon-docs-1"><span>Fiscal</span></a>
					</li>
					<li><a href="#section-3" class="icon-share"><span>Marketing</span></a>
					</li>
					<li><a href="#section-4" class="icon-users"><span>Usuarios</span></a>
					</li>
					
				</ul>
			</nav>
			<div class="content">
				<section id="section-1">
					<h4>Información general agencias</h4>
					
					<div class="form-group">
						<label>Nombre</label>
						<input class="form-control" type="text" v-model="info_agencia.nombre_agencia">
					</div>
					<div class="form-row">
    					<div class="form-group col-md-6">
      						<label>Contacto</label>
      						<input type="text" class="form-control" v-model="info_agencia.contacto">
    					</div>
    					<div class="form-group col-md-6">
      						<label>Puesto</label>
      						<input type="text" class="form-control" v-model="info_agencia.puesto">
    					</div>
  					</div>
					<div class="form-row">
    					<div class="form-group col-md-4">
      						<label>Teléfono</label>
      						<input type="text" class="form-control" v-model="info_agencia.tel_agencia">
    					</div>
    					<div class="form-group col-md-4">
      						<label>Celular</label>
      						<input type="text" class="form-control" v-model="info_agencia.celular">
    					</div>
    					<div class="form-group col-md-4">
      						<label>Email</label>
      						<input type="text" class="form-control" v-model="info_agencia.email_agencia">
    					</div>
  					</div>
  					<div class="form-row">
    					<div class="form-group col-md-8">
      						<label>Página web</label>
      						<input type="text" class="form-control" v-model="info_agencia.url_agencia">
    					</div>
    					<div class="form-group col-md-4">
      						<label>Skype</label>
      						<input type="text" class="form-control" v-model="info_agencia.skype_agencia">
    					</div>
  					</div>

					<hr>
					<br>

					<h4>Dirección</h4>
					<div class="form-row">
    					<div class="form-group col-md-3">
      						<label>Calle</label>
      						<input type="text" class="form-control" v-model="info_agencia.calle_agencia">
    					</div>
    					<div class="form-group col-md-3">
      						<label>No. Ext.</label>
      						<input type="text" class="form-control" v-model="info_agencia.num_exterior_agencia">
    					</div>
    					<div class="form-group col-md-3">
      						<label>No. Int.</label>
      						<input type="text" class="form-control" v-model="info_agencia.num_interior_agencia">
    					</div>
    					<div class="form-group col-md-3">
      						<label>Cruzamientos</label>
      						<input type="text" class="form-control" v-model="info_agencia.cruzamientos_agencia">
    					</div>
  					</div>
  					<div class="form-row">
    					<div class="form-group col-md-3">
      						<label>C.P.</label>
      						<input type="text" class="form-control" v-model="info_agencia.cp_agencia">
    					</div>
    					<div class="form-group col-md-5">
      						<label>Colonia</label>
      						<input type="text" class="form-control" v-model="info_agencia.id_colonia_agencia">
    					</div>
    					<div class="form-group col-md-4">
      						<label>Municipio</label>
      						<input type="text" class="form-control" v-model="info_agencia.municipio_agencia">
    					</div>
  					</div>
  					<div class="form-row">
    					<div class="form-group col-md-4">
      						<label>Ciudad</label>
      						<input type="text" class="form-control" v-model="info_agencia.id_ciudad_agencia">
    					</div>
    					<div class="form-group col-md-4">
      						<label>Estado</label>
                            <v-multiselect v-model="stateLoad" :options="array_states" track-by="id_estadosmex" label="nombreestado" open-direction="bottom" :searchable="true" :loading="isLoadingState" :clear-on-select="true" :close-on-select="true" :max-height="150" :preserve-search="true" autocomplete="off" @select="setState">
                                <span slot="noResult">No hay coincidencias. Pruebe modificar su búsqueda.</span>
                            </v-multiselect>
                            <input type="hidden" v-model="info_agencia.id_estado_agencia">
    					</div>
    					<div class="form-group col-md-4">
      						<label>País</label>
      						<v-multiselect v-model="countryLoad" :options="array_countries" track-by="id_pais" label="nombre_pais" open-direction="bottom" :searchable="true" :loading="isLoadingCountry" :clear-on-select="true" :close-on-select="true" :max-height="150" :preserve-search="true" autocomplete="off" @select="setCountry">
                                <span slot="noResult">No hay coincidencias. Pruebe modificar su búsqueda.</span>
                            </v-multiselect>
                            <input type="hidden" v-model="info_agencia.id_pais_agencia">
    					</div>
  					</div>
                    <hr>
                    <button class="btn_full" id="btn_general" @click="updateInfoAgencia('general')">Guardar cambios</button>
				</section>
				<!-- End section 1 -->

				<section id="section-2">
					<h4>Información fiscal agencia</h4>
					<div class="form-row">
    					<div class="form-group col-md-4">
      						<label>R.F.C.</label>
      						<input type="text" class="form-control" v-model="info_agencia.rfc">
    					</div>
    					<div class="form-group col-md-8">
      						<label>Razón social</label>
      						<input type="text" class="form-control" v-model="info_agencia.razon_social">
    					</div>
  					</div>
  					<div class="form-row">
    					<div class="form-group col-md-3">
      						<label>Calle</label>
      						<input type="text" class="form-control" v-model="info_agencia.calle_fiscal">
    					</div>
    					<div class="form-group col-md-3">
      						<label>No. Ext.</label>
      						<input type="text" class="form-control" v-model="info_agencia.num_exterior_fiscal">
    					</div>
    					<div class="form-group col-md-3">
      						<label>No. Int.</label>
      						<input type="text" class="form-control" v-model="info_agencia.num_interior_fiscal">
    					</div>
    					<div class="form-group col-md-3">
      						<label>Cruzamientos</label>
      						<input type="text" class="form-control" v-model="info_agencia.cruzamientos_fiscal">
    					</div>
  					</div>
  					<div class="form-row">
    					<div class="form-group col-md-3">
      						<label>C.P.</label>
      						<input type="text" class="form-control" v-model="info_agencia.cp_fiscal">
    					</div>
    					<div class="form-group col-md-5">
      						<label>Colonia</label>
      						<input type="text" class="form-control" v-model="info_agencia.id_ciudad_fiscal">
    					</div>
    					<div class="form-group col-md-4">
      						<label>Municipio</label>
      						<input type="text" class="form-control" v-model="info_agencia.municipio_fiscal">
    					</div>
  					</div>
  					<div class="form-row">
    					<div class="form-group col-md-4">
      						<label>Ciudad</label>
      						<input type="text" class="form-control" v-model="info_agencia.id_ciudad_fiscal">
    					</div>
    					<div class="form-group col-md-4">
      						<label>Estado</label>
      						<input type="text" class="form-control" v-model="info_agencia.id_estado_fiscal">
    					</div>
    					<div class="form-group col-md-4">
      						<label>País</label>
      						<input type="text" class="form-control" v-model="info_agencia.id_pais_fiscal">
    					</div>
  					</div>
                    <hr>
                    <button class="btn_full" id="btn_fiscal" @click="updateInfoAgencia('fiscal')">Guardar cambios</button>
				</section>
				<!-- End section 2 -->

				<section id="section-3">
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <h4>Logo agencia</h4>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" @change="onloadImg('logo')">
                                    <label class="custom-file-label"></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <img :src="img_logo" alt="Image" class="img-fluid profile_pic styled">
                        </div>
                    </div>
                    <button class="btn_full" id="btn_logo" @click="updateInfoAgencia('logo')">Cambiar logotipo</button>

                    <hr>
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <h4>Pie flyer</h4>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" @change="onloadImg('pie')">
                                    <label class="custom-file-label"></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <img :src="img_pie" alt="Image" class="img-fluid profile_pic styled">
                        </div>
                    </div>
                    <button class="btn_full" id="btn_pie" @click="updateInfoAgencia('pie')">Cambiar pie de flyer</button>
  					<hr>
					<h4>Ubicación agencia</h4>
        			<div id="map" style="width: 100%; height: 350px;"></div>
        			<hr>
                    <button class="btn_full" id="btn_ubicacion" @click="updateInfoAgencia('ubicacion')">Cambiar ubicación</button>
				</section>
				<!-- End section 3 -->

				<section id="section-4">
					<table class="table table-striped">
                        <thead>
                          	<tr>
                            	<th>Nombre</th>
                            	<th>Email</th>
                            	<th>Cumpleaños</th>
                            	<th>Tipo</th>
                            	<!-- <th>Último acceso</th> -->
                            	<th>Estatus</th>
                            	<th>Opciones</th>
                          	</tr>
                        </thead>
                        <tbody>
                          	<tr v-for="user in array_users">
                            	<td v-text="user.nombre_usuario"></td>
                            	<td v-text="user.email_usuario"></td>
                            	<td v-text="parseDate(user.fecha_nacimiento, 'DD/MM/YYYY')"></td>
                            	<td v-text="user.tipo_usuario"></td>
                            	<td>
                            		<span v-if="user.estatus == 'A'" class="badge badge-success">Activo</span>
                            		<span v-else class="badge badge-danger">Inactivo</span>
                            	</td>
                            	<td>
                            		<a href="#sign-in-dialog" id="access_link">Sign in</a>
                            		<button class="btn btn-sm" data-toggle="tooltip" data-placement="top" title="Dar baja">
                            			<span class="icon-cancel-2"></span>
                            		</button>
                            	</td>
                          	</tr>
                        </tbody>
                  	</table>
				</section>
				<!-- End section 4 -->
			</div>
			<!-- End content -->
		</div>
		<!-- End tabs -->

        <!-- Sign In Popup -->
        <div id="sign-in-dialog" class="zoom-anim-dialog mfp-hide">
            <div class="small-dialog-header">
                <h3>Sign In</h3>
            </div>
            <form>
                <div class="sign-in-wrapper">
                    <a href="#0" class="social_bt facebook">Login with Facebook</a>
                    <a href="#0" class="social_bt google">Login with Google</a>
                    <div class="divider"><span>Or</span></div>
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" class="form-control" name="email" id="email">
                        <i class="icon_mail_alt"></i>
                    </div>
                    <div class="form-group">
                        <label>Password</label>
                        <input type="password" class="form-control" name="password" id="password" value="">
                        <i class="icon_lock_alt"></i>
                    </div>
                    <div class="clearfix add_bottom_15">
                        <div class="checkboxes float-left">
                            <input id="remember-me" type="checkbox" name="check">
                            <label for="remember-me">Remember Me</label>
                        </div>
                        <div class="float-right"><a id="forgot" href="javascript:void(0);">Forgot Password?</a></div>
                    </div>
                    <div class="text-center"><input type="submit" value="Log In" class="btn_login"></div>
                    <div class="text-center">
                        Don’t have an account? <a href="javascript:void(0);">Sign up</a>
                    </div>
                    <div id="forgot_pw">
                        <div class="form-group">
                            <label>Please confirm login email below</label>
                            <input type="email" class="form-control" name="email_forgot" id="email_forgot">
                            <i class="icon_mail_alt"></i>
                        </div>
                        <p>You will receive an email containing a link allowing you to reset your password to a new preferred one.</p>
                        <div class="text-center"><input type="submit" value="Reset Password" class="btn_1"></div>
                    </div>
                </div>
            </form>
            <!--form -->
        </div>
        <!-- /Sign In Popup -->
	</div>
	<!-- end container -->
</main>

<?php 
Yii::app()->clientScript->registerScriptFile($assets .'/js/tabs.js', CClientScript::POS_END); 
Yii::app()->clientScript->registerScript('tabs', 'new CBPFWTabs(document.getElementById("tabs"));', CClientScript::POS_READY); 
Yii::app()->clientScript->registerScript('url', '
    var baseUrl = "'. Yii::app()->baseUrl .'";
    var rmt_url = "https://'. $_SERVER['SERVER_NAME'].'";
    var id_agencia = '. $_SESSION["agencia"]["id_agencia"] .';', CClientScript::POS_HEAD);
Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/bs-custom-file-input/dist/bs-custom-file-input.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/sweetalert2@8', CClientScript::POS_END);

Yii::app()->clientScript->registerCssFile('https://unpkg.com/vue-multiselect@2.1.0/dist/vue-multiselect.min.css');
Yii::app()->clientScript->registerScriptFile('https://unpkg.com/vue-multiselect@2.1.0', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/mi_agencia_vue.js?v='. time(), CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://maps.googleapis.com/maps/api/js?key=AIzaSyCF_fvJUWC4iQueGPKPyTNzJ_JLmY8nC4w', CClientScript::POS_END);
?>