<?php $assets= Yii::app()->baseUrl."/template/ansonika/assets"; ?>

<style>
	.invoice-title h2, .invoice-title h3 {
		display: inline-block;
	}

	.table > tbody > tr > .no-line {
		border-top: none;
	}

	.table > thead > tr > .no-line {
		border-bottom: none;
	}

	.table > tbody > tr > .thick-line {
		border-top: 2px solid;
	}

	.modal-backdrop {
		z-index: 0;
	}
</style>

<?php 
$importe=$recibo->importe/1.16; 
$iva_recibo=$importe * 0.16;
$total = $importe * 1.16;
?>

<div class="container">
	<div class="row">
		<div class="col-12">
			<div class="invoice-title">
				<h2>Factura</h2> <br><h3 class="pull-right"> Recibo #<?=$recibo->id_recibo?></h3>
			</div>
			<hr>
			<div class="row">
				<div class="col-6">
					<address>
						<strong>Fecha: </strong><?=date('d/m/Y H:m:s')?><br>
						<strong>Versión del CFDI: </strong> 3.3 <br>
					</address>
				</div>
			</div>
			<div class="row">
				<div class="col-6">
					<address>
						<strong>RFC: </strong> <?=$recibo->idAgencia->rfc?><br>
						<strong>Razon Social: </strong> <?=$recibo->idAgencia->razon_social?><br>
						<strong>Uso CFDI: </strong> G03 Gastos en general<br>
						<strong>Importe de recibo: </strong> $ <?=round($total)?><br>
					</address>
				</div>
				<div class="col-6 text-right">
					<address>
						<strong>Moneda/Tipo Cambio: </strong>MXN/1<br>
						<strong>Método de Pago: </strong> PUE Pago en una sola exhibición <br>
						<strong>Forma de Pago: </strong> 03 Transferencia electrónica de fondos <br>
					</address>
				</div>
			</div>
			
		</div>
	</div>

	<br><br>
	<form method="POST" action="/api/cfdi/FacturaApi" id="form-facturar">
		<div class="row">
			<div class="col-lg-12">
				<div class="panel panel-default">
					<div class="panel-body">
						<div class="table-responsive">
							<button type="button" class="btn btn-success" id="agregar_producto"><i class="fas fa-plus-circle"></i> Agregar</button>
							<table class="table table-condensed" id="formarFacturaDesglose">
								<thead>
									<tr>
										<!-- <td class="text-center"><strong>No. Factura</strong></td> -->
										<td class="text-right"><strong>Cantidad</strong></td>
										<td class="text-right"><strong>Cve. Prod/Serv</strong></td>
										<td class="text-center"><strong>Descripción</strong></td>
										<td class="text-center"><strong>Clave Unidad</strong></td>
										<td class="text-center"><strong>Unidad</strong></td>
										<td class="text-right"><strong>Importe</strong></td>
										<td class="text-right"><strong>Accion</strong></td>
									</tr>
								</thead>
								<tbody>
									<!-- foreach ($order->lineItems as $line) or some such thing here -->
									<tr id="datosDesglose" class="factura_1">
										<!-- <td class="text-right">
											1
										</td> -->
										<td class="text-right">
											1.00
										</td>
										<td class="text-right">
											90111500
										</td>
										<td class="text-center">
											SERVICIO DE HOSPEDAJE
										</td>
										<td class="text-right">
											E48
										</td>
										<td class="text-center">
											SERVICIO
										</td>
										<td class="text-right">
											<input type="text" name="Importes[]" class="suma_importe text-right" value="<?=round($importe,4)?>" onChange="sumaFacturas();">
										</td>
										<td class="text-center">
											<button type="button" class="btn btn-danger eliminar_producto"> <i class="fas fa-trash"></i> </button>
										</td>
									</tr>
								</tbody>
								<tfoot>
									<tr></tr>
									<tr>
										<!-- <td class="thick-line"></td> -->
										<td class="thick-line"></td>
										<td class="thick-line"></td>
										<td class="thick-line"></td>
										<td class="thick-line"></td>
										<td class="thick-line text-center"><strong>Subtotal:</strong></td>
										<td class="thick-line text-right">		
											<input type="text" name="suma_subtotal" id="suma_importe_subtotal" class="text-right" readonly disabled value="<?=round($importe,2)?>">
										</td>
									</tr>
									<tr>
										<!-- <td class="no-line"></td> -->
										<td class="no-line"></td>
										<td class="no-line"></td>
										<td class="no-line"></td>
										<td class="no-line"></td>
										<td class="no-line text-center"><strong>IVA 16%:</strong></td>
										<td class="no-line text-right">
											<input type="text" name="suma_iva" id="suma_importe_iva" class="text-right" readonly disabled value="<?=round($iva_recibo,2)?>">
										</td>
									</tr>
									<tr>
										<!-- <td class="no-line"></td> -->
										<td class="no-line"></td>
										<td class="no-line"></td>
										<td class="no-line"></td>
										<td class="no-line"></td>
										<td class="no-line text-center"><strong>Total</strong></td>
										<td class="no-line text-right">
											<input type="text" name="suma_importe" id="suma_importe_total" class="text-right" readonly disabled value="<?=round($total)?>">
										</td>
									</tr>
								</tfoot>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<br><br>
		<div class="row">
			<input type="hidden" name="FeFacturas[receptor_rfc]" value="<?=$recibo->idAgencia->rfc?>">
			<input type="hidden" name="FeFacturas[receptor_razon_social]" value="<?=$recibo->idAgencia->razon_social?>">
			<input type="hidden" name="FeFacturas[importe]" value="<?=$importe?>">
			<input type="hidden" name="FeFacturas[iva_porcentaje]" value="1.16">
			<input type="hidden" name="FeFacturas[subtotal]" value="<?=$importe?>">
			<input type="hidden" name="FeFacturas[iva]" value="<?=$iva_recibo?>">
			<input type="hidden" name="FeFacturas[total]" id="total_factura" value="<?=round($total,2)?>">
			<input type="hidden" name="id_agencia" value="<?=$recibo->idAgencia->id_agencia?>">
			<input type="hidden" name="id_recibo" value="<?=$recibo->id_recibo?>">
			<input type="hidden" name="descripcion" value="SERVICIO DE HOSPEDAJE">

			<input type="hidden" name="FeFacturas[moneda]" value="MXN">
			<input type="hidden" name="FeFacturas[forma_pago]" value="03">
			<input type="hidden" name="FeFacturas[metodo_pago]" value="PUE">
			<input type="hidden" name="FeFacturas[tipo_cambio]" value="1.00">
			<input type="hidden" name="FeFacturas[condiciones_pago]" value="CONTADO">
			

			<label><input type="checkbox" id="aceptoTimbrar" name="acepto" value="Acepto"><strong> Mis datos son Correctos</strong> | <a href="<?=Yii::app()->createUrl('site/miAgencia')?>">Editar Perfil</a> </label> <br><br>
		</div>
		<button type="button" name="enviar_factura" id="btn_facturar" class="btn-sm btn btn-danger">TIMBRAR</button><br><br>
	</form>
</div>


<div id="modal-factura" data-backdrop="static" data-keyboard="false" class="modal fade" aria-labelledby="flexModalLabel" aria-hidden="true" tab-index="-1">
	<div class="modal-dialog" style="width:auto; max-width:900px">
		<div class="modal-content">
			<div class="modal-header">
				<h4 id="modal-title">Facturacion Electrónica:</h4>
			</div>
			<div class="modal-body" id="response_factura">
				
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript">
	
	$(document).ready(function() {

		var tbody = $('#formarFacturaDesglose tbody');
		var fila_contenido = tbody.find('#datosDesglose').first().html();

		//Agregar fila nueva.
		$('#agregar_producto').click(function(){
			var num_fila = totalFilas() + 1;
			// console.log(num_fila);
			if (num_fila > 20) {
				// $("#btn_facturar").addClass('disabled');
				alert('El sistema solo permite 20 facturas para un recibo');
				return false;			
			}else{
				// var fila_nueva = $('<tr class="factura_'+num_fila+'"></tr>');
				var fila_nueva = $('<tr></tr>');
				fila_nueva.append(fila_contenido);
				tbody.append(fila_nueva);
				sumaFacturas();
			}
		});
		//Eliminar fila.
		$('#formarFacturaDesglose').on('click', '.eliminar_producto', function(){		
			$(this).parents('tr').eq(0).remove();
			sumaFacturas();
		});


		// facturar recibo
		$('body').on('click','#btn_facturar',function(){

			var total_original = $("#total_factura").val();
			var total_segmentado = $("#suma_importe_total").val();
			total_original = parseFloat(total_original).toFixed(2);
			total_segmentado = parseFloat(total_segmentado).toFixed(2);

			if ( $("#aceptoTimbrar").is(':checked') ) {

				if ( total_original == total_segmentado ) {

					// var numFilasTabla = totalFilas();

					$("#response_factura").empty();
					$("#response_factura").html("<div align='center' style='margin-top:20px'><img src='"+baseUrl+"/images/loader.gif'></div>");

					$("#modal-factura").modal('show');
					$.ajax({
						url: baseUrl + '/feFacturas/create/idRecibo/' + <?=$recibo->id_recibo?>,
						type: 'POST',
						data: $("#form-facturar").serialize(),
					})
					.done(function(html) {
						console.log(html);
						$("#response_factura").html(html);
					});
					
				} else {

					alert('El monto total sumado no coincide con el total del recibo.');
					return false;

				}

			} else {

				alert('Por favor, acepta que tus datos son correctos.')
				return false;
			}
		});
		
	});

	function sumaFacturas(){
		var subtotal = 0;
		var numFactura = 0;
		$('.suma_importe').each(function() {
			// numFactura++;
			if (!isNaN($(this).val())) {

				subtotal += Number($(this).val());

				// subtotal_por_factura = Number($(this).val());
				// var iva_por_factura = subtotal_por_factura * 0.16;
				// var total_por_factura = subtotal_por_factura * 1.16;

			}else{

				alert('Campo solo permite numeros');
				return false;

			}

			// $('.factura_'+numFactura).find('td').first().html(numFactura);


		});
		$('#suma_importe_subtotal').val(subtotal.toFixed(2));
		var iva_recibo = subtotal * 0.16; 
		var total = subtotal * 1.16;
		$('#suma_importe_iva').val(iva_recibo.toFixed(2));
		$('#suma_importe_total').val(total.toFixed(2));
	}

	function totalFilas(){
		var nFilas = $("#formarFacturaDesglose tbody tr").length;

		return nFilas;
	}
</script>