<?php

class FeFacturasController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		$rules = AuthFuncion::model()->findAll('controlador="'.Yii::app()->controller->id.'"');
		$array = array();
		foreach($rules as $row){

			$rule = array('allow',
						'actions'=>array($row->funcion),
						'roles'=>array($row->operacion),
					);
			array_push($array,$rule);
		}

		array_push($array,
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('*'),
			)
		);

		array_push($array,
			array('deny',  // deny all users
				'users'=>array('*'),
			)
		);

		return $array;

	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new FeFacturas;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['FeFacturas']))
		{
			$model->attributes=$_POST['FeFacturas'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_factura));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['FeFacturas']))
		{
			$model->attributes=$_POST['FeFacturas'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_factura));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new FeFacturas('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['FeFacturas']))
		{
                        $model->attributes=$_GET['FeFacturas'];
			
			
                   	
                       if (!empty($model->id_factura)) $criteria->addCondition("id_factura = '".$model->id_factura."'");
                     
                    	
                       if (!empty($model->fecha_creacion)) $criteria->addCondition("fecha_creacion = '".$model->fecha_creacion."'");
                     
                    	
                       if (!empty($model->folio)) $criteria->addCondition("folio = '".$model->folio."'");
                     
                    	
                       if (!empty($model->serie)) $criteria->addCondition("serie = '".$model->serie."'");
                     
                    	
                       if (!empty($model->fecha)) $criteria->addCondition("fecha = '".$model->fecha."'");
                     
                    	
                       if (!empty($model->moneda)) $criteria->addCondition("moneda = '".$model->moneda."'");
                     
                    	
                       if (!empty($model->forma_pago)) $criteria->addCondition("forma_pago = '".$model->forma_pago."'");
                     
                    	
                       if (!empty($model->metodo_pago)) $criteria->addCondition("metodo_pago = '".$model->metodo_pago."'");
                     
                    	
                       if (!empty($model->tipo_cambio)) $criteria->addCondition("tipo_cambio = '".$model->tipo_cambio."'");
                     
                    	
                       if (!empty($model->condiciones_pago)) $criteria->addCondition("condiciones_pago = '".$model->condiciones_pago."'");
                     
                    	
                       if (!empty($model->emisor_rfc)) $criteria->addCondition("emisor_rfc = '".$model->emisor_rfc."'");
                     
                    	
                       if (!empty($model->emisor_razon_social)) $criteria->addCondition("emisor_razon_social = '".$model->emisor_razon_social."'");
                     
                    	
                       if (!empty($model->emisor_calle)) $criteria->addCondition("emisor_calle = '".$model->emisor_calle."'");
                     
                    	
                       if (!empty($model->emisor_no_exterior)) $criteria->addCondition("emisor_no_exterior = '".$model->emisor_no_exterior."'");
                     
                    	
                       if (!empty($model->emisor_no_interior)) $criteria->addCondition("emisor_no_interior = '".$model->emisor_no_interior."'");
                     
                    	
                       if (!empty($model->emisor_colonia)) $criteria->addCondition("emisor_colonia = '".$model->emisor_colonia."'");
                     
                    	
                       if (!empty($model->emisor_referencia)) $criteria->addCondition("emisor_referencia = '".$model->emisor_referencia."'");
                     
                    	
                       if (!empty($model->emisor_estado)) $criteria->addCondition("emisor_estado = '".$model->emisor_estado."'");
                     
                    	
                       if (!empty($model->emisor_cp)) $criteria->addCondition("emisor_cp = '".$model->emisor_cp."'");
                     
                    	
                       if (!empty($model->emisor_municipio)) $criteria->addCondition("emisor_municipio = '".$model->emisor_municipio."'");
                     
                    	
                       if (!empty($model->emisor_localidad)) $criteria->addCondition("emisor_localidad = '".$model->emisor_localidad."'");
                     
                    	
                       if (!empty($model->emisor_pais)) $criteria->addCondition("emisor_pais = '".$model->emisor_pais."'");
                     
                    	
                       if (!empty($model->id_receptor)) $criteria->addCondition("id_receptor = '".$model->id_receptor."'");
                     
                    	
                       if (!empty($model->importe)) $criteria->addCondition("importe = '".$model->importe."'");
                     
                    	
                       if (!empty($model->descuento_porcentaje)) $criteria->addCondition("descuento_porcentaje = '".$model->descuento_porcentaje."'");
                     
                    	
                       if (!empty($model->descuento_importe)) $criteria->addCondition("descuento_importe = '".$model->descuento_importe."'");
                     
                    	
                       if (!empty($model->iva_porcentaje)) $criteria->addCondition("iva_porcentaje = '".$model->iva_porcentaje."'");
                     
                    	
                       if (!empty($model->subtotal)) $criteria->addCondition("subtotal = '".$model->subtotal."'");
                     
                    	
                       if (!empty($model->iva)) $criteria->addCondition("iva = '".$model->iva."'");
                     
                    	
                       if (!empty($model->total)) $criteria->addCondition("total = '".$model->total."'");
                     
                    	
                       if (!empty($model->descuento_motivo)) $criteria->addCondition("descuento_motivo = '".$model->descuento_motivo."'");
                     
                    	
                       if (!empty($model->importe_letras)) $criteria->addCondition("importe_letras = '".$model->importe_letras."'");
                     
                    	
                       if (!empty($model->ruta_local_xml)) $criteria->addCondition("ruta_local_xml = '".$model->ruta_local_xml."'");
                     
                    	
                       if (!empty($model->ruta_local_pdf)) $criteria->addCondition("ruta_local_pdf = '".$model->ruta_local_pdf."'");
                     
                    	
                       if (!empty($model->ruta_ftp_xml)) $criteria->addCondition("ruta_ftp_xml = '".$model->ruta_ftp_xml."'");
                     
                    	
                       if (!empty($model->ruta_ftp_pdf)) $criteria->addCondition("ruta_ftp_pdf = '".$model->ruta_ftp_pdf."'");
                     
                    	
                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");
                     
                    	
                       if (!empty($model->uuid_certificacion)) $criteria->addCondition("uuid_certificacion = '".$model->uuid_certificacion."'");
                     
                    	
                       if (!empty($model->fecha_certificacion)) $criteria->addCondition("fecha_certificacion = '".$model->fecha_certificacion."'");
                     
                    	
                       if (!empty($model->lugar_expedicion)) $criteria->addCondition("lugar_expedicion = '".$model->lugar_expedicion."'");
                     
                    	
                       if (!empty($model->num_cta_pago)) $criteria->addCondition("num_cta_pago = '".$model->num_cta_pago."'");
                     
                    	
                       if (!empty($model->original_folio)) $criteria->addCondition("original_folio = '".$model->original_folio."'");
                     
                    	
                       if (!empty($model->original_serie)) $criteria->addCondition("original_serie = '".$model->original_serie."'");
                     
                    	
                       if (!empty($model->original_fecha)) $criteria->addCondition("original_fecha = '".$model->original_fecha."'");
                     
                    	
                       if (!empty($model->original_monto)) $criteria->addCondition("original_monto = '".$model->original_monto."'");
                     
                    	
                       if (!empty($model->emisor_regimen)) $criteria->addCondition("emisor_regimen = '".$model->emisor_regimen."'");
                     
                    	
                       if (!empty($model->tipo_comprobante)) $criteria->addCondition("tipo_comprobante = '".$model->tipo_comprobante."'");
                     
                    			
                    $session['FeFacturas_records']=FeFacturas::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new FeFacturas('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['FeFacturas']))
			$model->attributes=$_GET['FeFacturas'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=FeFacturas::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='fe-facturas-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['FeFacturas_records']))
               {
                $model=$session['FeFacturas_records'];
               }
               else
                 $model = FeFacturas::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['FeFacturas_records']))
               {
                $model=$session['FeFacturas_records'];
               }
               else
                 $model = FeFacturas::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('FeFacturas Report');
		$pdf->SetSubject('FeFacturas Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("FeFacturas_002.pdf", "I");
	}
}
