	var crudServiceBaseUrl=baseUrl;


	var dataSource = new kendo.data.DataSource({
                            transport: {
                                read:  {						        
							        url: crudServiceBaseUrl + "/api/fefacturas",
							        dataType: "json"
						    	},
							    update: {
							        url: function(options){								        	
							        	return crudServiceBaseUrl + "/api/fefacturas/"+options.models[0].id_factura;
							        }, 
							        dataType: "json",
							        type:"PUT"								       
							    },
							    destroy: {
							        url: function(options){							        	
							        	return crudServiceBaseUrl + "/api/fefacturas/"+options.models[0].id_factura;
							        }, 
							      	dataType: "json",
							        type:"DELETE"
							    },
							    create: {
							        url: crudServiceBaseUrl + "/api/fefacturas",
							        dataType: "json",
							        type:"POST"
							    },
                                parameterMap: function(options, operation) {
                                    if (operation !== "read" && options.models) {
                                    	
                                    	return kendo.stringify(options.models[0]);
                                    }
                                }
                            },
                            batch: true,
                            pageSize: 10,
                         	
					schema: {
				        data: "data.fefacturas",
				        total: "data.totalCount",				        
				        model: {
				        id: 'id_factura',
				          fields: {
				          		'id_factura':{type:'string' ,editable: false, nullable: true},
									'fecha_creacion':{type:'string'},
									'folio':{type:'string'},
									'serie':{type:'string'},
									'fecha':{type:'string'},
									'moneda':{type:'string'},
									'forma_pago':{type:'string'},
									'metodo_pago':{type:'string'},
									'tipo_cambio':{type:'string'},
									'condiciones_pago':{type:'string'},
									'emisor_rfc':{type:'string'},
									'emisor_razon_social':{type:'string'},
									'emisor_calle':{type:'string'},
									'emisor_no_exterior':{type:'string'},
									'emisor_no_interior':{type:'string'},
									'emisor_colonia':{type:'string'},
									'emisor_referencia':{type:'string'},
									'emisor_estado':{type:'string'},
									'emisor_cp':{type:'string'},
									'emisor_municipio':{type:'string'},
									'emisor_localidad':{type:'string'},
									'emisor_pais':{type:'string'},
									'id_receptor':{type:'string'},
									'importe':{type:'string'},
									'descuento_porcentaje':{type:'string'},
									'descuento_importe':{type:'string'},
									'iva_porcentaje':{type:'string'},
									'subtotal':{type:'string'},
									'iva':{type:'string'},
									'total':{type:'string'},
									'descuento_motivo':{type:'string'},
									'importe_letras':{type:'string'},
									'ruta_local_xml':{type:'string'},
									'ruta_local_pdf':{type:'string'},
									'ruta_ftp_xml':{type:'string'},
									'ruta_ftp_pdf':{type:'string'},
									'estatus':{type:'number'},
									'uuid_certificacion':{type:'string'},
									'fecha_certificacion':{type:'string'},
									'lugar_expedicion':{type:'string'},
									'num_cta_pago':{type:'string'},
									'original_folio':{type:'string'},
									'original_serie':{type:'string'},
									'original_fecha':{type:'string'},
									'original_monto':{type:'string'},
									'emisor_regimen':{type:'string'},
									'tipo_comprobante':{type:'string'},

					        }           
					      }
				   }
				});


$("#grid_fefacturas").kendoGrid({

	dataSource: dataSource,
	toolbar: ["create", "excel"],
    columns:[
			
			{ field: 'id_factura', title: 'Id Factura', width: '200px'},
			{ field:  'fecha_creacion', title:  'Fecha Creacion', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'folio', title:  'Folio', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'serie', title:  'Serie', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'fecha', title:  'Fecha', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'moneda', title:  'Moneda', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'forma_pago', title:  'Forma Pago', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'metodo_pago', title:  'Metodo Pago', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'tipo_cambio', title:  'Tipo Cambio', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'condiciones_pago', title:  'Condiciones Pago', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_rfc', title:  'Emisor Rfc', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_razon_social', title:  'Emisor Razon Social', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_calle', title:  'Emisor Calle', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_no_exterior', title:  'Emisor No Exterior', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_no_interior', title:  'Emisor No Interior', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_colonia', title:  'Emisor Colonia', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_referencia', title:  'Emisor Referencia', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_estado', title:  'Emisor Estado', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_cp', title:  'Emisor Cp', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_municipio', title:  'Emisor Municipio', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_localidad', title:  'Emisor Localidad', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_pais', title:  'Emisor Pais', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'id_receptor', title:  'Id Receptor', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'importe', title:  'Importe', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'descuento_porcentaje', title:  'Descuento Porcentaje', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'descuento_importe', title:  'Descuento Importe', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'iva_porcentaje', title:  'Iva Porcentaje', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'subtotal', title:  'Subtotal', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'iva', title:  'Iva', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'total', title:  'Total', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'descuento_motivo', title:  'Descuento Motivo', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'importe_letras', title:  'Importe Letras', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'ruta_local_xml', title:  'Ruta Local Xml', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'ruta_local_pdf', title:  'Ruta Local Pdf', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'ruta_ftp_xml', title:  'Ruta Ftp Xml', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'ruta_ftp_pdf', title:  'Ruta Ftp Pdf', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'estatus', title:  'Estatus', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'uuid_certificacion', title:  'Uuid Certificacion', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'fecha_certificacion', title:  'Fecha Certificacion', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'lugar_expedicion', title:  'Lugar Expedicion', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'num_cta_pago', title:  'Num Cta Pago', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'original_folio', title:  'Original Folio', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'original_serie', title:  'Original Serie', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'original_fecha', title:  'Original Fecha', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'original_monto', title:  'Original Monto', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'emisor_regimen', title:  'Emisor Regimen', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'tipo_comprobante', title:  'Tipo Comprobante', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
						

			
            {command: [
			"edit",

	    	"destroy"
            ],
            title: "Opciones", width: "150px"
            }
         ],
			

  	selectable: "multiple",                      
  	pageable: {
	    refresh: true,
	    pageSizes: true
	},
	editable: "popup",
	excel: {
       fileName: "fefacturas_report.xlsx",
    },                
  	resizable: true,
  	reorderable: true,
  	//groupable: true | false,
    sortable: true,
  	filterable: {
      mode: "row"
    },
  scrollable: true
  });
