<?php
$this->breadcrumbs = array(
	'Solicitud Reservacions' => array('index'),
	$model->id_reservacion,
);
$agenciasMarkupController = Yii::app()->createController('agenciasMarkup')[0];
$datosCliente = DatosClientes::model()->find('id_reservacion=' . $model->id_reservacion);
$existeMarkup = false;
$precioReserva = $model->total;
if (!empty($model_markup)) {
	$existeMarkup = true;
	$precioReserva = $agenciasMarkupController->aplicaMarkupAsignados($precioReserva,$model_markup->markup,$model_markup->markup_rmt,'all');
}

// $agencia = Agencia::model()->find();
?>
<main>
	<div class="container margin_60">
		<div class="row">
			<div class="col-lg-8 add_bottom_15">
				<div class="card">
					<div class="card-body">
						<h5 class="card-title">Reservación #<?= $model->id_reservacion ?></h5>

						<div class="form_title">
							<h3><strong><i class="icon-ok"></i></strong>Reserva <small>Fecha de Reservación: <?= $this->dateFormat($model->log, 'd/m/y H:i') ?></small></h3>
							<p>
								Esta es una cotización generada desde el sistema de integración, la tarifa esta sujeta a cambios sin previo aviso.
							</p>

						</div>
						<div class="step">
							<p>
							<table class="table table-striped confirm">
								<tbody>
									<tr>
										<td>
											<strong>Cliente</strong>
										</td>
										<td>
											<?= $model->nombre_cliente . " " . $model->apellido_cliente ?>
										</td>
									</tr>
									<tr>
										<td>
											<strong>Telefono</strong>
										</td>
										<td><?= $datosCliente->telefono ?></td>
									</tr>
									<tr>
										<td><strong>E-mail</strong>
										</td>
										<td>

											<?= $datosCliente->email ?>
										</td>
									</tr>
								</tbody>
							</table>
							</p>
						</div>
						<!--End step -->

						<div class="form_title">
							<h3><strong><i class="icon-tag-1"></i></strong>Detalles de Reserva</h3>
							<p>
								Cotizaciòn hecha desde el sistema integrado de reservas UVAC ONLINE.
							</p>
						</div>
						<div class="step">
							<table class="table table-striped confirm">
								<tbody>
									<tr>
										<td>
											<strong>Hotel</strong>
										</td>
										<td><?= $model->idHotel->nombre_hotel ?></td>
									</tr>
									<tr>
										<td>
											<strong>Ubicación</strong>
										</td>
										<td><?= $model->idHotel->Destino->name ?>, <?= $model->idHotel->Destino->destinationsCode0->name ?>, <?= $model->idHotel->Destino->destinationsCode0->countryCode ?></td>
									</tr>
									<tr>
										<td>
											<strong>Check in</strong>
										</td>
										<td><?= $this->dateFormat($model->fecha_inicial, 'd/m/Y') ?></td>
									</tr>
									<tr>
										<td><strong>Check out</strong>
										</td>
										<td>
											<?= $this->dateFormat($model->fecha_final, 'd/m/Y') ?>
											<br>
										</td>
									</tr>
									<tr>
										<td><strong>Cuartos</strong>
										</td>
										<td><?= $model->num_habitaciones ?></td>
									</tr>
									<tr>
										<td><strong>Noches</strong>
										</td>
										<td><?= $model->num_noches ?></td>
									</tr>
									<tr>
										<td>
											<strong>Total</strong>
										</td>
										<td>
											$ <?= number_format($precioReserva, 2) ?> <small><?= $model->moneda ?></small>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
						<!--End step -->

						<div class="form_title">
							<h3><strong><i class="icon-users"></i></strong>Habitaciones y pasajeros</h3>
							<p>
								Información de habitaciones y pasajeros.
							</p>
						</div>
						<div class="step">

							<?php foreach ($desglose as $key => $des) : ?>
								<table class="table table-striped table-condensed">
									<tbody>
										<tr>
											<td>
												<h4><strong>Habitación: </strong> <?= $key + 1 ?></h4>
											</td>
											<td>
												<strong>Base: </strong> <?= $this->base($des->idbasehabitacion) ?>
											</td>
											<td>
												<strong>Categoría: </strong> <?= $des->idtipohabitacion->descripcion ?>
											</td>
											<td>
												<strong>Adultos: </strong> <?= $des->num_adultos ?>
											</td>
											<td>
												<strong>Menores: </strong> <?= $des->num_ninios ?>
											</td>
										</tr>
										<tr>
											<td>
												<strong>Pasajero</strong>
											</td>
											<td>
												<strong>
													Tipo
												</strong>
											</td>
											<td>
												<strong>Nombre</strong>

											</td>
											<td>

												<strong>Edad</strong>


											</td>
											<td></td>
										</tr>
										<?php

										$personas = ReservacionDesglosePersona::model()->findAll('id_desglose=' . $des->id_desglose);
										foreach ($personas as $pax => $per) : ?>

											<tr>
												<td>
													<?= $pax + 1 ?>
												<td>

													<?= $per->tipo == "A" ? 'Adulto' : 'Menor' ?>

												</td>
												<td>
													<?= $per->nombre ?>

												</td>
												<td>
													<?php if ($per->tipo != "A") : ?>
														<?= $per->edad ?>

													<?php endif ?>

												</td>
												<td></td>
											</tr>


										<?php endforeach ?>


									</tbody>
								</table>
							<?php endforeach ?>

						</div>
						<!--End step -->
					</div>
					<!-- end bodycard -->
				</div>
				<!-- end card -->
			</div>
			<!--End col -->

			<aside class="col-lg-4">
				<div class="box_style_1">
					<h3 class="inner">CONFIRMACIÓN</h3>
					<p style="width: 100%; text-align: center; border: 1px solid blue; color: blue; font-weight: bolder;">
						<!-- <input type="text" value="" class="input-form" style="width: 100%; text-align: center; border: 1px solid blue; color: blue; font-weight: bolder;"> -->
						<?= $model->code ?>
					</p>
					<hr>
					<a class="ud-btn btn-thm mb25 w-100" href="<?= Yii::app()->createUrl('formatos/cupon', array('id' => $model->id_reservacion)) ?>" target="_blank">IMPRIMIR</a>
					<a href="<?= Yii::app()->createUrl("reservacion/cancelarReserva", array('id_reservacion' => $model->id_reservacion)) ?>" class="ud-btn btn-dark mb25 me-4 w-100" onclick="return confirm('¿Seguro que quieres cancelar la reserva?')">CANCELAR</a>
				</div>
				<?php

				$this->renderPartial('//site/helper'); ?>
			</aside>

		</div>
		<!--End row -->
	</div>
	<!--End container -->
</main>


<!-- End main -->

<!-- <div id="toTop"></div> -->
<!-- Back to top button -->

<!-- Search Menu -->
<!-- <div class="search-overlay-menu">
		<span class="search-overlay-close"><i class="icon_set_1_icon-77"></i></span>
		<form role="search" id="searchform" method="get">
			<input value="" name="q" type="search" placeholder="Search..." />
			<button type="submit"><i class="icon_set_1_icon-78"></i>
			</button>
		</form>
	</div> -->
<!-- End Search Menu -->