<?php
$bookingData = json_decode($model->booking, true);
?>

<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #e0e0e0; background-color: #ffffff; color: #333333;">
    <!-- Logo -->
    <div style="text-align: left; margin-bottom: 20px;">
        <img src="/imagenes/logo-uvac.png" alt="UVAC Logo" style="max-width: 100px; height: auto;">
    </div>

    <!-- Título de la Confirmación y Folio -->
    <div style="display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid #cccccc; padding-bottom: 10px; margin-bottom: 15px;">
        <h2 style="font-size: 18px; color: #333333; margin: 0;">Confirmación de reservación</h2>
        <span style="font-size: 14px; color: #666666;">Fecha: <?php echo date('d M Y', strtotime($model->fecha_hora_recogida)); ?></span>
    </div>
    <p><strong>Folio:</strong> #<?php echo $model->referencia; ?></p>

    <!-- Detalles de Reservación -->
    <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
        <div>
            <h3 style="font-size: 16px; color: #333333; margin: 10px 0;">Datos de reservación</h3>
            <p style="font-size: 14px; line-height: 1.6; margin: 5px 0;">
                <strong>Tipo de traslado:</strong> <?php echo $model->tipo_traslado ?? $bookingData['tipotraslado']; ?><br>
                <strong>Tipo de vehículo:</strong> <?php echo $model->tipo_vehiculo ?? $bookingData['nombrevehiculo']; ?><br>
                <strong>Categoría del vehículo:</strong> <?php echo $bookingData['categoriavehiculo']; ?><br>
                <strong>Número de pasajeros:</strong> <?php echo $model->numero_de_pasajeros ?? $bookingData['cantidadpersonas']; ?><br>
                <strong>Maletas permitidas:</strong> <?php echo $bookingData['maletaspermitidas']; ?><br>
            </p>
        </div>
        <div>
            <h3 style="font-size: 16px; color: #333333; margin: 10px 0;">Datos del cliente</h3>
            <p style="font-size: 14px; line-height: 1.6; margin: 5px 0;">
                <?php echo $model->name; ?> <?php echo $model->lastname; ?><br>
                <?php echo $model->email; ?><br>
                <?php echo $model->phone; ?>
            </p>
        </div>
    </div>

    <!-- Detalles del traslado -->
    <div style="border-bottom: 1px solid #cccccc; padding-bottom: 20px; margin-bottom: 20px;">
        <h3 style="font-size: 16px; color: #333333; margin: 10px 0;">Detalles de reservación</h3>
        <p style="font-size: 14px; color: #333333; font-weight: bold; margin: 5px 0;">
            Traslado: <span style="font-weight: normal;">De <?php echo $model->aeropuerto ?? $bookingData['aeropuerto']; ?> a <?php echo $model->hotel ?? $bookingData['hotel']; ?></span>
        </p>
        
        <div style="display: flex; justify-content: space-between; text-align: center;">
            <div style="flex: 1;">
                <p style="font-size: 12px; color: #666666; margin: 5px 0;">Código de vuelo</p>
                <p style="font-size: 14px; color: #333333; font-weight: bold; margin: 0;"><?php echo $model->codigo_vuelo_ida ?? $bookingData['codigovuelo']; ?></p>
            </div>
            <div style="flex: 1;">
                <p style="font-size: 12px; color: #666666; margin: 5px 0;">Hora de vuelo</p>
                <p style="font-size: 14px; color: #333333; font-weight: bold; margin: 0;"><?php echo date("H:i", strtotime($model->hora_vuelo_ida)); ?>
                </p>
            </div>
            <div style="flex: 1;">
                <p style="font-size: 12px; color: #666666; margin: 5px 0;">Fecha de vuelo</p>
                <p style="font-size: 14px; color: #333333; font-weight: bold; margin: 0;">22/11/2024</p>
            </div>
        </div>
    </div>

    <!-- Desglose del Precio -->
    <div style="margin-bottom: 20px;">
        <h3 style="font-size: 16px; color: #333333; margin: 10px 0;">Desglose del precio</h3>
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="font-size: 14px; color: #666666; padding: 8px 0;">Precio del viaje:</td>
                <td style="text-align: right; font-size: 14px;"><?php echo number_format($bookingData['precioviaje'], 2); ?> <?php echo $bookingData['tipomoneda']; ?></td>
            </tr>
            <tr>
                <td style="font-size: 14px; color: #333333; font-weight: bold; padding: 8px 0;">Total:</td>
                <td style="text-align: right; font-size: 14px; font-weight: bold;"><?php echo number_format($model->precio_total, 2); ?> <?php echo $model->moneda; ?></td>
            </tr>
        </table>
    </div>

    <!-- Botón para Ver Reservación -->
    <div type="button" style="text-align: center; margin-top: 20px;">
        <a href="<?php echo "https://" . $_SERVER["SERVER_NAME"] . Yii::app()->createUrl('ReservacionTraslado/view', array('id' => $model->id_reservacion_traslado)); ?>" style="display: inline-block; padding: 10px 20px; font-size: 14px; color: #ffffff; background-color: #0066cc; text-decoration: none; border-radius: 5px;">Ver reserva</a>
    </div>


    <!-- Pie de Página -->
    <div style="font-size: 12px; color: #777777; text-align: center; margin-top: 20px; padding-top: 10px; border-top: 1px solid #cccccc;">
        Blvd Miguel Alemán 82, Zona Centro, Plaza Río, Boca del Río, 94290 México, Ver.<br>
        Whatsapp business: 229 909 8275
    </div>
</div>
