<section id="hero_2">
	<div class="intro_title">
		<h1>Place your order</h1>
		<div class="bs-wizard row">

			<div class="col-4 bs-wizard-step complete">
				<div class="text-center bs-wizard-stepnum">Cotizar</div>
				<div class="progress">
					<div class="progress-bar"></div>
				</div>
				<a href="cart.html" class="bs-wizard-dot"></a>
			</div>

			<div class="col-4 bs-wizard-step active">
				<div class="text-center bs-wizard-stepnum">Tu reserva</div>
				<div class="progress">
					<div class="progress-bar"></div>
				</div>
				<a href="#" class="bs-wizard-dot"></a>
			</div>

			<div class="col-4 bs-wizard-step disabled">
				<div class="text-center bs-wizard-stepnum">Terminado!</div>
				<div class="progress">
					<div class="progress-bar"></div>
				</div>
				<a href="confirmation.html" class="bs-wizard-dot"></a>
			</div>
		</div>
		<!-- End bs-wizard -->
	</div>
	<!-- End intro-title -->
</section>
<!-- End Section hero_2 -->

<main>
	<div id="position">
		<div class="container">
			<ul>
				<li><a href="#">Home</a>
				</li>
				<li><a href="#">Category</a>
				</li>
				<li>Page active</li>
			</ul>
		</div>
	</div>
	<!-- End position -->

	<div id="booking_tour" class="container margin_60">
		<div class="row">
			<div class="col-lg-8 add_bottom_15">
				<?php $form=$this->beginWidget('bootstrap.widgets.TbActiveForm',array(
		            'id'=>'reservacion-form',
		            'enableAjaxValidation'=>false,
		            'method'=>'post',
		            'action'=>Yii::app()->controller->createUrl('tourReservacion/create'),
		            'type'=>'',
		            'htmlOptions'=>array(
		            'enctype'=>'multipart/form-data',
		            'class'=>'form-horizontal'
		            )
		        )); ?>
				<div class="form_title">
					<h3><strong>1</strong>Tour solicitado</h3>
					<p>Información acerca del tour seleccionado.</p>
				</div>
				<div class="step">
					<h4 v-text="info_tour.nombre + ' - ' + info_tour.tipo + ' - ' + rooming.fecha_entrada"></h4>
					<p v-html="info_tour.descripcion"></p>
				</div>
				<div class="form_title">
					<h3><strong>2</strong>Detalle reserva</h3>
					<p>Complete el sgiuienteformulario</p>
				</div>
				<div class="step">
				</div>
				<?php echo $form->hiddenField($model,'id_tour',array('class'=>'form-control', 'value'=>$_SESSION['searchAct']['id_tour']));
				echo $form->hiddenField($model,'importe',array('class'=>'form-control','value'=>$_SESSION['tour_form']['importe'])); 
				echo $form->hiddenField($model,'adultos',array('class'=>'form-control', 'value'=>$_SESSION['searchAct']['num_adultos']));
				echo $form->hiddenField($model,'menores',array('class'=>'form-control', 'value'=>$_SESSION['searchAct']['num_ninios']));
				echo $form->hiddenField($model,'id_tarifa',array('class'=>'form-control', 'value'=>$_SESSION['tour_form']['id_tarifa']));
				echo $form->hiddenField($model,'libera_cupon',array('class'=>'form-control', 'value'=>1));
				$this->endWidget(); ?>
			</div>
			<aside class="col-lg-4">
				<div class="box_style_1">
					<h3 class="inner">- Detalles -</h3>
					<table class="table table_summary">
						<tbody>
							<tr>
								<td>Adultos</td>
								<td class="text-right" v-text="rooming.num_adultos"></td>
							</tr>
							<tr>
								<td>Menores</td>
								<td class="text-right" v-text="rooming.num_ninios"></td>
							</tr>
							<tr v-for="(pax_cost, index_tour) in info_tour.tarifas[rate_code].desglose">
                                <td v-if="pax_cost.tipo == 'Adulto'" v-text="'Adulto (Mayor a ' + pax_cost.edad_min + ' años)'"></td>
                                <td v-else-if="rooming.num_ninios > 0" v-text="'Menor (De ' + pax_cost.edad_min + ' a ' + pax_cost.edad_max  + ' años)'"></td>
                                <td v-if="pax_cost.tipo == 'Adulto' || rooming.num_ninios > 0" v-text="'$ ' + printTotalPasajero(info_tour.tarifas[rate_code], index_tour) + ' ' + info_tour.tarifas[rate_code].moneda" class="text-right"></td>
                            </tr>
							<tr class="total">
								<td>Costo total</td>
								<td class="text-right" v-text="'$ ' + printTotalReserva()"></td>
							</tr>
						</tbody>
					</table>
					<a class="btn_full" href="confirmation.html">Continuar</a>
					<a class="btn_full_outline" href="#"><i class="icon-right"></i> Continue shopping</a>
				</div>
				<div class="box_style_4">
					<i class="icon_set_1_icon-57"></i>
					<h4>Need <span>Help?</span></h4>
					<a href="tel://004542344599" class="phone">+45 423 445 99</a>
					<small>Monday to Friday 9.00am - 7.30pm</small>
				</div>
			</aside>
		</div>
	</div>
</main>

<?php 
Yii::app()->clientScript->registerScript('id', "
	var info_tour = ". $_POST["tour"] .";
	var rooming = ". $_POST["rooming"] .";
	var rate_code = ". $_POST["rate_code"] .";
	var id_usuario = ". Yii::app()->user->id .";
", CClientScript::POS_HEAD);
Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl ."/vue/booking_tour.js?v=". time(), CClientScript::POS_END);
?>