<!-- PRODUCCION -->
<?php $assets = Yii::app()->baseUrl . "/template/ansonika/assets"; ?>
<link rel="stylesheet" href="<?= $assets . '/css/admin.css'; ?>">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/hotel-datepicker@3.6.4/dist/css/hotel-datepicker.min.css">
<link rel="stylesheet" href="https://unpkg.com/vue-multiselect@2.1.0/dist/vue-multiselect.min.css">
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">

<link rel="stylesheet" href="https://<?=$_SERVER['SERVER_NAME']?>/js/datepicker/css/base.css" crossorigin="anonymous" />
<link rel="stylesheet" href="https://<?=$_SERVER['SERVER_NAME']?>/js/datepicker/css/tempusdominus-bootstrap-4.css" crossorigin="anonymous" />

<style>

	/*.modal-backdrop{
		z-index: 0;
	}*/

	/*.input-group input, .input-group input:focus{
		border: 1px solid #ced4da;
	}*/

	/*.modal-dialog {
		margin-top: 140px !important;
	}*/

	.strip_booking h3.activity_booking:before {
		content: "\21" !important;
	}

	.datepicker-dropdown {
		width: initial !important;
	}

	@media (max-width: 767px) {
		.margin_60 {
			padding-top: 70px;
		}
	}

	@media (min-width: 768px) {
		.margin_60 {
			padding-top: 120px;
			padding-bottom: 60px;
		}

		.datepicker-dropdown {
			width: initial !important;
		}
	}

	@media (min-width: 480px){
		.datepicker-dropdown {
			width: initial !important; 
		}
	}

	@media (min-width: 320px){
		.datepicker-dropdown {
			width: initial !important;
		}
	}

	.ribbon_3 span::before {
		left: 0;
		/* border-left: 3px solid #638908; */
		border-right: 3px solid transparent;
	}

	.ribbon_3.popular span::after,
	.ribbon_3.popular span::before {
		border-bottom: 3px solid transparent;
		border-top: 3px solid #bc6504;
	}

	.ribbon_3.popular span {
		background: linear-gradient(#ff9900 0%, #9c4c06 100%);
	}

	.multiselect__single {
		padding: 9px 0 9px 40px;

	}

	.multiselect__content-wrapper {
		width: auto;
		min-width: 100%;
	}

	.multiselect__option--highlight {

		background: #57b2ce;
	}

	.multiselect__option--disabled {
		color: #393737;
		font-weight: 700;
	}

	.multiselect__option--disabled {
		background: #ffffff !important; 
		/* color: #a6a6a6; */
	}

	#close-dp_estancia_web {
		height: 30px;
		font-size: 12px;
		padding: 5px 8px;
		background: #fff;

		color: #57b2ce;
	}

	.datepicker__month-day--first-day-selected,
	.datepicker__month-day--last-day-selected {
		background: #57b2ce;
	}
</style>

<main>
	<div class="margin_60 container" id="app">
		<div class="content">
			<form action="<?=Yii::app()->createUrl('transportacion/create')?>" method="post" id="form-transportacion">
				<div class="row">
					<div class="col-md-4 col-sm-4 col-xs-12" id="tools">
						<div class="form-row align-items-center">
							<div class="col-md-12 col-xs-12 pt-2">
								<h4>Transportación <i class="fa fa-car"></i></h4>
							</div>
							<div class="col-sm-12">
								<input type="hidden" name="idtour" class="eventus" value="0">
								<select class="form-control guests eventus" id="direccion" name="direccion">
									<option value="desdeAeropuerto">Aeropuerto -> Hotel</option>
									<option value="alAeropuerto">Hotel -> Aeropuerto</option>
								</select>
							</div>
							<div class="col-md-12 col-xs-12 pt-2">
								<div>
									<input type="hidden" name="id_hotel" value="" class="eventus" id="hotel">
									<input type="hidden" name="nombre_hotel" class="eventus" id="nombre_hotel">
									<input type="hidden" name="code" class="eventus" id="code">
									<!-- MODIFICAR CON EL CATALOGO DE TOURSTORES -->
									<input type="hidden" name="zona" class="eventus" id="zona">
									<input type="hidden" name="city" class="eventus" id="city">
									<v-multiselect v-model="model_destino" :options="options" group-label="tipo_destino" group-values="opciones" track-by="Codigo" label="Nombre" placeholder="Selecciona Hotel" open-direction="bottom" :searchable="true" :loading="isLoading" :internal-search="false" :clear-on-select="false" :close-on-select="true" :options-limit="30" :max-height="600" @search-change="loadDestinations" :preserve-search="true" :show-labels="false" autocomplete="off" @select="setDestino">
										<template slot="option" slot-scope="props">
											<span v-if="props.option.$isLabel">{{ props.option.$groupLabel }}</span>
											<span style="font-family: Quicksand, sans-serif">
												{{ props.option.Nombre }}
											</span>
										</template>
										<span slot="noResult">0 coincidencias. Modificar su búsqueda.</span>
									</v-multiselect>
								</div>
							</div>
							<div class="col-md-6 col-xs-12 pt-2">
								<div>
									<input type="hidden" name="servicio" value="redondo">
									<select class="form-control eventus" id="servicio" name="tipo_servicio">
										<option value="redondo">Viaje Redondo</option>
										<option value="sencillo">Viaje Sencillo</option>
									</select>
								</div>
							</div>
							<div class="col-md-6 col-xs-12 pt-2">
								<div>
									<select name="adultos" class="form-control eventus" id="adultos">
										<?php for ($i = 1; $i <= 14; $i++) {
											?>
											<option value="<?=$i?>"><?=$i?> Pasajeros</option>
											<?php	
										} ?>
									</select>
								</div>
							</div>
							<div class="col-md-12 col-xs-12 pt-2 d-none" id="estancia_sencillo">
								<div>
									<label class="animated-label" style="display: block;">Fecha de servicio</label>
									<!-- <input type="text" name="fecha_llegada" class="date-picker form-control eventus"> -->
									<!-- <input type="text" name="estancia" class="form-control eventus" placeholder="Fecha de servicio"> -->
									<input class="form-control has-value eventus calendar" type="hidden" data-type="date" name="fecha_salida" placeholder="Fecha Salida" id="fechaFin" data-date-format="dd/mm/yyyy" data-date-autoclose="true" autocomplete="off" value="<?=date('d/m/Y')?>" required="required" readonly="" v-model="rango_estancia.fecha_salida">

									<input class="form-control has-value eventus calendar" type="text" data-type="date" name="fecha_llegada" placeholder="Fecha Llegada" id="fechaIni" data-date-format="dd/mm/yyyy" data-date-autoclose="true" autocomplete="off" value="<?=date('d/m/Y')?>" required="required" readonly="" v-model="rango_estancia.fecha_entrada">
								</div>
							</div>
							<div class="col-md-12 col-xs-12 pt-2" id="estancia_redondo">
								<!-- <input type="hidden" name="fecha_llegada" class="eventus"> -->
								<!-- <input type="hidden" name="fecha_salida" class="eventus" v-model="rango_estancia.fecha_salida"> -->
								<div class="search-date-range main-search-date-range-js clearfix">
									<div class="search-date-range-arrive" style="width: 100%!important;">
										<label class="animated-label" style="display: block;">Estancia</label>
										<input id="dp_estancia_web" v-model="model_rango_estancia" type="text" class="form-control on-focus eventus" @click="toggleInput" autocomplete="off" required="" readonly="" />
									</div>
								</div>
							</div>
							<!-- <div class="col-md-4 col-xs-4 pt-2" id="hora_servicio">
								<div class="form-group">
									<label class="animated-label" style="display: block;">Hora de Servicio</label>
									<div class="input-group date" id="datetimepicker3" data-target-input="nearest">
										<input type="text" class="form-control datetimepicker-input" data-target="#datetimepicker3" data-toggle="datetimepicker" value="<?=date('h:i:s')?>" id="hour_service" readonly=""/>
										<div class="input-group-append" data-target="#datetimepicker3" data-toggle="datetimepicker">
											<div class="input-group-text"><i class="fas fa-clock"></i></div>
										</div>
									</div>
								</div>
							</div> -->
							<div class="col-md-12 col-xs-12 pt-2">
								<div>
									<select id="deluxe" class="form-control eventus" name="deluxe">
										<option value="0">Servicio Regular</option>
										<option value="1">Servicio Deluxe</option>
									</select>
								</div>
							</div>
							<div class="col-md-6 col-xs-6 pt-4 text-center d-none">
								<div>
									Precio Neto (MXN)
								</div>
							</div>
							<div class="col-md-6 col-xs-6 pt-4 text-center d-none">
								<div>
									<input type="hidden" name="tarifa_neta" class="eventus" id="tarifa_neta">
									$ <span id="totalneto"> --</span>
								</div>
							</div>
							<div class="col-md-6 col-xs-6 pt-4 text-center">
								<div>
									Total (MXN)
								</div>
							</div>
							<div class="col-md-6 col-xs-6 pt-4 text-center">
								<div>
									<input type="hidden" name="total" class="eventus" id="total">
									<input type="hidden" name="moneda" class="eventus" id="moneda" value="MXN">
									$ <span id="totalpublica"> --</span>
								</div>
							</div>
							<div class="col-md-12 col-xs-12 pt-4">
								<div>
									<input type="hidden" name="okpass" id="okpass">
									<button type="button" class="btn btn-block btn-success" id="btn_reservar">Reservar</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</form>
			
		</div>
	</div>
</main>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/vue@2"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/vue.resource/1.3.1/vue-resource.min.js"></script>
<script src="https://unpkg.com/vue-multiselect@2.1.0"></script>
<script type="text/javascript" src="<?=Yii::app()->baseUrl?>/vue/fecha.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/fecha@3.0.2/lib/fecha.umd.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/locale/es-do.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/hotel-datepicker@3.6.4/dist/js/hotel-datepicker.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/locales/bootstrap-datepicker.es.min.js"></script>

<!-- <script src="https://<?=$_SERVER['SERVER_NAME']?>/js/datepicker/js/base.js" crossorigin="anonymous"></script> -->
<script src="https://<?=$_SERVER['SERVER_NAME']?>/js/datepicker/js/tempusdominus-bootstrap-4.js" crossorigin="anonymous"></script>

<?php Yii::app()->clientScript->registerScript('rmt_url', '

	var rmt_url = "'.Yii::app()->baseUrl.'";

	', CClientScript::POS_HEAD); ?>
	<script type="text/javascript">
		$(function () {
			// $('#datetimepicker3').datetimepicker({
			// 	format: 'LT',
			// 	icons: {
			// 		up: "fas fa-chevron-up",
			// 		down: "fas fa-chevron-down"
			// 	},
			// });
		});

		$(document).ready(function() {
			$('#fechaIni').datepicker({
				format: 'dd/mm/yyyy',
				minDate: 'dateToday', 
				language: 'es',
				startDate: '-0d',
			});

			$('#fechaFin').datepicker({
				format: 'dd/mm/yyyy',
				minDate: 'dateToday', 
				language: 'es',
				startDate: '-0d',
				// startDate: '+3d',
			});
		});
		
		var fechaPermitido = "<?=$politicas['fecha']?>";

		$(document).on("change click", ".eventus", function(){
			// console.log('aqui')
			if ($('#direccion').val()=="alAeropuerto"){
				$('#servicio').val("sencillo");
				$('#servicio').prop('disabled', true);
				$('#estancia_redondo').addClass('d-none');
				$('#estancia_sencillo').removeClass('d-none');

				$('input[name=fecha_salida]').attr('type','text');
				$('input[name=fecha_llegada]').attr('type','hidden');
			}else{
				$('#servicio').prop('disabled', false);
				$('input[name=fecha_salida]').attr('type','hidden');
				$('input[name=fecha_llegada]').attr('type','text');
			}
			if ($('#direccion').val()=="desdeAeropuerto"){
				if ($('#servicio').val()=="sencillo"){
					$('#estancia_redondo').addClass('d-none');
					$('#estancia_sencillo').removeClass('d-none');
				}else{
					$('#estancia_sencillo').addClass('d-none');
					$('#estancia_redondo').removeClass('d-none');
				}
			}

			if ($("#deluxe").val()==1) {
				// var limit = 5;
				// $("#adultos").empty();
				// for (var i = 1; i <= limit; i++) {
				// 	$("#adultos").append('<option value="'+i+'">'+i+' Pasajeros</option>');
				// }
			}else{
				// var limit = 14;
				// $("#adultos").empty();
				// for (var i = 1; i <= limit; i++) {
				// 	$("#adultos").append('<option value="'+i+'">'+i+' Pasajeros</option>');
				// }
			}


			availTransportacion();
			return false;
		});

		Vue.component('v-multiselect', window.VueMultiselect.default);
		Vue.http.options.emulateJSON = true;
		var app = new Vue({
			el: '#app',
			data: {
				rmt_url: rmt_url,
				model_destino: '',
				options: [],
				isLoading: false,
				model_rango_estancia: "",
				rango_estancia: {
					fecha_entrada: "",
					fecha_salida: "",
				},
				hdp: false,
				settings_date: fechaPermitido
			},
			methods: {
				loadDestinations: function(query) {
					this.initOptions();
					if (query.length >= 3) {
						this.isLoading = true;
						this.$http.post(this.rmt_url + '/transportacion/SearchDestinations',{search:query}, {
							before(request) {
								if (this.previousRequest) {
									this.previousRequest.abort();
								}
								this.previousRequest = request;
							}
						}).then(function(response) {
							this.isLoading = false;
							var response_var = response.body;
							var array_destinos = response_var;
							var that = this;
							array_destinos.forEach(function(element) {
								that.options[0].opciones.push(element);
							});
						}, function() {
							// console.log('Error');
						});
					}
				},
				initOptions: function() {
					this.options = [];
					this.options.push({
						tipo_destino: "Hoteles",
						opciones: [],
					});
					// console.log(this.options)
				},
				setDestino: function(selectedOption, id) {
					var destino;
					destino = selectedOption.Codigo;
					$("#hotel").val(destino);
					$("#code").val(selectedOption.codeStore);
					$("#nombre_hotel").val(selectedOption.Nombre);
					$("#city").val(selectedOption.City);
					$("#zona").val(selectedOption.Zona);
					availTransportacion();
				},
				loadInfo(){
					var fecha_entrada = moment().format("DD/MM/YYYY");
					var fecha_salida = moment().add(3, 'days').format("DD/MM/YYYY");
					if (this.settings_date !== "") {
						fecha_entrada = moment(this.settings_date,"DD/MM/YYYY").format("DD/MM/YYYY");
						fecha_salida = moment(this.settings_date,"DD/MM/YYYY").add(3, 'days').format("DD/MM/YYYY");
					}
					this.model_rango_estancia = fecha_entrada + " - " + fecha_salida;
					this.rango_estancia = {
						fecha_entrada: fecha_entrada,
						fecha_salida: fecha_salida,
					};
				},
				toggleInput: function() {
					if(this.hdp == false) {
						$("#datepicker-dp_estancia_web").toggle();
						$(".datepicker__inner").toggle();
						this.hdp = true;
					}
				},
				formatoPrecio: (cant_dinero) => {
					let val = (cant_dinero / 1).toFixed(2).replace(',', '.')
					return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
				},
			},
			created(){
				this.loadInfo();
				if (this.settings_date !== "") {
					this.settings_date = moment(this.settings_date,"DD/MM/YYYY").format("DD/MM/YYYY");
				}
			}
		})

		var dp_web = document.getElementById('dp_estancia_web'); 

		// var settings_date = moment(fechaPermitido,"DD/MM/YYYY").format("DD/MM/YYYY");
		$('#fechaIni').datepicker('setStartDate', app.settings_date);
		$('#fechaFin').datepicker('setStartDate', app.settings_date);
		var settings_dp = {
			format: "DD/MM/YYYY",
			startOfWeek: 'sunday',
			startDate: app.settings_date,
			i18n: {
				night: 'Noche',
				nights: 'Noches',
				button: 'Cerrar',
				'day-names-short': ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab'],
				'day-names': ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
				'month-names-short': ['Ene', 'Feb', 'Mar', 'Abr', 'Mar', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
				'month-names': ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
				'info-more': 'Por favor seleccione la fecha de su estancia'
			},
			moveBothMonths: true
		};

		var datepicker_web = new HotelDatepicker(dp_web, settings_dp);

		dp_web.addEventListener('afterClose', function() {
			app.model_rango_estancia = $("#dp_estancia_web").val();
			var rango = app.model_rango_estancia.split("-");
			app.rango_estancia.fecha_entrada = rango[0].replace(/\s/g, "");
			app.rango_estancia.fecha_salida = rango[1].replace(/\s/g, "");
			$('#fechaIni').datepicker('setDate', app.rango_estancia.fecha_entrada);
			$('#fechaFin').datepicker('setDate', app.rango_estancia.fecha_salida);
			setTimeout(function(){ availTransportacion(); }, 500);
		}, false);

		function availTransportacion(){
			$.ajax({
				type: 'POST',
				url: '<?=Yii::app()->baseUrl?>/transportacion/avail',
				data: $('.eventus').serialize(),
				dataType: 'json',
				success: function(data){
					var response = data;
					var avail = response["avail"];

					var precio=app.formatoPrecio(avail['precio']);
					var pax=avail['adultos'];
					var totalpublica=app.formatoPrecio(avail['publica']);

					console.log(precio)
					$("#totalneto").empty().append(precio);
					$('#tarifa_neta').val(avail['precio']);
					$('#adultos').val(pax);
					$("#totalpublica").empty().append(totalpublica);
					$('#total').val(avail['publica']);

					$("#okpass").val(1);
				}
			});
		}

		$("#btn_reservar").click(function(event) {
			if ($("#hotel").val() !== "") {
				var tipo_servicio = $("#servicio").val();
				$("input[name=servicio]").val(tipo_servicio);
				setTimeout(function(){ 
					$("#form-transportacion").submit();	
				}, 1000);
			}else{
				alert('Elige destino para continuar');
				return false;
			}
		});

	</script>

<!-- 

**** cambiar lenguaje a español datepicker 
**** cuando es fecha simple y cambio la fecha y regreso a precio redondo la fecha se resetea a como lo tenia el rango del datepicker

-->