<style>
    :root {
        --altura_cajas: 40px;
        --font_size_sur4: 14px;
        --border_color: #e8e8e8;
        --bg_primary_transportacion: #28a745 !important;
        --color_theme_cupon: #e04f67;
    }

    #transportacionv1 .btn-success {
        background-color: var(--bg_primary_transportacion);
    }

    #transportacionv1 .btn.focus,
    #transportacionv1 .btn:focus {
        box-shadow: none !important;
    }

    #transportacion * {

        font-size: var(--font_size_sur4);
    }

    #transportacion label {
        margin: 0 !important;
    }


    #transportacionv1 .btn_transporte {
        background: white;
        color: #888;
        border-radius: 0;
        border: none;
        border-radius: 5px;
        border: 1px solid var(--border_color);
        width: 47%;
        height: var(--altura_cajas);
    }

    .strip_booking h3.activity_booking:before {
        content: "\21" !important;
    }

    .datepicker-dropdown {
        width: initial !important;
    }



    .multiselect__single {
        font-weight: 900;
        padding: 9px 0 9px 40px;

    }

    .multiselect__content-wrapper {
        width: auto;
        min-width: 100%;
    }

    .multiselect__option--highlight {

        background: #57b2ce;
    }

    .multiselect__option--disabled {
        color: #393737;
        font-weight: 700;
    }

    .multiselect__option--disabled {
        background: #ffffff !important;
        /* color: #a6a6a6; */
    }

    #close-dp_estancia_web {
        height: 30px;
        font-size: var(--font_size_sur4);
        padding: 5px 8px;
        background: #fff;

        color: #57b2ce;
    }

    .datepicker__month-day--first-day-selected,
    .datepicker__month-day--last-day-selected {
        background: #57b2ce;
    }

    #transportacionv1 .btn_transporte.selected_transporte {
        transition: 0.2s;
        background-color: var(--bg_primary_transportacion);
        color: white;

        border: 1px solid var(--border_color);
        border-radius: 5px;
    }

    .multiselect__input,
    .multiselect__single {
        min-height: calc(var(--altura_cajas) / 2);
        line-height: calc(var(--altura_cajas) / 2);
        font-size: var(--font_size_sur4);
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .btn {
        font-size: var(--font_size_sur4);
    }

    .btn_transporte:disabled {
        background: #c2c2c2 !important;
        color: #ffffff !important;
        cursor: not-allowed;
    }

    #pasajeros_aumentar:disabled {
        cursor: not-allowed;
    }

    .btn_transporte:disabled>i {
        color: #c2c2c2 !important;
    }

    .multiselect__select {
        width: 50px;
        height: var(--altura_cajas);
    }

    .multiselect__select:before {
        border-width: 8px 8px 0;
    }

    #transportacionv1 .label__form {

        /* font-size: var(--font_size_sur4); */
    }

    #tipo_ruta {

        align-items: center;
        /* border: 1px solid #ccc */
    }

    #tipo_ruta span {
        border: 1px solid var(--border_color);
        width: 40%;
        height: var(--altura_cajas);
    }

    #transportacionv1 .button_inc {
        width: 60px;
        color: black;
        display: flex;
        width: 60px;
        color: black;
        align-items: center;
        justify-content: center;
    }

    .button_inc,
    .nav-submit-button {
        text-indent: 0px;
        cursor: pointer;
    }

    .cant__pasajeros {
        font-size: var(--font_size_sur4);
        text-align: center;
        margin: auto;
    }

    #close-dp_estancia_web {
        height: 30px;
        font-size: var(--font_size_sur4);
        padding: 5px 8px;
        background: #fff;

        color: #57b2ce;
    }

    #dp_estancia_web {
        background-color: transparent;
    }

    #fechaIni,
    #fechaFin,
    #transportacionv1 .form-control {
        border: 1px solid var(--border_color);
        background-color: transparent;

    }

    .datepicker__month-day--first-day-selected,
    .datepicker__month-day--last-day-selected {
        background: #57b2ce;
    }

    .destino {
        background-color: white;
        padding: 1rem 1.5rem;
        border: 2px dashed var(--color_theme_cupon);
        border-radius: 5px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    }

    .destino .contenido .fechas {
        font-size: 14px;
        color: #000;
        margin-top: 10px;
    }

    .destino .tipo_viaje {
        font-size: 14px;
        color: #888;
    }

    .destino .contenido h3 {
        font-size: 20px;
        color: black;
        font-weight: 900;
    }

    .destino .contenido .tipo_ruta {
        font-size: 16px;
        color: black;
        /* font-weight: 900; */
    }

    .destino .contenido .pasajeros {
        font-size: 16px;
        margin: 10px 0;
    }

    .destino .contenido .pasajeros.separador {
        font-size: 30px;
        color: black;
        font-weight: 900;
    }

    .destino .contenido .pasajeros.tipo_servicio {
        font-size: 16px;
        margin: 10px 0;
    }

    .destino .contenido .tarifa_neta {
        font-size: 20px;
        font-weight: 900;

        text-align: end;
    }

    .icon_cupon {
        color: var(--color_theme_cupon);
    }

    .datepicker.datepicker-dropdown {
        top: 124px !important;
    }

    .tab-content {
        padding: 0;
        background-color: transparent;
        border: 0px solid #ddd;
        border-top: none;
        margin-bottom: 0;
        -webkit-border-bottom-right-radius: 0px;
        -webkit-border-bottom-left-radius: 0px;
        -moz-border-radius-bottomright: 0px;
        -moz-border-radius-bottomleft: 0px;
        border-bottom-right-radius: 0px;
        border-bottom-left-radius: 0px;
    }
</style>
<main>
    <div class="margin_60 container" id="transportacionv1" style="margin-top: 5em;">
        <div class="content">
            <div class="row">
                <div class="col-lg-6">
                    <div class="box_style_1">
                        <label class="label__form font-weight-bold m-0">Tipo de Ruta</label>
                        <div id="tipo_ruta" class="my-2 d-flex justify-content-between ">
                            <span class="text-center d-flex justify-content-center align-items-center font-weight-bold " style="font-size:var(--font_size_sur4);">{{modo.inicio}}</span>
                            <!-- <button class="btn btn-warning" >Intercambiar</button> -->
                            <i class=" icon-resize-horizontal-2 bg-info texto-white" style="    font-size: 31px; cursor: pointer; line-height: 4px; margin: 0; background: #019201; border-radius: 4px; color: white; padding: 0 3px; cursor:pointer;" style="font-size: 20px;" @click="changeModo(); validarTipoRuta();"></i>
                            <!-- <button class="btn btn-success"></button> -->
                            <span class="text-center d-flex justify-content-center align-items-center font-weight-bold " style="font-size:var(--font_size_sur4);">{{modo.fin}}</span>
                        </div>


                        <div class="my-2">
                            <label class="label__form font-weight-bold m-0">Destino</label>
                            <v-multiselect v-model="model_destino" :options="options" group-label="tipo_destino" group-values="opciones" track-by="Codigo" label="Nombre" placeholder="Selecciona un Hotel" open-direction="bottom" :searchable="true" :loading="isLoading" :internal-search="false" :clear-on-select="false" :close-on-select="true" :options-limit="30" :max-height="600" @search-change="loadDestinations" :preserve-search="true" :show-labels="false" autocomplete="off" @select="setDestino">
                                <template slot="option" slot-scope="props">
                                    <span v-if="props.option.$isLabel">{{ props.option.$groupLabel }}</span>
                                    <span style="font-family: Quicksand, sans-serif">
                                        {{ props.option.Nombre }}
                                    </span>
                                </template>
                                <span slot="noResult">0 coincidencias. Modificar su búsqueda.</span>
                            </v-multiselect>
                        </div>
                        <!-- <label class="label__form font-weight-bold ">Tipo de Viaje</label> -->
                        <div class="mt-3 d-flex justify-content-between" style="background-color: white;">
                            <button id="viaje_sencillo" class="btn btn_transporte btn_right" @click="btnSencillo"> <i class="icon-check text-white"></i> Viaje Sencillo</button>
                            <button id="viaje_redondo" class="btn btn_transporte selected_transporte btn_left" @click="btnRedondo"> <i class="icon-check text-white"></i> Viaje Redondo</button>
                        </div>

                        <div class="row">


                            <div class="col-md-6">

                                <div class="col-md-12 col-xs-12 pt-2  px-0">
                                    <div class="" id="estancia_sencillo">
                                        <label class="label__form font-weight-bold m-0" style="display: block;">Fecha de Servicio</label>
                                        <input class="form-control has-value eventus calendar" type="hidden" data-type="date" name="fecha_salida" placeholder="Fecha Salida" id="fechaFin" data-date-format="dd/mm/yyyy" data-date-autoclose="true" autocomplete="off" required="required" readonly="">
                                        <input class="form-control has-value eventus calendar" type="text" data-type="date" name="fecha_llegada" placeholder="Fecha Llegada" id="fechaIni" data-date-format="dd/mm/yyyy" data-date-autoclose="true" autocomplete="off" required="required" readonly="">
                                    </div>
                                </div>
                                <!-- <input type="hidden" name="fecha_llegada" class="eventus"> -->
                                <!-- <input type="hidden" name="fecha_salida" class="eventus" v-model="rango_estancia.fecha_salida"> -->
                                <div class="search-date-range main-search-date-range-js clearfix d-none" id="estancia_redondo">
                                    <div class="search-date-range-arrive" style="width: 100%!important;">
                                        <label class="label__form font-weight-bold m-0" style=" display: block;">Fechas de Servicios</label>
                                        <input id="dp_estancia_web" v-model="model_rango_estancia" type="text" class="form-control on-focus eventus" @click="toggleInput" autocomplete="off" required="" readonly="" />
                                    </div>
                                </div>


                            </div>
                            <div class="col-md-6">
                                <div class=" my-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="w-100 mt-3">
                                            <div class="d-flex justify-content-between">


                                                <button id="pasajeros_reducir" class="btn btn-info " @click="btnReducirPasajero();">
                                                    <i class="icon-minus"></i>
                                                </button>
                                                <div class=" w-100 d-flex align-items-center">
                                                    <br>
                                                    <p class="cant__pasajeros font-weight-bold">{{pasajeros.cantidad}} Pasajero(s)</p>
                                                </div>
                                                <button id="pasajeros_aumentar" class="btn btn-info " @click="btnAumentarPasajero();">
                                                    <i class="icon-plus"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>


                        <!-- <label class="label__form font-weight-bold">Tipo de Servicio</label> -->
                        <div class="py-1 d-flex justify-content-between" style="background-color: white;    ">
                            <button id="tipo_regular" class="btn btn_transporte btn_right" @click="btnRegular(); validarTipoServicio();"><i class="icon-check text-white"></i>Servicio Regular</button>
                            <button id="tipo_deluxe" class="btn btn_transporte selected_transporte btn_left" @click="btnDeluxe(); validarTipoServicio();"><i class="icon-check text-white"></i>Servicio Deluxe</button>
                        </div>
                        <div class="mt-3">
                            <!-- <div style="font-size: 30px;" class="d-lg-none d-xl-none d-block" v-if="changedInfo == false && updateInfo == false && availRequest.id_hotel != null">
                                <span class="icon_cupon currency_type">$</span> {{formatPrice(availRequest.total)}} <span class=" type_money">MXN</span>
                            </div>
                            <div style="font-size: 30px;" class="d-lg-none d-xl-none d-block" v-else>
                                <span class="icon_cupon currency_type">$</span> ----<span class=" type_money"></span>
                            </div> -->
                            <div class="text-right  mt-3">


                                <button class="btn  btn-info selected_transporte btn_reservar my-1" @click="actionAvailRequest" style="width: 100%; height:auto;"> COTIZAR</button>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-lg-6">

                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Traslados</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Términos y Condiciones</a>
                        </li>
                    </ul>

                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">

                            <div style="height: 200px; background:url(https://tourstores.com/transfers/images/transfer1.jpg); background-position: center center;
    background-size: cover;
    background-repeat: no-repeat;">
                                <!-- <img class="img-fluid w-100" src="" alt=""> -->

                            </div>


                        </div>
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <div class="pt-3 overflow-hidden" style="height: 200px; overflow-x:hidden;">
                                <h4>Transportación desde Aeropuerto de Cancun</h4>
                                <p>Las tarifas son por vehículo hasta 14 pasajeros.</p>
                                <h6>Servico Regular</h6>
                                <ul class="">
                                    <li>
                                        Transporte privado en camionetas de modelo reciente
                                    </li>
                                    <li>
                                        Salida inmediata

                                    </li>
                                    <li>
                                        Firma con tu nombre a tu llegada
                                    </li>
                                    <li>
                                        Asiento de bebe disponible
                                    </li>
                                </ul>
                                <h6>Servico Deluxe</h6>
                                <ul>
                                    <li>
                                        Transporte privado de lujo en vehículos GM Suburban o Mercedes Benz Viano de hasta 5 pasajeros</a>
                                    <li>
                                        Asientos de piel</a>
                                    </li>
                                    <li>
                                        Wifi</a>
                                    </li>
                                    <li>
                                        Agua embotellada y refrescos</a>
                                    </li>
                                    <li>
                                        Salida inmediata</a>
                                    </li>
                                    <li>
                                        Firma con tu nombre a tu llegada</a>
                                    </li>
                                    <li>
                                        Asiento para bebe disponibles</a>
                                    </li>
                                </ul>
                                <h6>TERMINOS Y CONDICIONES:</h6>
                                <ul>
                                    <li>
                                        El cupón de servicio te será solicitado al momento de registrarte en la taquilla o por el guía al momento de abordar
                                    </li>
                                </ul>

                                <h6>POLÍTICAS DE CANCELACIÓN</h6>
                                <ul>
                                    <li>
                                        Unicamente cancelando el servicio 48 horas antes de la salida, se reembolsará el 100% de la tarifa.
                                    </li>
                                    <li>
                                        Si se cancela el servicio faltando menos de 48 horas para la salida, no procede reembolso.
                                    </li>
                                </ul>

                            </div>
                        </div>
                    </div>
                    <div class="banners">
                        <div class="destino mt-2">
                            <div class="contenido">
                                <h3><i class="icon_cupon icon-location"></i> {{ (selectedDestino.Nombre) ? selectedDestino.Nombre: 'Selecciona un hotel'}}</h3>
                                <div class="tipo_ruta">
                                    De {{modo.inicio}} a {{modo.fin}} - {{(tipo_servicio) ? 'Regular' : 'Deluxe'}} ({{(tipo_viaje) ? 'Viaje redondo' : 'Viaje sencillo'}})
                                </div>
                                <div class="fechas">{{(tipo_viaje) ? 'Del ' +model_rango_estancia.trim().split('-')[0]+' a '+model_rango_estancia.trim().split('-')[1] : rango_estancia.fecha_entrada}}</div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="pasajeros">
                                        {{pasajeros.cantidad}} Pasajero{{(pasajeros.cantidad > 1)?'s.':'.'}}
                                    </div>
                                </div>

                                <div class="tarifa_neta d-flex justify-content-between align-items-center" v-if="changedInfo == false && updateInfo == false && availRequest.id_hotel != null">
                                    <button class="btn btn_transporte selected_transporte btn_reservar my-1" :disabled="availRequest.id_hotel == null" id="btn_enviarForm" @click="enviarFormulario()"> RESERVAR</button>
                                    <div style="font-size: 30px;">
                                        <span class="icon_cupon currency_type">$</span> {{formatPrice(availRequest.total)}} <span class=" type_money">MXN</span>
                                    </div>
                                </div>
                                <div class="tarifa_neta d-flex justify-content-between align-items-center" v-else>
                                    <button class="btn btn_transporte selected_transporte btn_reservar my-1" :disabled="availRequest.id_hotel == null" @click="enviarFormulario()"> RESERVAR</button>

                                    <div style="font-size: 30px;">
                                        <span class="icon_cupon currency_type">$</span> ----<span class=" type_money"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>

                <form action="<?= Yii::app()->createUrl('transportacion/create') ?>" method="post" id="form-transportacion">
                    <input type="hidden" name="idtour" class="eventus" value="0">
                    <input type="hidden" name="direccion" id="direccion" v-model="availRequest.direccion">
                    <input type="hidden" name="id_hotel" v-model="availRequest.id_hotel" class="eventus" id="hotel">
                    <input type="hidden" name="nombre_hotel" v-model="availRequest.nombre_hotel" class="eventus" id="nombre_hotel">
                    <input type="hidden" name="code" v-model="availRequest.code" class="eventus" id="code">
                    <input type="hidden" name="zona" v-model="availRequest.zona" class="eventus" id="zona">
                    <input type="hidden" name="city" v-model="availRequest.city" class="eventus" id="city">
                    <input type="hidden" name="servicio" v-model="availRequest.tipo_servicio">
                    <input type="hidden" name="tipo_servicio" id="servicio" v-model="availRequest.tipo_servicio">
                    <input type="hidden" name="adultos" id="adultos" v-model="availRequest.adultos">
                    <input type="hidden" name="fecha_salida" v-model="availRequest.fecha_salida">
                    <input type="hidden" name="fecha_llegada" v-model="availRequest.fecha_llegada">
                    <input type="hidden" name="deluxe" id="deluxe" v-model="availRequest.deluxe">
                    <input type="hidden" name="tarifa_neta" id="tarifa_neta" v-model="availRequest.tarifa_neta">
                    <input type="hidden" name="total" id="total" v-model="availRequest.total">
                    <input type="hidden" name="moneda" id="moneda" v-model="availRequest.moneda">
                    <input type="hidden" name="okpass" v-model="availRequest.okpass" id="okpass">
                </form>


            </div>


        </div>
    </div>
</main>


<?php


Yii::app()->clientScript->registerCssFile('https://cdn.jsdelivr.net/npm/hotel-datepicker@3.6.4/dist/css/hotel-datepicker.min.css');
Yii::app()->clientScript->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css');
Yii::app()->clientScript->registerCssFile('https://www.rutamayatravel.com/js/datepicker/css/base.css');
Yii::app()->clientScript->registerCssFile('https://www.rutamayatravel.com/js/datepicker/css/tempusdominus-bootstrap-4.css');



$assets = Yii::app()->baseUrl . "/template/ansonika/assets";
Yii::app()->clientScript->registerCssFile($assets . '/css/admin.css');
Yii::app()->clientScript->registerCssFile('https://unpkg.com/vue-multiselect@2.1.0/dist/vue-multiselect.min.css');
Yii::app()->clientScript->registerScriptFile('https://unpkg.com/vue-multiselect@2.1.0/dist/vue-multiselect.min.js', CClientScript::POS_END);

Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/vue/fecha.min.js?v=27', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('//cdn.jsdelivr.net/npm/fecha@3.0.2/lib/fecha.umd.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('//cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/locale/es-do.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('//cdn.jsdelivr.net/npm/hotel-datepicker@3.6.4/dist/js/hotel-datepicker.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('//cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('//cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/locales/bootstrap-datepicker.es.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('//www.rutamayatravel.com/js/datepicker/js/tempusdominus-bootstrap-4.js', CClientScript::POS_END);


Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/vue/transportacion_vue.js?v=' . time(), CClientScript::POS_END);
Yii::app()->clientScript->registerScript('transportacionParams', '
var rmt_url = "' . Yii::app()->baseUrl . '";
var fechaPermitido = "' . $politicas['fecha'] . '";
', CClientScript::POS_HEAD);
