Vue.component('v-multiselect', window.VueMultiselect.default);

var appTours = new Vue({
    el: '#tours',
    data: {
        array_pasajeros: {
            num_adultos: 2,
            num_menores: 0,
            edad_menores: []
        },
        options_edad_menores: [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17],
        habs_pax:[],
        model_rango_estancia: moment().format("DD/MM/YYYY") +  " - " + moment().add(3, 'days').format("DD/MM/YYYY"),
        
        model_code: 0,
        model_destino: '',
        model_destinationcode: 0,
        array_estancia: {
            fecha_entrada: moment().format("DD/MM/YYYY"),
            fecha_salida: moment().add(3, 'days').format("DD/MM/YYYY"),
        },

        rmt_url: rmt_url,
        api_url: rmt_url + '/api/',

        options_tours: [],
        isLoading: false,

        model_agencia_usuario: agencia_usuario,
        model_id_usuario: id_usuario,
    },
    created: function() {
        this.loadDestinations();
    },
    methods: {
        setPaxHabs: function() {
            element = event.currentTarget;
            op = element.getAttribute('data-op');
            pax = element.getAttribute('data-pax');
            if(pax == "adulto") {
                if(op == "add") {
                    if(this.array_pasajeros.num_adultos < 8) {
                        this.array_pasajeros.num_adultos++;
                    }
                } else {
                    if(this.array_pasajeros.num_adultos > 1) {
                        this.array_pasajeros.num_adultos--;
                    }
                }
            } else {
                this.setMenores(op);
            }
        },
        setMenores: function(op) {
            element = event.currentTarget;
            var edad_menores = [];
            if(op == "add") {
                if(this.array_pasajeros.num_menores < 5) {
                    this.array_pasajeros.num_menores++;
                    this.array_pasajeros.edad_menores.push({
                        no_menor: this.array_pasajeros.num_menores,
                        edad: 0,
                    });
                }
            } else {
                if(this.array_pasajeros.num_menores > 0) {
                    this.array_pasajeros.num_menores--;
                    this.array_pasajeros.edad_menores.pop();
                }
            }
        },
        setEdadMenor: function() {
            element = event.currentTarget;
            no_menor = element.getAttribute('data-menor');
            this.array_pasajeros.edad_menores[no_menor - 1].edad = event.target.value;
        },
        limitText: function(count) {
            return `and ${count} other countries`
        },
        loadDestinations: function() {
            this.$http.get(this.rmt_url + '/busqueda/busquedaDestinosTours').then(function(response){
                var response_tours = response.body;
                this.options_tours = response_tours;
            }, function(){
                console.log('Error');
            });
        },
       /* findDestinations: function(query) {
            this.options_tours.filter(tour => { 
                return tour.nombre.toLowerCase().includes(query.toLowerCase());
            });
        },*/
        setDestino: function(selectedOption, id) {
            this.model_code = selectedOption.code;
            this.model_destinationcode = selectedOption.destinationcode;
        },
        test_method: function() {
            console.log(event.target.value);
        },
        forceClose: function() {
        }
    }
});

var dp_tour_web = document.getElementById('dp_estancia_tours_web'); //$(".dp_estancia")[0];
var settings_tour_dp = {
    format: 'DD/MM/YYYY',
    startOfWeek: 'sunday',
    i18n: {
        night: 'Noche',
        nights: 'Noches',
        button: 'Cerrar',
        'day-names-short': ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab'],
        'day-names': ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        'month-names-short': ['Ene', 'Feb', 'Mar', 'Abr', 'Mar', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        'month-names': ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        'info-more': 'Por favor seleccione la fecha de su estancia'
    },
    moveBothMonths: true,
    onDayClick: function() {
        datepicker_tour_web.close();
    }
};
var datepicker_tour_web = new HotelDatepicker(dp_tour_web, settings_tour_dp);

dp_tour_web.addEventListener('afterClose', function () {
    appTours.model_rango_estancia = $("#dp_estancia_tours_web").val();
    var rango = appTours.model_rango_estancia.split("-");
    appTours.array_estancia = {
        fecha_entrada: rango[0].replace(/\s/g, ""),
        fecha_salida: rango[1].replace(/\s/g, ""),
    };
    $(".fecha_entrada").val(rango[0].replace(/\s/g, ""));
    $(".fecha_salida").val(rango[1].replace(/\s/g, ""));

}, false);

$('body').on('click', '.habsActPax', function() {
    var id_div = ".btnActPax";
    $(id_div).toggle();
});