var app = new Vue({
    el: '#vuebloqueo',
    data: {

        datosBloqueos: [],
        nombre_hotel: '',
        vista: false,
        price_sort: 'lower',
        estrellas_cant: 0,
        ordenFecha: 'newest',
        NUM_RESULTS: 4,
        pag: 1,

        categorias: [],
        api_url: rmt_url + "/api/",
        selected_estrellas: [],
        disponible_valor: null,

    },
    created: function () {
        this.javascripts();
    },
    mounted: function () {
       
        this.loadCategorias();
        this.loadBloqueos();
    },
    methods: {

        formatPrice(value) {
            //redondea siempre para arriba
            var redondear = Math.ceil(value);
            let val = (redondear / 1).toFixed(2).replace(',', '.')
            return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        },
      
        javascripts: function () {
            $('input').iCheck({
                checkboxClass: 'icheckbox_square-grey',
                radioClass: 'iradio_square-grey'
            }).on('ifChecked ifUnchecked', function () {
                $(this)[0].dispatchEvent(new Event("change"));
            });
        },
        loadBloqueos: function () {

            this.$http.get(encodeURI('https://www.rutamayatravel.com/sur4demo/bloqueos/getLista')).then(function (response) {
                this.datosBloqueos = response.body;
                this.javascripts();
            }, function () {
                console.log('Error');

            });

        },
        ValidarNoDisponibles: function () {

            if (this.disponible_valor == false) {
                this.$http.get(encodeURI('https://www.rutamayatravel.com/sur4demo/bloqueos/getNoDisponibles')).then(function (response) {
                    this.datosBloqueos = response.body;
                    this.javascripts();
                }, function () {
                    console.log('Error');

                });
            } else if (this.disponible_valor == true) {
                this.$http.get(encodeURI('https://www.rutamayatravel.com/sur4demo/bloqueos/getLista')).then(function (response) {
                    this.datosBloqueos = response.body;
                    this.javascripts();
                }, function () {
                    console.log('Error');

                });
            } else if (this.disponible_valor == null) {
                this.disponible_valor = false;
                this.ValidarNoDisponibles();
            }
        },
        cambiarVistaCuadros() {

            this.vista = true;

        },
        cambiarVistaLista() {

            this.vista = false;

        },
        loadCategorias: function () {
            this.$http.get(this.api_url + 'categorias?limit=5').then(function (response) {
                var response_categorias = response.body;
                this.categorias = response_categorias.data.categorias;
                this.javascripts();
            }, function () {
                console.log('Error');
            });
        },

    },
    computed: {
        //icon_search
        buscar_bloqueo: function () {

            var self = this;
            if (this.price_sort == "lower") {
                this.datosBloqueos.sort(function (a, b) {
                    return parseFloat(a.precio_doble) > parseFloat(b.precio_doble) ? 1 : parseFloat(a.precio_doble) < parseFloat(b.precio_doble) ? -1 : 0;
                })
            } else {
                this.datosBloqueos.sort(function (a, b) {

                    return parseFloat(a.precio_doble) > parseFloat(b.precio_doble) ? -1 : parseFloat(a.precio_doble) < parseFloat(b.precio_doble) ? 1 : 0;
                })
            }

            return this.datosBloqueos.filter(function (tarifa) {
                self.pag = 1;
                if (self.selected_estrellas.length > 0) {
                    return self.selected_estrellas.includes(parseInt(tarifa.Estrellas)) && tarifa.hotel_nombre.toLowerCase().includes(self.nombre_hotel.toLowerCase());
                } else {
                    return tarifa.hotel_nombre.toLowerCase().includes(self.nombre_hotel.toLowerCase());
                }

            });

        },

    }

})
