Vue.http.options.emulateJSON = true;

var app = new Vue({
    el: "#booking_list",
    data: { 
        api_url: rmt_url + "/api/",
        id_agencia: id_agencia,
        tipo_usuario: tipo_usuario,

        //variables generales
        loading_reservas: true,
        loading_activities: true,
        loading_tours: true,
        loading_recibos_agencia: true,
        loading_proximos_pagos: true,
        show_content: false,
        show_activitiy: false,
        show_tour: false,
        div_active: 'prox_pagos',

        //arreglos
        array_prox_pagos_bookings: [],
        array_prox_pagos_activities: [],
        array_prox_pagos_tours: [],
        days_prox_pagos: 7,
        array_bookings: [],
        array_activities: [],
        array_tours: [],

        recibos_agencia:[],

        //filtros
        search_reserva: "",
        search_customer_reserva: "",
        search_pax_reserva: "",
        order_fecha_reserva: "",

        search_activity: "",
        search_pax_activity: "",
        order_fecha_activity: "",

        search_tour: "",
        search_pax_tour: "",
        order_fecha_tour: "",

        search_idRecibo:'',

        //infinite scroll reservaciones
        show   : false, // display content after API request
        offset : 5,     // items to display after scroll
        display: 5,     // initial items
        trigger: 300,   // how far from the bottom to trigger infinite scroll
        end    : false, // no more resources

        // cuentas permitidas para facturar
        cuenta_cfdi: ['1','3','16','17'],
    },
    created: function(){
        this.loadBookings();
        this.loadActivities();
        this.loadTours();
        this.loadRecibos();
    },
    methods:{
        loadProxPagos: function() {
            var that = this;
            var now = moment(new Date());
            this.array_bookings.forEach(function(element) {
                var end = moment(element.fecha_limite);
                var duration_after = moment.duration(end.diff(now));
                var duration_before = moment.duration(now.diff(end));
                var days_after = duration_after.asDays();
                var days_before = duration_before.asDays();
                /*console.log(days_after + " después");
                console.log(days_before + " antes");*/

                if(days_after <= that.days_prox_pagos && days_after >= 0) {
                    that.array_prox_pagos_bookings.push(element);
                }

                if((0 - that.days_prox_pagos) <= days_before && days_after >= (0 - that.days_prox_pagos)) {
                    that.array_prox_pagos_bookings.push(element);
                }
            });

            this.array_activities.forEach(function(element) {
                var end = moment(element.fecha_limite);
                var duration_after = moment.duration(end.diff(now));
                var duration_before = moment.duration(now.diff(end));
                var days_after = duration_after.asDays();
                var days_before = duration_before.asDays();

                if(days_after <= that.days_prox_pagos && days_after >= 0) {
                    that.array_prox_pagos_activities.push(element);
                }

                if((0 - that.days_prox_pagos) <= days_before && days_after >= (0 - that.days_prox_pagos)) {
                    that.array_prox_pagos_activities.push(element);
                }
            });

            this.array_tours.forEach(function(element) {
                var end = moment(element.fecha_limite);
                var duration_after = moment.duration(end.diff(now));
                var duration_before = moment.duration(now.diff(end));
                var days_after = duration_after.asDays();
                var days_before = duration_before.asDays();

                if(days_after <= that.days_prox_pagos && days_after >= 0) {
                    that.array_prox_pagos_tours.push(element);
                }

                if((0 - that.days_prox_pagos) <= days_before && days_after >= (0 - that.days_prox_pagos)) {
                    that.array_prox_pagos_tours.push(element);
                }
            });

            this.loading_proximos_pagos = false;
        },
        loadBookings: function() {
             var url_reservas
            if (this.id_agencia==9) {

             url_reservas = this.api_url + 'reservacionRest?limit=50&sorter=[{"property":"log", "direction":"DESC"}]';
            }else{
             url_reservas = this.api_url + 'reservacionRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=}]&sorter=[{"property":"log", "direction":"DESC"}]';
            }
            //var url_reservas = this.api_url + 'reservacionRest?filter=[{"property":"id_agencia","value":' + 1293 + ',"operator":=}]';
            this.$http.get(encodeURI(url_reservas)).then(function(response) {
                this.array_bookings = response.body.data.reservacionRest;
                this.loading_reservas = false;
                this.show_content = true;
                this.loadProxPagos();
            }, function() {
                console.log('Error');
            });
        },
        loadActivities: function() {
            var url_activities
            if (this.id_agencia==9) {
             url_activities = this.api_url + 'activityReservacionRest?limit=50&sorter=[{"property":"log", "direction":"DESC"}]';
            }else{
             url_activities = this.api_url + 'activityReservacionRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=}]&sorter=[{"property":"log", "direction":"DESC"}]';
            }
            this.$http.get(encodeURI(url_activities)).then(function(response) {
                this.array_activities = response.body.data.activityReservacionRest;
                this.loading_activities = false;
                this.show_activitiy = true;
            }, function() {
                console.log('Error');
            });
        },
        loadTours: function() {
            var url_tours
             if (this.id_agencia==9) {
                 url_tours = this.api_url + 'tourReservacionRest?limit=50&sorter=[{"property":"log", "direction":"DESC"}]';
             }else{
                url_tours = this.api_url + 'tourReservacionRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=}]&sorter=[{"property":"log", "direction":"DESC"}]';
             }
            this.$http.get(encodeURI(url_tours)).then(function(response) {
                this.array_tours = response.body.data.tourReservacionRest;
                this.loading_tours = false;
                this.show_tour = true;
            }, function() {
                console.log('Error');
            });
        },
        loadRecibos: function(){
            this.$http.post(baseUrl + '/reservas/recibosAgencia', {agenciaUsuario:this.id_agencia}).then(function(response) {
                this.recibos_agencia = response.body.row;
                $("a").tooltip();
                this.loading_recibos_agencia = false;
            }, function() {
                console.log('Error');
            });
        },
        changeDiv: function() {
            element = event.currentTarget;
            this.div_active = element.getAttribute("data-div");
        },
        parseDate: function(date,format) {
            return moment(date).format(format);
        },
        round: function(value, decimals) {
            return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
        numberNigths: function (first, second) {
            var diff =  Math.floor(( Date.parse(second) - Date.parse(first) ) / 86400000);
            return diff;
        },
        scroll() {
            window.onscroll = ev => {
                if (
                    window.innerHeight + window.scrollY >= 
                    ($('#section-1')[0].offsetHeight)
                ) {
                    if(this.div_active == "reservas") {
                        if (this.display < this.array_bookings.length) {
                            this.display = this.display + this.offset;
                        } else {
                            this.end = true;
                        }
                    }
                }
            };
        },
    },
    computed: {
    	filteredBookings() {
            var that = this;
    		if(this.order_fecha_reserva == "newest") {
    			this.array_bookings.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? -1 : a < b ? 1 : 0;
				});
    		} else {
    			this.array_bookings.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? 1 : a < b ? -1 : 0;
				});
    		}
    		return this.array_bookings.filter(booking => { 
                return booking.idHotel.nombre_hotel.toLowerCase().includes(this.search_reserva.toLowerCase());
            }).filter(customer => {
                var name_customer = customer.nombre_cliente + " " + customer.apellido_cliente;
                return name_customer.toLowerCase().includes(this.search_customer_reserva.toLowerCase());
            }).filter(pax => {
                var array_return = pax.reservacionDesglosePersonas.some(pass => {
                    return pass.nombre.toLowerCase().includes(that.search_pax_reserva.toLowerCase());
                });
                return array_return;
            }).slice(0, this.display);
    	},
    	filteredActivities() {
    		if(this.order_fecha_activity == "newest") {
    			this.array_activities.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? -1 : a < b ? 1 : 0;
				});
    		} else {
    			this.array_activities.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? 1 : a < b ? -1 : 0;
				});
    		}
    		return this.array_activities.filter(activity => { 
                return activity.actividad.toLowerCase().includes(this.search_activity.toLowerCase());
            }).filter(pax => {
            	var name_pax = pax.nombre_cliente + " " + pax.apellido_cliente;
            	return name_pax.toLowerCase().includes(this.search_pax_activity.toLowerCase());
            });
    	},
    	filteredTours() {
    		if(this.order_fecha_tour == "newest") {
    			this.array_tours.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? -1 : a < b ? 1 : 0;
				});
    		} else {
    			this.array_tours.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? 1 : a < b ? -1 : 0;
				});
    		}
    		return this.array_tours.filter(tour => { 
                return tour.idTour.nombre.toLowerCase().includes(this.search_tour.toLowerCase());
            }).filter(pax => {
            	var name_pax = pax.cliente_nombre + " " + pax.cliente_apellido;
            	return name_pax.toLowerCase().includes(this.search_pax_tour.toLowerCase());
            });
    	},
        filteredReceipt(){
            return this.recibos_agencia.filter(recibo => { 
                return recibo.id_recibo.toLowerCase().includes(this.search_idRecibo.toLowerCase());
            });
        }
    },
    mounted() {
        // track scroll event
        this.scroll();
    }
});