Vue.http.options.emulateJSON = true;

var appBodas = new Vue({
    el: '#detalle_vue',
    data: {
        rmt_url: 'https://test.apituristico.com/rmt/WebServiceRMT.asmx',
        casate_url: 'https://test.apituristico.com/casateconmigo/WebServiceRMT.asmx',
        loading: true,
        show: false,
        //array_params: JSON.parse(array_params),
        roominglist: [],
        index_room: 0,
        aux_array: [],
        id_roominglist: 0,
        texto_editar: '',
    },
    created: function() {
        this.loadDetalleBoda();
    },
    methods: {
        loadDetalleBoda: function() {
            post_data = { usuario: "reservaciones2@grupoisamx.com", password: "demo", "agencia": btoa(401), "id_boda": id_boda };
            this.$http.post(encodeURI(this.casate_url + "/BodasRoominglist"), post_data).then(function(response) {
                var response_boda = response.body;
                this.roominglist = response_boda[0];
                this.loading = false;
                this.show = true;
            }, function() {
                console.log('Error');
            });
        },
        getIndexRoom: function(index,id_roominglist) {
          	this.index_room = index;
        	this.id_roominglist = id_roominglist;
          	this.texto_editar = "Editar habitación No. " + (parseInt(this.index_room) + 1);
          	this.aux_array = [];
          	var that = this;
          	if(typeof this.roominglist.RoomingList[this.index_room].adultos == "undefined") {
          	} else if(typeof this.roominglist.RoomingList[this.index_room].menores == "undefined" || this.roominglist.RoomingList[this.index_room].menores.length == 0) {
          		this.roominglist.RoomingList[this.index_room].adultos.forEach(function(element){
          			element.tipo = "adulto";
          			that.aux_array.push(element);
				});
        	} else if(this.roominglist.RoomingList[this.index_room].menores.length > 0) {
        		this.roominglist.RoomingList[this.index_room].adultos.forEach(function(element){
        			element.tipo = "adulto";
          			that.aux_array.push(element);
				});
				this.roominglist.RoomingList[this.index_room].menores.forEach(function(element){
					element.tipo = "menor";
          			that.aux_array.push(element);
				});
        	}
        },
        validateRoom: function() {
        	var total_pax = 0;

        	if(this.aux_array.length > 0) {
        		total_pax = this.aux_array.length;
        	}

        	return total_pax;
        },
        addPax: function() {
        	if(this.validateRoom() < 4) {
        		element = event.currentTarget;
	          	pax = element.getAttribute('data-pax');
	        	if(pax == "adulto") {

	        		this.aux_array.push({
	        			nombre: "",
	        			tipo: "adulto"
	        		});

	        	} else {

	        		this.aux_array.push({
	        			nombre: "",
	        			edad: 0,
	        			tipo: "menor"
	        		});

	        	}
        	}
        },
        deletePax: function(index) {
        	this.aux_array.splice(index, 1);
        },
        updateRoom: function() {
        	$('#btn_update').attr("disabled", "disabled");
        	var array_adultos = [], array_menores = [];
        	var that = this;
        	this.aux_array.forEach(function(element){
    			if(element.tipo == "adulto") {
    				array_adultos.push({
    					nombre: element.nombre,
    					edad: 30
    				});
    			} else {
    				array_menores.push({
    					nombre: element.nombre,
    					edad: element.edad
    				});
    			}
			});
			var json = {};
			json.boda = {};
			json.boda.id_boda = this.roominglist.id_boda;
			json.boda.Roominglist = {};
			json.boda.Roominglist.id_roominglist = this.id_roominglist;
			json.boda.Roominglist.adultos = array_adultos;
			json.boda.Roominglist.menores = array_menores;
			post_data = { usuario: "reservaciones2@grupoisamx.com", password: "demo", "agencia": btoa(401), "roomingRQ": JSON.stringify(json) };
            this.$http.post(encodeURI(this.casate_url + "/ActualizarRooming"), post_data).then(function(response) {
                var response_boda = response.body;
                console.log(response_boda);
                if(response_boda.success == true) {
                	this.roominglist.RoomingList[this.index_room].adultos = [];
                	this.roominglist.RoomingList[this.index_room].menores = [];
                	this.aux_array.forEach(function(element){
	        			if(element.tipo == "adulto") {
                			that.roominglist.RoomingList[that.index_room].adultos.push({ nombre: element.nombre });
	        			} else {
                			that.roominglist.RoomingList[that.index_room].menores.push({ nombre: element.nombre, edad: element.edad });
	        			}
					});
                	$('.bd-example-modal-lg').modal('hide');
                	$("#btn_update").removeAttr("disabled");
					Swal.fire({
						type: 'success',
						title: 'Correcto',
						text: 'Se ha actualizado el roominglist.'
					});
                } else {
                	$('.bd-example-modal-lg').modal('hide');
                	$("#btn_update").removeAttr("disabled");
                	Swal.fire({
						type: 'error',
						title: '¡Ops!',
						html: "Algo salió mal. <pre><code>" + JSON.stringify(response_boda) + "</pre></code>",
					});
                }
            }, function(e) {
                console.log(e);
                $('.bd-example-modal-lg').modal('hide');
            	$("#btn_update").removeAttr("disabled");
            	Swal.fire({
					type: 'error',
					title: '¡Ops!',
					html: "Algo salió mal. <pre><code>" + JSON.stringify(e.body) + "</pre></code>",
				});
            });
        },
        parseDate: function(date) {
            return moment(date).format('DD/MM/YYYY');
        },
        round: function(value, decimals) {
            return Number(Math.round(value+'e'+decimals)+'e-'+decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        }
    }
});