Vue.http.options.emulateJSON = true;
var appChangeCurrency = new Vue({
    el: '#breakdown-rate',
    data: {
        rmt_url: baseUrl,
        original_html: "",
        desglose_noches: desglose_noches,
    },
    created: function() {},
    mounted: function() {
        this.original_html = $("breakdown-rate").html();
    },
    methods: {
        changeCurrency: function(currency) {
            var table = document.getElementById("table-breakdown-rate");
            for (var i = 0, row; row = table.rows[i]; i++) {
                //iterate through rows
                //rows would be accessed using the "row" variable assigned in the for loop
                for (var j = 0, col; col = row.cells[j]; j++) {
                    //iterate through columns
                    //columns would be accessed using the "col" variable assigned in the for loop
                    if (i > 0 && j == 2) {
                        console.log(row.cells[j].replace("precio"));
                    }
                }
            }
        },
        aplicarMarkup(precio) {
            var new_price = precio;
            if (typeof localStorage.markup != "undefined") {
                // var valores = JSON.parse(localStorage.markup);
                var markup = this.markupAgencia;
                var markupRmt = this.markupRmt;
                new_price = this.convertToNumber(precio);
                new_price = parseFloat(new_price);
                if (markup != 0 && markup != null) {
                    markup = parseFloat(this.markupAgencia);
                    var ganancia = (100 - markup) / 100;
                    // var ganancia = new_price * (markup / 100);
                    new_price = new_price / ganancia;
                }

                if (markupRmt != 0 && markupRmt != null) {
                    markupRmt = parseFloat(this.markupRmt);
                    var gananciaRmt = (100 - markupRmt) / 100;
                    // var gananciaRmt = new_price * (markupRmt / 100);
                    new_price = new_price / gananciaRmt;
                }
            }

            return new_price;
        },
        printPrecio: function(precio, moneda, tasa_cambio = 0, show = 1) {
            new_price = this.aplicarMarkup(precio);
            if (moneda != this.currency) {
                if (moneda == "USD" && appCarritoHeader.currency == "MXN") {
                    if (tasa_cambio > 1) {
                        new_price = new_price * this.convertToNumber(tasa_cambio);
                    } else {
                        new_price = new_price * appCarritoHeader.usd_venta;
                    }
                } else if (moneda == "MXN" && appCarritoHeader.currency == "USD") {
                    if (tasa_cambio > 1) {
                        new_price = new_price / this.convertToNumber(tasa_cambio);
                    } else {
                        new_price = new_price / appCarritoHeader.usd_compra;
                    }
                }
            }

            if (show) {
                new_price = this.formatPrice(new_price);
            }
            return new_price;
        },
        printMoneda: function(moneda) {
            new_currency = moneda;
            if (moneda != this.currency) {
                if (this.currency == "MXN" && moneda == "USD") {
                    new_currency = "MXN";
                } else if (this.currency == "USD" && moneda == "MXN") {
                    new_currency = "USD";
                }
            }
            return new_currency;
        },
        getTotalCotiz: function(item, prov) {
            var that = this;
            var total = 0;
            var moneda = "";
            item.forEach(function(element) {
                if (prov == 3) {
                    var monto = that.printPrecio(element.precio, element.moneda, 1, 0);
                    total += monto;
                    moneda = that.printMoneda(element.moneda);
                } else {
                    Object.values(element.calendario.habitacion).forEach(function(element_hab) {
                        var monto = that.printPrecio(element_hab.Total.total, element_hab.Total.moneda, element.tasa_cambio, 0);
                        total += monto;
                        moneda = that.printMoneda(element_hab.Total.moneda);
                    });
                }
            });
            return "$ " + this.formatPrice(total) + " " + moneda;
        },
        formatPrice(cant_dinero) {
            let val = (cant_dinero / 1).toFixed(2).replace(',', '.')
            return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        },
        convertToNumber: function(numero) {
            if (typeof numero.replace(',', '') == undefined) {
                var number = numero;
            } else {
                var number = numero.replace(',', '');
            }
            return parseFloat(number);
        },
    }
});

var appTotalReserva = new Vue({
    el: "#stickyblock-start",
    data: {

    },
    created: function() {},
    mounted: function() {},
    methods: {

    }
});

