Vue.component('v-multiselect', window.VueMultiselect.default);

var appActivities = new Vue({
    el: '#activities',
    data: {
        array_pasajeros: {
            num_adultos: 2,
            num_menores: 0,
            edad_menores: []
        },
        options_edad_menores: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17],
        habs_pax: [],
        model_rango_estancia: "",

        model_code: 0,
        model_destino: '',
        model_destinationcode: 0,
        array_estancia: {
            fecha_entrada: "",
            fecha_salida: "",
        },

        rmt_url: rmt_url,
        api_url: rmt_url + '/api/',

        options_activities: [],
        isLoading: false,

        model_agencia_usuario: agencia_usuario,
        model_id_usuario: id_usuario,

        info_cotiz: [],
    },
    created: function () {
        this.loadInfoCotiz();
    },
    methods: {
        setPaxHabs: function () {
            element = event.currentTarget;
            op = element.getAttribute('data-op');
            pax = element.getAttribute('data-pax');
            if (pax == "adulto") {
                if (op == "add") {
                    if (this.array_pasajeros.num_adultos < 8) {
                        this.array_pasajeros.num_adultos++;
                    }
                } else {
                    if (this.array_pasajeros.num_adultos > 1) {
                        this.array_pasajeros.num_adultos--;
                    }
                }
            } else {
                this.setMenores(op);
            }
        },
        setMenores: function (op) {
            element = event.currentTarget;
            var edad_menores = [];
            if (op == "add") {
                if (this.array_pasajeros.num_menores < 5) {
                    this.array_pasajeros.num_menores++;
                    this.array_pasajeros.edad_menores.push({
                        no_menor: this.array_pasajeros.num_menores,
                        edad: 0,
                    });
                }
            } else {
                if (this.array_pasajeros.num_menores > 0) {
                    this.array_pasajeros.num_menores--;
                    this.array_pasajeros.edad_menores.pop();
                }
            }
        },
        setEdadMenor: function () {
            element = event.currentTarget;
            no_menor = element.getAttribute('data-menor');
            this.array_pasajeros.edad_menores[no_menor - 1].edad = event.target.value;
        },
        loadDestinations: function (query) {
            if (query.length >= 3) {
                this.isLoading = true;
                this.$http.get(encodeURI(this.rmt_url + '/busqueda/busquedaDestinosActivities?query=' + query), {
                    before(request) {
                        // abort previous request, if exists
                        if (this.previousRequest) {
                            this.previousRequest.abort();
                        }
                        // set previous request on Vue instance
                        this.previousRequest = request;
                    }
                }).then(function (response) {
                    var response_var = response.body;
                    this.options_activities = response_var;
                    this.isLoading = false;
                }, function () {
                    console.log('Error');
                });
            }
        },
        setDestino: function (selectedOption, id) {
            this.model_code = selectedOption.code;
            this.model_destinationcode = selectedOption.destinationcode;

            localStorage.setItem("options_activities", JSON.stringify(this.options_activities));
            localStorage.setItem("selected_option_activity", JSON.stringify(selectedOption));
        },
        loadInfoCotiz: function () {
            this.$http.get(this.rmt_url + "/carrito/getInfoCotiz?request=activity").then(function (response) {
                this.info_cotiz = response.body;
                // if (this.info_cotiz == "null") {
                    this.model_rango_estancia = moment().format("DD/MM/YYYY") + " - " + moment().add(3, 'days').format("DD/MM/YYYY");
                    this.array_estancia = {
                        fecha_entrada: moment().format("DD/MM/YYYY"),
                        fecha_salida: moment().add(3, 'days').format("DD/MM/YYYY"),
                    };
                // } else {
                //     this.model_rango_estancia = this.info_cotiz.from + " - " + this.info_cotiz.to;
                //     this.array_estancia = {
                //         fecha_entrada: this.info_cotiz.from,
                //         fecha_salida: this.info_cotiz.to,
                //     };
                //     this.model_code = this.info_cotiz.countries;
                //     this.model_destinationcode = this.info_cotiz.destinationCode;
                //     this.model_destino = JSON.parse(localStorage.getItem("selected_option_activity"));
                //     this.options_activities = localStorage.getItem("options_activities") === null ? [] : JSON.parse(localStorage.getItem("options_activities"));

                //     var num_menores = parseInt(this.info_cotiz.num_ninios);
                //     this.array_pasajeros = {
                //         num_adultos: parseInt(this.info_cotiz.num_adultos),
                //         num_menores: num_menores,
                //         edad_menores: []
                //     };
                //     if (num_menores > 0) {
                //         for (var i = 1; i <= num_menores; i++) {
                //             this.array_pasajeros.edad_menores.push({
                //                 no_menor: i,
                //                 edad: parseInt(this.info_cotiz.num_edad["edad_" + i]),
                //             });
                //         }
                //     }
                // }
            }, function () {
                console.log('Error');
            });
        },
        showCalculator: function () {
            $("#pax-calculator-activity").css("display", "block");
        },
        hideCalculator: function () {
            $("#pax-calculator-activity").css("display", "none");
        },
        test_method: function () {
            console.log(event.target.value);
        },
        submitForm: function () {
            if (this.model_destino == '') {
                Swal.fire({
                    title: "Por favor seleccione un destino",
                    timer: 2000,
                    timerProgressBar: true,
                    showConfirmButton: false,
                    didOpen: () => {
                        Swal.showLoading();
                    },
                });
            }else{
                document.getElementById('formCotizador').submit();
            }
        }
    }
});

var dp_act_web = document.getElementById('dp_estancia_activities_web'); //$(".dp_estancia")[0];
var settings_act_dp = {
    format: 'DD/MM/YYYY',
    startOfWeek: 'sunday',
    i18n: {
        night: 'Noche',
        nights: 'Noches',
        button: 'Cerrar',
        'day-names-short': ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab'],
        'day-names': ['Domingo', 'Lunes', 'Martes', 'MiÃ©rcoles', 'Jueves', 'Viernes', 'SÃ¡bado'],
        'month-names-short': ['Ene', 'Feb', 'Mar', 'Abr', 'Mar', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        'month-names': ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        'info-more': 'Por favor seleccione la fecha de su estancia'
    },
    moveBothMonths: true
};
var datepicker_Act_web = new HotelDatepicker(dp_act_web, settings_act_dp);

dp_act_web.addEventListener('afterClose', function () {
    appActivities.model_rango_estancia = $("#dp_estancia_activities_web").val();
    var rango = appActivities.model_rango_estancia.split("-");
    appActivities.array_estancia = {
        fecha_entrada: rango[0].replace(/\s/g, ""),
        fecha_salida: rango[1].replace(/\s/g, ""),
    };
    $(".fecha_entrada").val(rango[0].replace(/\s/g, ""));
    $(".fecha_salida").val(rango[1].replace(/\s/g, ""));

}, false);

$('body').on('click', '#btn_clear', function () {
    $("#select_habs").val(1);
    $(".select_adultos").val(1);
    $(".select_menores").val(0);
});

$('body').on('click', '.habsActPax', function () {
    var id_div = ".btnActPax";
    $(id_div).toggle();
});
