Vue.component('v-multiselect', window.VueMultiselect.default);

var appHoteles = new Vue({
    el: '#hoteles',
    data: {
        num_habs: 1,
        array_habs: [{
            no_hab: 1,
            num_adultos: 2,
            num_menores: 0,
            edad_menores: []
        }],
        options_edad_menores: [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17],
        habs_pax:[],
        model_rango_estancia: moment().format("DD/MM/YYYY") +  " - " + moment().add(3, 'days').format("DD/MM/YYYY"),
        model_destino: '',
        info_destino: '',

        rmt_url: rmt_url,
        api_url: rmt_url + '/api/',

		options: [],
	    isLoading: false,

	    model_agencia_usuario: agencia_usuario,
	    model_id_usuario: id_usuario,
    },
    created: function() {
    	this.initOptions();
    },
    methods: {
        addHabs: function() {
        	this.num_habs++;
        	this.array_habs.push({
                no_hab: this.num_habs,
	            num_adultos: 2,
	            num_menores: 0,
	            edad_menores: []
            });
        },
        removeHabs: function(hab) {
        	/*if(this.num_habs > 1) {
        		this.array_habs.pop();
        		this.num_habs--;
        	}*/
        	if(this.num_habs > 1) {
	        	this.num_habs--;
	        	for(var i = 0; i < this.array_habs.length; i++) {
	        		if((i + 1) >= hab ) {
	                	this.array_habs[i].no_hab--;
	        		}
	            }
	            this.array_habs.splice((hab - 1), 1);
        	}
        },
        setPaxHabs: function() {
        	element = event.currentTarget;
			op = element.getAttribute('data-op');
			pax = element.getAttribute('data-pax');
			hab = element.getAttribute('data-hab');
			if(pax == "adulto") {
				if(op == "add") {
					if(this.array_habs[hab - 1].num_adultos < 8) {
		            	this.array_habs[hab - 1].num_adultos++;
					}
				} else {
	            	if(this.array_habs[hab - 1].num_adultos > 1) {
	            		this.array_habs[hab - 1].num_adultos--;
	            	}
				}
			} else {
				this.setMenores(op, hab);
			}
        },
        setMenores: function(op, hab) {
            element = event.currentTarget;
            var edad_menores = [];
            if(op == "add") {
            	if(this.array_habs[hab - 1].num_menores < 5) {
	            	this.array_habs[hab - 1].num_menores++;
		            this.array_habs[hab - 1].edad_menores.push({
		                no_menor: this.array_habs[hab - 1].num_menores,
		                edad: 0,
		            });
            	}
            } else {
            	if(this.array_habs[hab - 1].num_menores > 0) {
	            	this.array_habs[hab - 1].num_menores--;
	            	this.array_habs[hab - 1].edad_menores.pop();
            	}
            }
        },
        setEdadMenor: function() {
            element = event.currentTarget;
            no_hab = element.getAttribute('data-hab');
            no_menor = element.getAttribute('data-menor');
            this.array_habs[no_hab - 1].edad_menores[no_menor - 1].edad = event.target.value;
        },
        clearForm: function() {
            this.array_habs = [{
                no_hab: 1,
                num_adultos: 2,
                num_menores: 0,
                edad_menores: ''
            }];
            this.model_rango_estancia = moment().format("DD/MM/YYYY") +  " - " + moment().format("DD/MM/YYYY");
            this.model_destino = '';
            this.setSelects();
        },
        setSelects: function() {
            $("#adultos_habitacion_1").val(2);
            $("#menores_habitacion_1 option[value='2']").prop("selected", true);
            console.log();
        },
        initOptions: function() {
        	this.options = [];
	        this.options.push({
	        	tipo_destino: "Destinos",
	        	opciones: [],
	        });

	        this.options.push({
	        	tipo_destino: "Zonas",
	        	opciones: [],
	        });

        	this.options.push({
	        	tipo_destino: "Hoteles",
	        	opciones: [],
	        });
        },
        limitText: function(count) {
        	return `and ${count} other countries`
        },
        loadDestinations: function(query) {
    		this.initOptions();
        	if(query.length > 3) {
        		this.isLoading = true;
        		this.$http.get(encodeURI(this.rmt_url + '/busqueda/busquedaDestinos?destino=' + query), {
	           		before(request) {
		            	// abort previous request, if exists
		            	if (this.previousRequest) {
		            		this.previousRequest.abort();
		            	}
		            	// set previous request on Vue instance
		            	this.previousRequest = request;
		            }
		        }).then(function(response) {
	                var response_var = response.body;
	                var array_destinos = response_var;
	                var that = this;
		            array_destinos.forEach(function(element){
		            	switch(element.Tipo) {
		            		case "Hotel":
			            		that.options[2].opciones.push(element);
		            			break;

		            		case "Zona":
			            		that.options[1].opciones.push(element);
		            			break;

		            		case "Destino":
			            		that.options[0].opciones.push(element);
		            			break;
		            	}
		            });
		            this.isLoading = false;
	            }, function() {
	                console.log('Error');
	            });
        	}
        },
        setDestino: function(selectedOption, id) {
            var destino;
            switch(selectedOption.Tipo) {
                case "Hotel":
                    destino = "h_" + selectedOption.Codigo;
                    break;

                case "Destino":
                    destino = "d_" + selectedOption.Codigo;
                    break;

                case "Zona":
                    destino = "z_" + selectedOption.Codigo;
                    break;
            }
            $(".destino").val(destino);

            sessionStorage.setItem("paisVal", "MX");
            sessionStorage.setItem("paisText", "México");
            sessionStorage.setItem("destinoText", selectedOption.Nombre);
            sessionStorage.setItem("destinoVal", destino);
            sessionStorage.setItem("tituloDestino", selectedOption.Nombre);
        },
        test_method: function() {
            console.log(event.target.value);
        }
    }
});

var dp_web = document.getElementById('dp_estancia_web'); //$(".dp_estancia")[0];
//var dp_mobile = document.getElementById('dp_estancia_mobile'); //$(".dp_estancia")[0];
var settings_dp = {
    format: 'DD/MM/YYYY',
    startOfWeek: 'sunday',
    i18n: {
        night: 'Noche',
        nights: 'Noches',
        button: 'Cerrar',
        'day-names-short': ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab'],
        'day-names': ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        'month-names-short': ['Ene', 'Feb', 'Mar', 'Abr', 'Mar', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        'month-names': ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        'info-more': 'Por favor seleccione la fecha de su estancia'
    },
    moveBothMonths: true
};
var datepicker_web = new HotelDatepicker(dp_web, settings_dp);
//var datepicker_mobile = new HotelDatepicker(dp_mobile, settings_dp);

dp_web.addEventListener('afterClose', function () {
    appHoteles.model_rango_estancia = $("#dp_estancia_web").val();
    var rango = appHoteles.model_rango_estancia.split("-");
    $(".fecha_entrada").val(rango[0].replace(/\s/g, ""));
    $(".fecha_salida").val(rango[1].replace(/\s/g, ""));

}, false);

/*dp_mobile.addEventListener('afterClose', function () {
    appHoteles.model_rango_estancia = $("#dp_estancia_mobile").val();
    var rango = appHoteles.model_rango_estancia.split("-");
    $(".fecha_entrada").val(rango[0].replace(/\s/g, ""));
    $(".fecha_salida").val(rango[1].replace(/\s/g, ""));
}, false);*/

$('body').on('click', '#btn_clear', function() {
    $("#select_habs").val(1);
    $(".select_adultos").val(1);
    $(".select_menores").val(0);
});

$('body').on('click', '.habsPax', function() {
	var id_div = ".btnPax" + $(this).attr('data-hab');
    $(id_div).toggle();
});

$('body').on('click', '.remove-hab', function() {
	var id_div = $(this).attr('data-hab');
    $(".btnPax" + id_div).toggle();
    appHoteles.removeHabs(id_div);
});