Vue.component('v-multiselect', window.VueMultiselect.default);

var picker;
var appTours = new Vue({
    el: '#tours',
    data: {
        array_pasajeros: {
            num_adultos: 2,
            num_menores: 0,
            edad_menores: []
        },
        options_edad_menores: [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17],
        habs_pax:[],
        model_date: moment().add(3, 'days').format("DD/MM/YYYY"),
        
        model_code_destino: 0,
        model_destino: '',

        rmt_url: rmt_url,
        api_url: rmt_url + '/api/',

        options_tours: [],
        isLoading: false,

        model_agencia_usuario: agencia_usuario,
        model_id_usuario: id_usuario,
    },
    created: function() {
        this.loadDestinations();
        var that = this;
        $.getScript( "https://cdn.jsdelivr.net/npm/pikaday/pikaday.js" )
			.done(function( script, textStatus ) {
	        	picker = new Pikaday({
	        		field: $('#datepicker')[0],
	        		format: 'DD/MM/YYYY',
	        		i18n: {
    					previousMonth : 'Mes anterior',
					    nextMonth     : 'Siguiente mes',
					    months        : ['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'],
					    weekdays      : ['Domingo','Lunes','Martes','Miércoles','Jueves','Viernes','Sábado'],
					    weekdaysShort : ['Dom','Lun','Mar','Mié','Jue','Vie','Sab']
					},
					minDate: moment().toDate(),
	        	});
				console.log( textStatus );
			})
			.fail(function( jqxhr, settings, exception ) {
				$( "div.log" ).text( "Triggered ajaxError handler." );
		});
    },
    methods: {
        setPaxHabs: function() {
            element = event.currentTarget;
            op = element.getAttribute('data-op');
            pax = element.getAttribute('data-pax');
            if(pax == "adulto") {
                if(op == "add") {
                    if(this.array_pasajeros.num_adultos < 13) {
                        this.array_pasajeros.num_adultos++;
                    }
                } else {
                    if(this.array_pasajeros.num_adultos > 1) {
                        this.array_pasajeros.num_adultos--;
                    }
                }
            } else {
                this.setMenores(op);
            }
        },
        setMenores: function(op) {
            element = event.currentTarget;
            var edad_menores = [];
            if(op == "add") {
                if(this.array_pasajeros.num_menores < 10) {
                    this.array_pasajeros.num_menores++;
                    this.array_pasajeros.edad_menores.push({
                        no_menor: this.array_pasajeros.num_menores,
                        edad: 0,
                    });
                }
            } else {
                if(this.array_pasajeros.num_menores > 0) {
                    this.array_pasajeros.num_menores--;
                    this.array_pasajeros.edad_menores.pop();
                }
            }
        },
        setEdadMenor: function() {
            element = event.currentTarget;
            no_menor = element.getAttribute('data-menor');
            this.array_pasajeros.edad_menores[no_menor - 1].edad = event.target.value;
        },
        limitText: function(count) {
            return `and ${count} other countries`
        },
        loadDestinations: function() {
            var that = this;
	        this.options_tours.push({
	        	tipo_destino: "Tours",
	        	opciones: [],
	        });

	        this.options_tours.push({
	        	tipo_destino: "Categoría",
	        	opciones: [],
	        });
            this.$http.get(this.rmt_url + '/busqueda/busquedaDestinosTours').then(function(response){
                var response_tours = response.body;
                response_tours.forEach(function(element){
	            	switch(element.tipo) {
	            		case "tour":
		            		that.options_tours[0].opciones.push(element);
	            			break;

	            		case "tipo":
		            		that.options_tours[1].opciones.push(element);
	            			break;
	            	}
	            });
            }, function(){
                console.log('Error');
            });
        },
        setDestino: function(selectedOption, id) {
            var destino;
            switch(selectedOption.tipo) {
                case "tour":
                    this.model_code_destino = "t_" + selectedOption.codigo;
                    break;

                case "tipo":
                    this.model_code_destino = "c_" + selectedOption.codigo;
                    break;
            }
        },
        setDate: function() {

        },
        test_method: function() {
            console.log(event.target.value);
        },
    }
});

$('body').on('click', '.habsTourPax', function() {
    var id_div = ".btnTourPax";
    $(id_div).toggle();
});

$('body').on('change', '#datepicker', function() {
    appTours.model_date = $(this).val();
});