Vue.component('v-multiselect', window.VueMultiselect.default);

var appAgencia = new Vue({
    el: '#info_agencia',
    data: {
    	baseUrl: baseUrl,
        rmt_url: rmt_url,
        api_url: rmt_url + baseUrl + '/api/',

        //info agencia
        id_agencia: id_agencia,
        info_agencia: [],
        array_users: [],
        array_states: [],
        array_countries: [],

        //aux imagenes
        img_logo: null,
        img_pie: null,
        file_logo: [],
        file_pie: [],

        //vars mapas
        marker: [],
        uluru: '',
        map: '',

        //multiselect
        isLoadingState: false,
        isLoadingCountry: false,

        //models aux
        stateLoad: null,
        countryLoad: null,
    },
    created: function() {
        this.loadInfoAgencia();
        this.loadUsers();
        this.loadStates();
        this.loadCountries();
        this.initComponents();
    },
    methods: {
        loadInfoAgencia: function() {
            this.$http.get(this.api_url + 'agenciasRest/' + this.id_agencia).then(function(response){
                this.info_agencia = response.body.data.agenciasRest;
                if(this.info_agencia.logotipo == null || this.info_agencia.logotipo == "") {
                	this.img_logo = "https://semantic-ui.com/images/wireframe/image.png";
                } else {
                	this.img_logo = this.rmt_url + "/imagenes/" + this.info_agencia.logotipo;
                }
                if(this.info_agencia.pie_flyer == null || this.info_agencia.pie_flyer == "") {
                	this.img_pie = "https://semantic-ui.com/images/wireframe/image.png";
                } else {
                	this.img_pie = this.info_agencia.pie_flyer;
                }
                this.initMap();
            }, function(ex){
                console.log(ex);
            });
        },
        loadUsers: function() {
            var url_usuarios = this.api_url + 'usuariosRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=}]';
            this.$http.get(encodeURI(url_usuarios)).then(function(response){
                this.array_users = response.body.data.usuariosRest;
            }, function(ex){
                console.log(ex);
            });
        },
        loadStates: function() {
            this.$http.get(this.api_url + 'estadosmex/').then(function(response){
                this.array_states = response.body.data.estadosmex;
                this.findState();
            }, function(ex){
                console.log(ex);
            });
        },
        loadCountries: function() {
            this.$http.get(this.api_url + 'paisRest/').then(function(response){
                this.array_countries = response.body.data.paisRest;
                this.initComponents();
                this.findCountry();
            }, function(ex){
                console.log(ex);
            });
        },
        updateInfoAgencia: function(tipo) {
        	switch(tipo) {
        		case 'general':
        			$("btn_general").addClass("disabled");
        			var post_data = { calle_agencia: this.info_agencia.calle_agencia, celular: this.info_agencia.celular, contacto: this.info_agencia.contacto, cp_agencia: this.info_agencia.cp_agencia, cruzamientos_agencia: this.info_agencia.cruzamientos_agencia, email_agencia: this.info_agencia.email_agencia, id_ciudad_agencia: this.info_agencia.id_ciudad_agencia, id_colonia_agencia: this.info_agencia.id_colonia_agencia, id_estado_agencia: this.info_agencia.id_estado_agencia, id_pais_agencia: this.info_agencia.id_pais_agencia, municipo_agencia: this.info_agencia.municipo_agencia, nombre_agencia: this.info_agencia.nombre_agencia, num_exterior_agencia: this.info_agencia.num_exterior_agencia, num_interior_agencia: this.info_agencia.num_interior_agencia, puesto: this.info_agencia.puesto, skype_agencia: this.info_agencia.skype_agencia, tel_agencia: this.info_agencia.tel_agencia, url_agencia: this.info_agencia.url_agencia };
		            this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(post_data)).then(function(response){
		                var response_var = response.body;
        				$("btn_general").removeClass("disabled");
		                if(response_var.success == "true") {
		                	this.loadInfoAgencia();
		                    Swal.fire({
		                        type: 'success',
		                        title: "Correcto",
		                        text: "Se han actualizado los datos de su agencia.",
		                    });
		                } else {
		                    Swal.fire({
		                        type: 'error',
		                        title: "¡Ops!",
		                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
		                    });
		                }
		            }, function(ex){
		                console.log(ex);
		            });
        		break;

        		case 'fiscal':
        			$("btn_fiscal").addClass("disabled");
        			var post_data = { calle_fiscal: this.info_agencia.calle_fiscal, cp_fiscal: this.info_agencia.cp_fiscal, cruzamientos_fiscal: this.info_agencia.cruzamientos_fiscal, id_ciudad_fiscal: this.info_agencia.id_ciudad_fiscal, id_colonia_fiscal: this.info_agencia.id_colonia_fiscal, id_estado_fiscal: this.info_agencia.id_estado_fiscal, id_pais_fiscal: this.info_agencia.id_pais_fiscal, municipio_fiscal: this.info_agencia.municipio_fiscal, num_exterior_fiscal: this.info_agencia.num_exterior_fiscal, num_interior_fiscal: this.info_agencia.num_interior_fiscal, razon_social: this.info_agencia.razon_social, rfc: this.info_agencia.rfc };
		            this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(post_data)).then(function(response){
		                var response_var = response.body;
        				$("btn_fiscal").removeClass("disabled");
		                if(response_var.success == "true") {
		                    this.loadInfoAgencia();
		                    Swal.fire({
		                        type: 'success',
		                        title: "Correcto",
		                        text: "Se han actualizado los datos de su agencia.",
		                    });
		                } else {
		                    Swal.fire({
		                        type: 'error',
		                        title: "¡Ops!",
		                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
		                    });
		                }
		            }, function(ex){
		                console.log(ex);
		            });
        		break;

        		case 'logo':
        			$("btn_logo").addClass("disabled");
        			var post_data = { logotipo: this.id_agencia + "-" + this.info_agencia.logotipo.replace(/\s/g, "-") };
		            this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(post_data)).then(function(response){
		                var response_var = response.body;
        				$("btn_logo").removeClass("disabled");
		                if(response_var.success == "true") {
		                	this.uploadImage("logo");
		                    this.loadInfoAgencia();
		                    Swal.fire({
		                        type: 'success',
		                        title: "Correcto",
		                        text: "Se han actualizado los datos de su agencia.",
		                    });
		                } else {
		                    Swal.fire({
		                        type: 'error',
		                        title: "¡Ops!",
		                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
		                    });
		                }
		            }, function(ex){
		                console.log(ex);
		            });
        		break;

        		case 'pie':
        			$("btn_pie").addClass("disabled");
        			var post_data = { pie_flyer: this.id_agencia + "-" + this.info_agencia.pie_flyer.replace(/\s/g, "-") };
		            this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(post_data)).then(function(response){
		                var response_var = response.body;
        				$("btn_pie").removeClass("disabled");
		                if(response_var.success == "true") {
		                	this.uploadImage("pie");
		                    this.loadInfoAgencia();
		                    Swal.fire({
		                        type: 'success',
		                        title: "Correcto",
		                        text: "Se han actualizado los datos de su agencia.",
		                    });
		                } else {
		                    Swal.fire({
		                        type: 'error',
		                        title: "¡Ops!",
		                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
		                    });
		                }
		            }, function(ex){
		                console.log(ex);
		            });
        		break;

        		case 'ubicacion':
        			$("btn_ubicacion").addClass("disabled");
        			this.info_agencia.ubicacion = this.marker.position.toUrlValue();
        			var post_data = { ubicacion: this.info_agencia.ubicacion };
		            this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(post_data)).then(function(response){
		                var response_var = response.body;
        				$("btn_ubicacion").removeClass("disabled");
		                if(response_var.success == "true") {
		                    this.loadInfoAgencia();
		                    Swal.fire({
		                        type: 'success',
		                        title: "Correcto",
		                        text: "Se han actualizado los datos de su agencia.",
		                    });
		                } else {
		                    Swal.fire({
		                        type: 'error',
		                        title: "¡Ops!",
		                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
		                    });
		                }
		            }, function(ex){
		                console.log(ex);
		            });
        		break;


        	}
        },
        uploadImage: function(tipo) {
            var data = new FormData();
            switch(tipo) {
            	case "logo":
        			data.append("tipo", "logo");
            		data.append("img", this.file_logo);
            		break;

            	case "pie":
        			data.append("tipo", "pie");
            		data.append("img", this.file_pie);
            		break;
            }
            data.append("id_agencia", this.id_agencia);
            this.$http.post(this.rmt_url + this.baseUrl + '/agencias/uploadImage/', data).then(function(response) {
                var response_var = response.body;
            }, function(e) {
                $("#btnSaveChanges").removeClass("disabled");
                console.log(e);
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Problema al subir la imagen. <pre><code>" + JSON.stringify(e.body) + "</pre></code>",
                });
            });
        },
        setState: function(selectedOption, id) {
        	this.info_agencia.id_estado_agencia = selectedOption.id_estadosmex;
        },
        setCountry: function(selectedOption, id) {
        	this.info_agencia.id_pais_agencia = selectedOption.id_pais;
        },
        findState: function() {
        	var that = this;
        	var filterState = this.array_states.filter(function(state) {
				return state.id_estadosmex === that.info_agencia.id_estado_agencia;
			});
			this.stateLoad = filterState[0];
        },
        findCountry: function() {
        	var that = this;
        	var filterCountry = this.array_countries.filter(function(country) {
				return country.id_pais === that.info_agencia.id_pais_agencia;
			});
			this.countryLoad = filterCountry[0];
        },
        initMap: function() {
            if(this.info_agencia.ubicacion == null || this.info_agencia.ubicacion == '') {
                this.uluru = { lat: -25.344, lng: 131.036 };

                var that = this;
                navigator.geolocation.getCurrentPosition(function(position){
                    this.uluru = { lat: position.coords.latitude, lng: position.coords.longitude };
                
                    this.map = new google.maps.Map(
                        document.getElementById('map'), {
                            zoom: 13, center: this.uluru
                        });
                    that.marker = new google.maps.Marker({position: this.uluru, map: this.map, draggable: true, animation: google.maps.Animation.DROP});
                });
            } else {
                var array_ubicacion = this.info_agencia.ubicacion.split(",");
                this.uluru = { lat: parseFloat(array_ubicacion[0]), lng: parseFloat(array_ubicacion[1]) };
                this.map = new google.maps.Map(
                    document.getElementById('map'), {
                        zoom: 13, center: this.uluru
                });
                this.marker = new google.maps.Marker({position: this.uluru, map: this.map, draggable: true, animation: google.maps.Animation.DROP});
            }
        },
        parseDate: function(date, format) {
            return moment(date).format(format);
        },
        initComponents: function() {
            $(function () {
                $('[data-toggle="tooltip"]').tooltip();
            });

            bsCustomFileInput.init();
        },
        onloadImg: function(img) {
        	switch(img) {
        		case 'logo':
        			this.file_logo = event.target.files[0];
        			this.img_logo = URL.createObjectURL(this.file_logo);
        			this.info_agencia.logotipo = event.target.files[0].name;
        		break;

        		case 'pie':
    				this.file_pie = event.target.files[0];
    				this.img_pie = URL.createObjectURL(this.file_pie);
        			this.info_agencia.pie_flyer = event.target.files[0].name;
        		break;
        	}
        },
        test_method: function() {
            console.log(event.target.value);
        },
    }
});