Vue.http.options.emulateJSON = true;
var appRates = new Vue({
    el: "#rates-section",
    data: {
        //Variables para v-for's
        rmtUrl: rmtUrl,
        parameters_url: window.location.search,
        categorias: [],
        planes: [],
        tarifas: [],
        fotos_hotel: [],
        servicios_hotel: [],
        no_result: false,
        primeraRespuesta: true,
        finRespuesta: true,
        loading_all_hotels: false,
        pathRMT: pathRMT,
        baseUrl: baseUrl,

        // ------------------------------------------------ VARIABLES PARA OUTLET ------------------------------------------------------------------------------
        check_agency: check_agency,
        /* array_outlet_hotels: array_outlet_hotels,
        array_outlet_hotels_specials: array_outlet_hotels_specials,
        only_outlet_rates: false, */
        // ------------------------------------------------ VARIABLES PARA OUTLET ------------------------------------------------------------------------------

        //variables para tarifas base
        model_id_hotel: 0,
        model_id_tipo_habitacion: 0,
        model_combinar: false,
        model_response_tarifas_base: null,

        //Variables para consultar webservice
        hotelesRQ: [],
        hotelesRQAux: [],
        habs: [],
        habsAux: [],
        frontformVue: [],
        frontformVueAux: [],

        // variables para usar en el interfaz
        resultadoBusquedaHoteles: [],
        frontForm: [],

        //variables a enviar a reservacion
        proveedor: "",
        datos_generales: "",
        datos_api: "",
        id_hotel: "",
        nombrehotel: "",
        input_front_form: [],
        input_resultado_busqueda: [],
        roomRates: "",

        //Variables para infinite scroll
        show: false, // display content after API request
        offset: 10, // items to display after scroll
        display: 10, // initial items
        trigger: 300, // how far from the bottom to trigger infinite scroll
        items: [], // server response data
        end: false, // no more resources

        //Variables para filtros
        selected_plan: "0",
        search: "",
        price_filter: "1",
        selected_estrellas: [],
        selected_proveedor: [],
        selected_outlet: "",
        filtro_disponibilidad: "0",
        selected_other_filters: [],
        selected_zonas: [],
        selected_maps: 0,
        tarifasFilter: [],
        totalFilter: 0,
        rango_precio: {
            min: 0,
            max: 0,
        },
        min_range: 0,
        max_range: 100,
        started_range: false,

        //Variables para mapa
        marker: [],
        uluru: "",
        map: "",
        map_data: {},

        //loaders
        loading: true, //tarifas
        loading_fotos: false, //Fotos de los hoteles
        loading_servicios: false, //Servicios de los hoteles
        loading_tarifas_base: false, //Tarifas base del hotel
        loading_hoteles_do: false, //Tarifas base del hotel
        loading_mismoHotel: false,
        loading_mismoDestino: false,

        //habiliar formulario
        habilitarForm: false,
        sinDisponibilidad: false,

        //habilitar tarifas de hotel do si existen
        existHotelDo: false,

        //para ejecutar una sola vez la function
        existIdHotelDo: [],

        //array para tarifas hotel do
        tarifasHDo: [],

        //habilitar tarifas sin disponibilidad en rmt
        mostrarTodasCheck: "",

        //habilitar sugerencias
        mismoHotelesSugerencias: false,
        mismoDestinoSugerencias: false,
        tarifasSamesHotels: [], // tarifas mismo hotel
        tarifasSamesDestination: [], // tarifas destino
        no_result_hotel_sugerencias: "", //mensaje si no hay tarifas
        no_result_destino_sugerencias: "", // mensaje si no hay tarifas
        exist_other_hotels: false,

        array_brokers: [1, 3, 7],
        array_propios: [0, 2, 4, 5, 6],
        array_conectividad: [2, 4, 5, 6],

        ubicacion_maps: "",
        dragMapaResult: false,
        dragMapaNotResult: false,
        mapObject: [],
        marker: [],
        markers: [],
        hotelMark: { id_hotel: 0, arrow: "greenarrow", inner: "greener" },
        contarHotel: 0,

        my_range: {},
        tipoBusqueda: tipoBusqueda,
        agregaUsuario: "",
        contador_total_hoteles: 0,
        outlet_tipo: "",
        hoteles_destacados: 0,
        contDestacados: [],

        markupAgencia: null,
        markupRmt: null,
        tipoTarifa: null,
        contadorAux: 0,
        select_hotel_destacado: "",
        banners_horizontales: [{
                imagen: "https://www.rutamayatravel.com/residencia/braulio/citytours/html/img/promos/promocion1.png",
            },
            {
                imagen: "https://www.rutamayatravel.com/residencia/braulio/citytours/html/img/promos/promocion4.png",
            },
            {
                imagen: "https://www.rutamayatravel.com/residencia/braulio/citytours/html/img/promos/promocion1.png",
            },
            {
                imagen: "https://www.rutamayatravel.com/residencia/braulio/citytours/html/img/promos/promocion4.png",
            },
            {
                imagen: "https://www.rutamayatravel.com/residencia/braulio/citytours/html/img/promos/promocion1.png",
            },
            {
                imagen: "https://www.rutamayatravel.com/residencia/braulio/citytours/html/img/promos/promocion4.png",
            },
            {
                imagen: "https://www.rutamayatravel.com/residencia/braulio/citytours/html/img/promos/promocion1.png",
            },
            {
                imagen: "https://www.rutamayatravel.com/residencia/braulio/citytours/html/img/promos/promocion4.png",
            },
            {
                imagen: "https://www.rutamayatravel.com/residencia/braulio/citytours/html/img/promos/promocion1.png",
            },
            {
                imagen: "https://www.rutamayatravel.com/residencia/braulio/citytours/html/img/promos/promocion4.png",
            },
        ],
        every: 5,
        llamadas: 0,
        hilos: [
            // {
            //     "url": this.rmtUrl,
            //     "proveedores": [0, 2, 5]
            // },
            // {
            //     "url": "https://tarifas.rutamayatravel.com/sur47",
            //     "proveedores": [1, 3]
            // },
            // {
            //     "url": "https://tarifas2.rutamayatravel.com/sur47",
            //     "proveedores": [4]
            // },

            // nuevo
            // {
            //     "url": "https://www.tarifasmx1.rutamayatravel.com",
            //     "proveedores": [0]
            // },
            // {
            //     "url": this.baseUrl,
            //     "proveedores": [1]
            // },
            // {
            //     "url": 'https://www.tarifasmx1.rutamayatravel.com',
            //     "proveedores": [2]
            // },
            // {
            //     "url": 'https://www.tarifasmx3.rutamayatravel.com',
            //     "proveedores": [3]
            // },
            // {
            //     "url": "https://www.tarifasmx3.rutamayatravel.com",
            //     "proveedores": [4]
            // },
            // {
            //     "url": 'https://www.tarifasmx3.rutamayatravel.com',
            //     "proveedores": [5]
            // },
            {
                "url": this.baseUrl,
                "proveedores": [10]
            },
            // {
            //     "url": this.rmt_url,
            //     "proveedores": [11]
            // },
            // {
            //     "url": 'https://www.tarifasmx1.rutamayatravel.com',
            //     "proveedores": [13]
            // }
        ],
        contadorAllHotels: 0,
        csslogo: "",
        datos_calendario: {},

        //variables que estaban en appCarritoHeader
        exchange_rates: {
            usd: {
                purchase: exchange_rate.compra,
                sale: exchange_rate.importe,
            },
            cop: {
                purchase: exchange_rate.cop_compra,
                sale: exchange_rate.cop_venta,
            }
        },
        agency_markup: agency_markup
    },
    created: function() {
        this.tarifasHDo = new Array();
		this.loadCategorias();
		this.agregaUsuario = "&keyU=" + id_usuario;
        var proveedores = [];
        if (this.tipoBusqueda == "hotel" || this.tipoBusqueda == "extranet") {
            sinProveedor = [];
            this.loadTarifas(sinProveedor);
        } else {
            if (this.outlet_tipo == "") {
                for (var i = 0; i < this.hilos.length; i++) {
                    if (this.hilos[i]) {
                        proveedores = this.hilos[i].proveedores;
                        this.rmtUrl = this.hilos[i].url;
                        this.loadTarifas(proveedores);
                    }
                }
            } else {
                /* this.agregaUsuario = "";
                this.rmtUrl = rmtUrl;

                switch (this.outlet_tipo) {
                    case "grupos":
                        proveedores = [0];
                        break;
                    case "bodas":
                        proveedores = [0];
                        break;
                    case "outlet":
                        proveedores = [0, 4];
                        break;
                }

                this.loadTarifas(proveedores); */
            }
        }

        this.price_filter = 2;
        this.selected_estrellas = [1, 2, 3, 4, 5];
        this.getBannersAds();

        this.formatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        });
    },
    methods: {
        loadCategorias: function() {
            this.$http.get(this.rmtUrl + "/categorias/filtros").then(
                function(response) {
                    this.categorias = response.body.categories;
                },
                function() {
                    console.log("Error");
                }
            );
        },
        selectedDestacado(tarifa) {
            this.select_hotel_destacado = tarifa.id_hotel;
            $("html, body").animate({ scrollTop: 0 }, "slow");
        },
        getBannersAds: function() {
            this.$http
                .get(
                    "https://www.rutamayatravel.com/sur4/tarifasFlyers/getBannerListaApi?filtro=vertical"
                )
                .then(
                    (response) => {
                        this.banners_horizontales = response.data;
                    },
                    (response) => console.log(response)
                );
        },
        imprimirBanner: function(contador) {
            var imagen = "";
            var residuo = (contador + 1) / this.every;
            if (this.banners_horizontales[residuo - 1]) {
                var redirect = "";
                if (this.banners_horizontales[residuo - 1].url == null) {
                    redirect = "javascript:void(0)";
                } else {
                    redirect = this.banners_horizontales[residuo - 1].url;
                }
                imagen =
                    '<a href="' +
                    redirect +
                    '"> <img src="https://www.rutamayatravel.com/sur4/admin/images/banners/' +
                    this.banners_horizontales[residuo - 1].imagen +
                    '" class="w-100" alt=""></a>';
            }
            return imagen;
        },
        convertLowerCase: function(parrafo) {
            var texto = parrafo.toLowerCase();
            return texto;
        },
        imprimirPrincipalHotel(imagen, proveedor) {
            var imagen_url = "";
            if (
                proveedor == 1 ||
                proveedor == 3 ||
                proveedor == 2 ||
                proveedor == 5
            ) {
                if (proveedor == 1 && imagen.indexOf("imagenes") != "-1") {
                    imagen_url = imagen.split("imagenes");
                    imagen_url = imagen_url[1];
                    return "/imagenes" + imagen_url;
                }else if (imagen.includes("http") || imagen.includes("//")){
                    imagen_url = imagen;
                } else {
                    imagen_url = appRates.pathRMT + imagen;    
                }
            }else if(proveedor == 10){
                imagen_url = imagen;
            }else {
                imagen_url = appRates.pathRMT + imagen;
            }
            return imagen_url;
        },
        loadListadoTarifas: function() {
            element = event.currentTarget;
            this.model_id_hotel = element.getAttribute("data-id_hotel");
            var id_hotel = this.model_id_hotel;
            $("#tarifas_base_" + this.model_id_hotel).html(
                "<div align='center' style='margin-top:20px'><img src='" +
                baseUrl +
                "/images/loader.gif'></div>"
            );
            $.ajax({
                    url: "https://www.tarifasmx1.rutamayatravel.com/tarifa/listadoTarifas",
                    type: "POST",
                    data: { resultadoBusqueda: this.habs, hotel: this.model_id_hotel },
                })
                .done(function(html) {
                    $("#tarifas_base_" + id_hotel).empty();
                    $("#tarifas_base_" + id_hotel).html(html);
                })
                .fail(function(error) {
                    console.log(error);
                });
        },
        urlEspecial(idhotel) {
            var url = window.location.href;
            idhotel = parseInt(idhotel);
            var id_hd = "d_PCM";
            url = url.split("?");
            urlGet = url[1].split("&");
            var index = urlGet.findIndex((u) => {
                return u.toLowerCase().includes("destino");
            });
            switch (idhotel) {
                case 177889:
                    id_hd = "h_53";
                    break;
                case 177912:
                    id_hd = "h_394";
                    break;
                case 177911:
                    id_hd = "h_395";
                    break;
            }

            urlGet[index] = "destino=" + id_hd;
            urlGet.push("tarifa=especial");
            urlGet = urlGet.join("&");
            url[1] = urlGet;
            url = url.join("?");
            return url;
        },
        loadTarifas: function(proveedores) {
            var filtro_disponibilidad = 1;
            if (this.filtro_disponibilidad == false) {
                filtro_disponibilidad = 0;
            }
            var outlet_tipo = this.parameters_url.split("?");

            outlet_tipo = outlet_tipo[1];
            outlet_tipo = outlet_tipo.split("&");
            outlet_tipo = outlet_tipo[0];
            outlet_tipo = outlet_tipo.split("=");

            if (
                outlet_tipo[0] == "outlet" &&
                outlet_tipo[1] != "" &&
                proveedores.length > 0
            ) {
                this.outlet_tipo = outlet_tipo[1];
            } else {
                var outlet_tipo = this.parameters_url.split("&");
                var ultimo = outlet_tipo.length - 1;
                outlet_tipo = outlet_tipo[ultimo];
                outlet_tipo = outlet_tipo.split("=");
                if (
                    outlet_tipo[0] == "outlet" &&
                    outlet_tipo[1] != "" &&
                    proveedores.length > 0
                ) {
                    this.outlet_tipo = outlet_tipo[1];
                }
            }
            if (this.outlet_tipo == "grupos") {
                proveedores = [0, 2];
            }
            var params = {
                hotelesRQ: this.hotelesRQ,
                habitacionesRQ: this.habs,
                front_form: this.frontformVue,
                disponibilidad: filtro_disponibilidad,
            };
            this.$http
                .get(
                    // "https://www.tarifasmx1.rutamayatravel.com/site/getTarifas/" +
                    this.baseUrl + "/site/getTarifas/" +
                    this.parameters_url +
                    "&proveedores=" +
                    proveedores +
                    this.agregaUsuario
                )
                .then(function(response) {
                    this.display = 10;
                    this.llamadas = this.llamadas + 1;

                    this.contador_total_hoteles = response.body.count;
                    this.contadorAllHotels = parseInt(this.contadorAllHotels) + parseInt(response.body.count);

                    if (this.llamadas == 1) {
                        this.habs = JSON.stringify(response.body.habitacionesRQ);
                        this.frontformVue = JSON.stringify(response.body.front_form);
                    }

                    if (this.contadorAllHotels > 1) {
                        this.loading_all_hotels = true;
                    }

                    if (this.llamadas == this.hilos.length || this.outlet_tipo != "" || this.tipoBusqueda == "extranet") {
                        this.loading_all_hotels = false;
                        if (this.contadorAllHotels == 0) {
                            this.loading = false;
                            this.show = true;
                            this.no_result = true;
                        }
                    }
                    if (response.body.count > 0) {
                        var that = this;
                        var responseTarifas = Object.values(response.body.row);
                        this.tarifas = that.tarifas.concat(responseTarifas);

                        var indexes = [];
                        var that = this;
                        this.tarifas.forEach(function(el, i) {
                            if (typeof el.Error != "undefined") {
                                indexes.push(i);
                            }
                        });
                        indexes.forEach(function(el) {
                            delete that.tarifas[el];
                        });

                        this.show = true;
                        this.loading = false;

                        // $(".diasValidos").iCheck("check");
                        this.selected_proveedor = ["rmt", "broker"];
                        // $(".selectedZonas").iCheck("check");
                        this.resultadoBusquedaHoteles = JSON.parse(this.habs);
                        this.frontForm = JSON.parse(this.frontformVue);

                        if (this.resultadoBusquedaHoteles.totalHoteles == 1) {
                            this.loading_all_hotels = false;
                            var destiny = this.frontForm.destino.split("_");
                            this.loadSamesHotels();
                            this.exist_other_hotels = true;
                            var hotel = [];
                            tarifas = this.tarifas;
                            if (destiny[0] == "h") {
                                this.hotelMark.id_hotel = tarifas[0].id_hotel;
                            }

                            disponibilidadPropio = true;
                            disponibilidadApis = false;
                            disponibilidadOB = false;
                            if (tarifas[0].proveedor == 0) {
                                disponibilidadPropio =
                                    tarifas[0].Desglose == null ?
                                    false :
                                    tarifas[0].Desglose.disponibilidad_hotel;
                            }
                            if (tarifas[0].proveedor != 0 || tarifas[0].proveedor == 2) {
                                if (typeof tarifas[0].Warning !== "undefined") {
                                    disponibilidadApis = tarifas[0].Warning.warning;
                                }
                            }
                            if (tarifas[0].proveedor == 2) {
                                disponibilidadOB = tarifas[0].Desglose.NoDisponible;
                            }

                            if (
                                disponibilidadPropio == false ||
                                disponibilidadApis == true ||
                                disponibilidadOB == true
                            ) {
                                if (outlet_tipo[1] !== "grupos") {
                                    this.loadSamesDestination();
                                }

                            }
                            // }
                        }
                    } else {
                        if (this.tipoBusqueda == 'hotel') {
                            this.frontForm = JSON.parse(this.frontformVue);
                            this.outlet_tipo = outlet_tipo[1];
                            this.loadSamesHotels();
                            this.loading = false;
                            this.show = true;
                            this.no_result = true;
                        }
                        if (this.tipoBusqueda == 'destino' && this.tarifas.length == 0 && this.llamadas == this.hilos.length) {
                            this.loading = false;
                            this.show = true;
                            this.no_result = true;
                        }
                        $(".range_price").toggle();
                    }
                });
        },
        loadSamesHotels: function() {
            var that = this;
            var filtro_disponibilidad = 1;
            if (this.filtro_disponibilidad == false) {
                filtro_disponibilidad = 0;
            }
            this.loading_mismoHotel = true;
            var params = {
                destinoRQ: this.frontForm.destino,
                habitacionesRQ: this.habs,
                front_form: this.frontformVue,
                disponibilidad: filtro_disponibilidad,
            };
            this.$http
                .post("https://www.tarifasmx1.rutamayatravel.com/site/getSamesHotels", params)
                .then(function(response) {
                    if (response.body != null) {
                        this.tarifasSamesHotels = Object.values(response.body);
                        console.log(that.outlet_tipo)
                        if (that.outlet_tipo == "grupos") {
                            that.no_result = false;
                        }
                    } else {
                        this.no_result_hotel_sugerencias =
                            "<div style='margin-top: 30px;font-size:14px;' class='alert alert-danger '><p><b>No se encontraron hoteles disponibles con las mismas similitudes</b></p></div>";
                    }
                    this.mismoHotelesSugerencias = true;
                    this.loading_mismoHotel = false;
                });
        },
        loadSamesDestination: function() {
            this.loading_mismoDestino = true;
            var params = {
                destinoRQ: this.frontForm.destino,
                habitacionesRQ: this.habs,
                front_form: this.frontformVue,
            };
            this.$http
                .post("https://www.tarifasmx1.rutamayatravel.com/site/getSamesDestinations", params)
                .then(function(response) {
                    if (response.body != null) {
                        this.tarifasSamesDestination = Object.values(response.body);
                    } else {
                        this.no_result_destino_sugerencias =
                            "<div style='margin-top: 30px;font-size:14px;' class='alert alert-danger '><p><b>No se encontraron otros hoteles disponibles con el mismo destino solicitado.</b></p></div>";
                    }
                    this.mismoDestinoSugerencias = true;
                    this.loading_mismoDestino = false;
                });
        },
        recuperarBusqueda() {
            this.hotelesRQ = this.hotelesRQAux;
            this.loadTarifas();
        },
        loadTooltip() {
            var titles = "";
            var tooltipvip = $("body .tooltipvip").tooltip();

            tooltipvip.tooltip({
                html: true,
                //title:titles
            });
            return true;
        },
        diferenciaDescuento(precio, descuento) {
            var precioC = precio.replace(/,/g, "");
            var descuentoC = descuento.replace(/,/g, "");
            var total = parseFloat(precioC) - parseFloat(descuentoC);
            var numberFormat2 = new Intl.NumberFormat("en-US", {
                style: "currency",
                currency: "USD",
            });
            return numberFormat2.format(total);
        },
        cargarMapa: function(tarifas, searchforzona) {
            var that = this;
            if (searchforzona == true) {
                that.map_data = {};
            }
            tarifas.forEach(function(element, index) {
                if (element.ubicacion !== "") {
                    var proveedor = "";
                    var nombre_proveedor = "";
                    var array_ubicacion = element.ubicacion.split("/");
                    var menorPrecio = "";
                    var mejorHabitacion = "";
                    var mejorPlan = "";
                    var proveedor = "";
                    if (element.Desglose) {
                        menorPrecio =
                            "$ " +
                            element.Desglose.menorPrecio +
                            " " +
                            element.Desglose.moneda;
                        mejorHabitacion = element.Desglose.mejorHabitacion;
                        mejorPlan = element.Desglose.mejorPlan;
                    }

                    proveedor = element.proveedor;
                    nombre_proveedor = element.foto.prov;
                    if (typeof that.map_data["hotel"] == "undefined") {
                        that.map_data["hotel"] = [];
                        that.map_data["hotel"].push({
                            id_hotel: element.id_hotel,
                            name: element.nombre_hotel,
                            location_latitude: array_ubicacion[1],
                            location_longitude: array_ubicacion[0],
                            map_image_url: element.foto.rutaImage,
                            name_point: element.nombre_hotel,
                            best_room: mejorHabitacion,
                            lower_price: menorPrecio,
                            best_plan: mejorPlan,
                            get_directions_start_address: "",
                            url_point: "single_hotel.html",
                            proveedor: proveedor,
                            nombre_proveedor: nombre_proveedor,
                        });
                    } else {
                        that.map_data["hotel"].push({
                            id_hotel: element.id_hotel,
                            name: element.nombre_hotel,
                            location_latitude: array_ubicacion[1],
                            location_longitude: array_ubicacion[0],
                            map_image_url: element.foto.rutaImage,
                            name_point: element.nombre_hotel,
                            best_room: mejorHabitacion,
                            lower_price: menorPrecio,
                            best_plan: mejorPlan,
                            get_directions_start_address: "",
                            url_point: "single_hotel.html",
                            proveedor: proveedor,
                            nombre_proveedor: nombre_proveedor,
                        });
                    }
                }
            });
            $.getScript(
                rmtUrl + "/vue/mapas_cotizador_hoteles.js",
                function(data, textStatus, jqxhr) {
                    // console.log(JSON.stringify(that.map_data));
                    // console.log( textStatus ); // Success
                    // console.log( jqxhr.status ); // 200
                    if ($("#chk_maps").is(":checked")) {
                        $("#dv_desplazar").removeClass("d-none");
                        $("#load_desplazar").addClass("d-none");
                    }
                }
            );
        },
        getRatesHD: function(event) {
            var btn_send = event.currentTarget;
            var proveedor = btn_send.getAttribute("data-proveedor");
            var codigo_hotel = btn_send.getAttribute("data-codigoHotel");
            var id_hotel = btn_send.getAttribute("data-idHotel");
            var interfaceInfo = btn_send.getAttribute("data-interfaceInfo");
            var dataHDo = {
                codigoHotel: codigo_hotel,
                idHotel: id_hotel,
                front_form: this.frontformVue,
                fecha_inicial: this.resultadoBusquedaHoteles.fecha_inicial,
                interfaceInfo: interfaceInfo,
                currency: appHeader.currency,
            };

            var tarifasHDo_aux = new Array();

            var idDiv = proveedor == 3 ? "hotelDo_" : "restelTarifa_";
            var urlProv = proveedor == 3 ? "/travelSolution/getRatesHDV2" : "/restel/getRatesRs";
            $("#" + idDiv + id_hotel).html(
                "<div align='center'><i class='fa fa-spinner fa-pulse fa-3x fa-fw'></i> Cargando...</div>"
            );

            $.ajax({
                url: "https://rutamayatravel.com/sur4agencias" + urlProv,
                type: "POST",
                data: dataHDo,
                async: true,
            }).done(function(html) {
                $("#" + idDiv + id_hotel).html("");
                $("#" + idDiv + id_hotel).append(html); //imprimo el html
            });

            if (proveedor == 3) {
                if (this.existIdHotelDo.includes(id_hotel) === false) {} else {
                    var html = this.tarifasHDo[id_hotel].html;
                }
            }
        },
        loadFotosHotel: function() {
            element = event.currentTarget;
            var that = this;
            var id_hotel = element.getAttribute("data-id_hotel");
            var proveedor = element.getAttribute("data-nuevo");
            $("#tab_hotel_" + id_hotel).html(
                "<div align='center' style='margin-top:10px'><img src='/reservaciones/sur3/images/loader.gif'></div>"
            );
            var url_hotel_fotos = "https://www.tarifasmx1.rutamayatravel.com/hotelesFotos/hotelesFotos";
            var that = this;

            this.$http
                .post(url_hotel_fotos, { id_hotel: id_hotel, proveedor: proveedor })
                .then(
                    function(response) {
                        if (response.body !== "undefined" || response.body !== null) {
                            var html = "";
                            this.fotos_hotel = response.body.data.hotelesFotos;
                            this.loading_fotos = false;
                            var valueFoto = "";
                            if (proveedor == 1) {
                                var urlfoto = "https://photos.hotelbeds.com/giata/";
                                var medium = "medium/";
                                var bigger = "bigger/";
                            } else if (proveedor == 3 || proveedor == 5 || proveedor == 2) {
                                var urlfoto = "";
                                var medium = "";
                                var bigger = "";
                            } else {
                                var urlfoto = "https://rutamayatravel.com/imagenes/";
                                var medium = "";
                                var bigger = "";
                            }
                            $.each(this.fotos_hotel, function(index, value) {
                                valueFoto = value.foto;
                                if (proveedor == 3 || proveedor == 5 || proveedor == 2) {
                                    valueFoto = value.foto.replace("http:", "");
                                }
                                var col = "";
                                var principal = "";
                                var center = " fotohotelInfo ";
                                if (index == 0) {
                                    center += " text-center ";
                                    col = " col-12 ";
                                    principal = " principal ";
                                }
                                html +=
                                    "<div class=' " +
                                    col +
                                    center +
                                    "' ><a href=\"" +
                                    urlfoto +
                                    bigger +
                                    valueFoto +
                                    "\" data-fancybox='gallery' data-type='image' data-caption='caption#" +
                                    index +
                                    "' data-height='600' ><img src=\"" +
                                    urlfoto +
                                    medium +
                                    valueFoto +
                                    "\" class='" +
                                    principal +
                                    "' /> </a> </div>";
                            });
                            $("#tab_hotel_" + id_hotel).html(html);
                        } else {
                            $("#tab_hotel_" + id_hotel).html("");
                        }

                        Vue.nextTick(function() {
                            that.fancybox(id_hotel);
                        });
                    },
                    function() {
                        $("#tab_hotel_" + id_hotel).html("");
                    }
                );
        },
        fancybox(id_hotel) {
            var userAgent = navigator.userAgent || navigator.vendor || window.opera;

            var autoStart = true;
            if (/android/i.test(userAgent)) {
                // console.log(userAgent);
                autoStart = false;
            }
            if (/iPad|iPhone|iPod/.test(userAgent) && !window.MSStream) {
                autoStart = false;
            }
            $('body #tab_hotel_' + id_hotel + ' [data-fancybox="gallery"]').fancybox({
                // Options will go here
                toolbar: true,
                thumbs: {
                    autoStart: autoStart, // Display thumbnails on opening
                    hideOnClose: false, // Hide thumbnail grid when closing animation starts
                },
            });
        },
        urlFrameMap: function(nombre_hotel, coordenadas) {
            var q = "";
            var coordenada = [];
            var nombre_hotel = encodeURIComponent(nombre_hotel);
            var lat = "";
            var lon = "";
            if (coordenadas) {
                coordenada = coordenadas.split("/");
                lat = coordenada[1];
                lon = coordenada[0];
                q = lat + "," + lon + "+";
            }

            q += "(" + nombre_hotel + ")";

            return q;
        },
        abrirModal: function(id_modal) {
            $("#" + id_modal).modal("toggle");
        },
        loadServiciosHotel: function() {
            element = event.currentTarget;
            var id_hotel = element.getAttribute("data-id_hotel");
            var proveedor = element.getAttribute("data-nuevo");
            $("#tab_servicio_" + id_hotel).html(
                "<div align='center' style='margin-top:10px'><img src='/reservaciones/sur3/images/loader.gif'></div>"
            );
            var url_hotel_servicio =  "https://www.tarifasmx1.rutamayatravel.com/site/hotelServDef";
            this.$http
                .post(url_hotel_servicio, { id_hotel: id_hotel, proveedor: proveedor })
                .then(
                    function(response) {
                        $("#tab_servicio_" + id_hotel).html(response.body);
                    },
                    function() {
                        console.log("Error");
                    }
                );
        },
        loadMapaHotel: function() {
            element = event.currentTarget;
            var id_hotel = element.getAttribute("data-id_hotel");
            var info_ubicacion = [];
            info_ubicacion = this.tarifas.filter(function(i) {
                return i.id_hotel === id_hotel;
            });

            if (info_ubicacion[0].ubicacion !== "") {
                var array_ubicacion = info_ubicacion[0].ubicacion.split("/");
                this.uluru = {
                    lat: parseFloat(array_ubicacion[1]),
                    lng: parseFloat(array_ubicacion[0]),
                };
                this.map = new google.maps.Map(
                    document.getElementById("map_" + id_hotel), {
                        zoom: 10,
                        center: this.uluru,
                    }
                );
                this.marker = new google.maps.Marker({
                    position: this.uluru,
                    map: this.map,
                    draggable: false,
                    animation: google.maps.Animation.DROP,
                });
            }
        },
        setIdHotel: function() {
            element = event.currentTarget;
            this.model_id_hotel = element.getAttribute("data-id_hotel");
        },
        setIdTipoHabitacion: function(event) {
            element = event.currentTarget;
            this.model_id_tipo_habitacion = element.getAttribute(
                "data-id_tipo_habitacion"
            );
            this.model_response_tarifas_base = null;

            var id_hotel = element.getAttribute("data-hotel");
            var tarifa = element.getAttribute("data-tarifa");
            var plan = element.getAttribute("data-plan");
            var ORDER_PRECIO = JSON.parse(this.habs).ORDER_PRECIO;
            $("#v-pills-tabContent_" + id_hotel).html(
                "<div align='center' style='margin-top:20px'><img src='" +
                baseUrl +
                "/images/loader.gif'></div>"
            );
            $.ajax({
                    url: "https://www.tarifasmx1.rutamayatravel.com/tarifa/cargarHabitaciones",
                    type: "POST",
                    data: {
                        id_hotel: id_hotel,
                        id_tarifa: tarifa,
                        id_plan: plan,
                        ORDER_PRECIO: ORDER_PRECIO,
                    },
                })
                .done(function(html) {
                    $("#v-pills-tabContent_" + id_hotel).empty();
                    $("#v-pills-tabContent_" + id_hotel).html(html);
                })
                .fail(function(error) {
                    console.log(error);
                });
        },
        loadTarifasBaseHotel(event) {
            element = event.currentTarget;
            var hotel = element.getAttribute("data-id");
            var tarifa = element.getAttribute("data-tarifa");
            var hab = element.getAttribute("data-hab");
            var fecha_inicio = JSON.parse(this.habs).fecha_inicial;
            var noches = JSON.parse(this.habs).noches;

            var ORDER_PRECIO = JSON.parse(this.habs).ORDER_PRECIO;
            var combinar = true;
            $("#cotizacionRapida" + hotel).html(
                "<div align='center' style='margin-top:20px'><img src='" +
                baseUrl +
                "/images/loader.gif'></div>"
            );
            $.ajax({
                    url: "https://www.tarifasmx1.rutamayatravel.com/tarifa/Tarifasbase",
                    type: "POST",
                    data: {
                        id_hotel: hotel,
                        id_tarifa: tarifa,
                        id_hab: hab,
                        fecha_inicio: fecha_inicio,
                        noches: noches,
                        ORDER_PRECIO: ORDER_PRECIO,
                        combinar: combinar,
                    },
                })
                .done(function(html) {
                    $("#cotizacionRapida" + hotel).empty();
                    $("#cotizacionRapida" + hotel).html(html);
                })
                .fail(function(error) {
                    console.log(error);
                });
        },
        ocultarBoton(id_hotel) {
            $("#click_" + id_hotel).toggleClass("d-none");
        },
        activandoTarifas: function(id_hotel) {
            $("#click_" + id_hotel).toggleClass("d-none");
            $("#collapseMostrarTarifas_" + id_hotel).trigger("click");
        },
        convertToBase64Decode: function(data) {
            var result = atob(data);
            return result;
        },
        convertToBase64Encode: function(data) {
            var result = Base64.encode(data);
            return result;
        },
        convertToNumber: function(numero) {
            if (typeof numero.replace(/,/g, "") == undefined) {
                var number = numero;
            } else {
                var number = numero.replace(/,/g, "");
            }
            return parseFloat(number);
        },
        buildJson: function(
            id_hotel,
            nombre_hotel,
            id_plan,
            tipo_plan,
            code_hotel,
            id_habitacion,
            precio,
            moneda,
            tarifa,
            markup
        ) {
            var data_general = new Array();

            data_general = {
                id_hotel: id_hotel,
                nombre_hotel: nombre_hotel,
                id_plan: id_plan,
                tipo_plan: tipo_plan,
                code_hotel: code_hotel,
                id_habitacion: id_habitacion,
                precio: this.convertToNumber(precio),
                moneda: moneda,
                id_tarifa: tarifa,
                markup: markup,
            };

            return Base64.encode(JSON.stringify(data_general));
        },
        convertToJsonApi: function(api) {
            return Base64.encode(JSON.stringify(api));
        },
        sendReservacion: function(event) {
            var btn = event.currentTarget;
            var id_hotel = btn.getAttribute("data-id_hotel");

            this.proveedor = btn.getAttribute("data-proveedor");

            if (this.proveedor == 2 || this.proveedor == 3) {
                this.roomRates = $("#roomRates_" + id_hotel).val();
            }
            var calendario = [];
            var datos_calendario = btn.getAttribute("data-calendario");
            if (btn.getAttribute("data-calendario")) {
                datos_calendario = this.convertToBase64Decode(datos_calendario);
                datos_calendario = JSON.parse(datos_calendario);
                for (var i = 0; i < datos_calendario.length; i++) {
                    calendario.push(datos_calendario[i].calendario["habitacion"]);
                }
            }
            this.datos_generales = btn.getAttribute("data-general");
            this.datos_api = btn.getAttribute("data-api");
            this.datos_calendario = this.convertToJsonApi(calendario);
            this.input_front_form = this.convertToBase64Encode(this.frontformVue);
            this.input_resultado_busqueda = this.convertToBase64Encode(this.habs);

            var markup = this.agency_markup.markupAgencia;
            var markupRmt = this.agency_markup.markupRmt;
            var tarifa = this.agency_markup.tipoTarifa;

            if (markup != 0 && markup != null) {
                this.markupAgencia = markup;
            }

            if (markupRmt != 0 && markupRmt != null) {
                this.markupRmt = markupRmt;
                this.tipoTarifa = tarifa;
            }

            this.sendForm();
        },
        sendForm: function() {
            setTimeout(function() {
                if (this.input_resultado_busqueda != "") {
                    $("#formReservacion").submit();
                }
            }, 2100);
        },
        convertToJsonDecode: function(texto) {
            return JSON.parse(texto);
        },
        convertToJsonEncode: function(texto) {
            return JSON.stringify(texto);
        },
        mostrarTodas: function(id_hotel) {
            $(".ocultarTarifa_" + id_hotel).toggleClass("d-none");
        },
        filterMapaGoogle: function(nombre_hotel) {
            this.search = nombre_hotel;
        },
        restricted: function(id_hotel, key, tipo_boton, nota) {
            $(".planesTarifa_" + id_hotel + key + "_" + tipo_boton).addClass(
                "d-none"
            );
            return nota;
        },
        initRangePrice: function(tarifas) {
            if (this.started_range == false) {
                if (this.loading_all_hotels == false) {
                    this.started_range = true;
                }
                var last = tarifas.length;
                var min_range = 0;
                var max_range = 0;

                if (tarifas[0].Desglose.moneda == "USD") {
                    min_range = parseFloat(
                        tarifas[0].Desglose.menorPrecio_mxn.replace(/,/g, "")
                    );
                } else {
                    min_range = parseFloat(
                        tarifas[0].Desglose.menorPrecio.replace(/,/g, "")
                    );
                }

                if (
                    tarifas[Object.keys(tarifas)[Object.keys(tarifas).length - 1]]
                    .Desglose.moneda == "USD"
                ) {
                    max_range = parseFloat(
                        tarifas[
                            Object.keys(tarifas)[Object.keys(tarifas).length - 1]
                        ].Desglose.menorPrecio_mxn.replace(/,/g, "")
                    );
                } else {
                    max_range = parseFloat(
                        tarifas[
                            Object.keys(tarifas)[Object.keys(tarifas).length - 1]
                        ].Desglose.menorPrecio.replace(/,/g, "")
                    );
                }

                min_range = Math.floor(min_range);
                max_range = Math.ceil(max_range);
                var that = this;
                this.rango_precio = {};
                this.rango_precio = {
                    min: min_range,
                    max: max_range,
                };

                this.min_range = this.rango_precio.min;
                this.max_range = this.rango_precio.max;

                that.my_range.update({
                    min: min_range,
                    max: max_range,
                    from: min_range,
                    to: max_range,
                });
            }
        },
        filtros: function(tarifas, rowscount, searchforzona) {
            var vm = this;
            var tarifasFilter = [];

            if (rowscount == 1) {
                return tarifas.slice(0, this.display);
            } else {
                // FILTRO PRECIO
                if (vm.price_filter == 2 || vm.price_filter == 1) {
                    var orderPrecio_a = 0;
                    var orderPrecio_b = 0;
                    tarifas.sort(function(a, b) {
                        if (
                            typeof a.Desglose !== "undefined" ||
                            typeof b.Desglose !== "undefined"
                        ) {
                            if (a.Desglose.moneda == "USD") {
                                orderPrecio_a = a.Desglose.menorPrecio_mxn;
                            } else {
                                orderPrecio_a = a.Desglose.menorPrecio;
                            }

                            if (b.Desglose.moneda == "USD") {
                                orderPrecio_b = b.Desglose.menorPrecio_mxn;
                            } else {
                                orderPrecio_b = b.Desglose.menorPrecio;
                            }

                            return (
                                vm.convertToNumber(orderPrecio_a) -
                                vm.convertToNumber(orderPrecio_b)
                            );
                        }
                    });
                    if (vm.loading == false) {
                        vm.initRangePrice(tarifas);
                    }
                } else if (vm.price_filter == 3) {
                    tarifas.sort(function(a, b) {
                        if (
                            typeof a.Desglose !== "undefined" ||
                            typeof b.Desglose !== "undefined"
                        ) {
                            if (a.Desglose.moneda == "USD") {
                                orderPrecio_a = a.Desglose.menorPrecio_mxn;
                            } else {
                                orderPrecio_a = a.Desglose.menorPrecio;
                            }

                            if (b.Desglose.moneda == "USD") {
                                orderPrecio_b = b.Desglose.menorPrecio_mxn;
                            } else {
                                orderPrecio_b = b.Desglose.menorPrecio;
                            }
                            return (
                                vm.convertToNumber(orderPrecio_b) -
                                vm.convertToNumber(orderPrecio_a)
                            );
                        }
                    });
                }

                tarifasFilter = tarifas
                    .filter((tarifa) => {
                        if (tarifa.proveedor == 3) {
                            $("#hotelDo_" + tarifa.id_hotel).html("");
                        }

                        if (tarifa.proveedor == 0) {}
                        //FILTRO BUSQUEDA
                        return tarifa.nombre_hotel
                            .toLowerCase()
                            .includes(vm.search.toLowerCase());
                    })
                    .filter((stars) => {
                        // FILTRO ESTRELLAS
                        if (vm.selected_estrellas.length > 0) {
                            return vm.selected_estrellas.includes(parseInt(stars.estrellas));
                        } else {
                            return stars;
                        }
                    })
                    .filter((zonas) => {
                        // FILTRO Zonas
                        if (vm.selected_zonas.length > 0) {
                            if (
                                zonas.destino.zonasCode == "3640" &&
                                this.frontForm.destino == "d_PCM"
                            ) {
                                return zonas;
                            } else {
                                return vm.selected_zonas.includes(zonas.destino.zonasCode);
                            }
                        } else {
                            return zonas;
                        }
                    })
                    .filter((proveedor) => {
                        var rmt = [0, 2, 4, 5, 6];
                        var broker = [1, 3, 7, 10];
                        // FILTRO PROVEEDOR
                        if (vm.selected_proveedor.length == 1) {
                            if (vm.selected_proveedor[0] == "rmt") {
                                return rmt.includes(parseInt(proveedor.proveedor));
                            }
                            return broker.includes(parseInt(proveedor.proveedor));
                        }
                        else {
                            return proveedor;
                        }
                    })
                    .filter((other) => {
                        if (vm.selected_other_filters.length > 0) {
                            var temas = Object.values(other.Filtro.temas);
                            var filterTema = false;
                            end_loop: for (i = 0; i < vm.selected_other_filters.length; i++) {
                                filterTema = temas.includes(vm.selected_other_filters[i]);
                                if (filterTema === true) {
                                    break end_loop;
                                }
                            }
                            if (filterTema === true) {
                                return other;
                            }
                        } else {
                            return other;
                        }
                    })
                    .filter((plan) => {
                        // FILTRO PLANES
                        if (vm.selected_plan != 0) {
                            if (typeof plan.Filtro.planes.codigos != "undefined") {
                                planes = Object.values(plan.Filtro.planes.codigos);
                                return planes.includes(parseInt(vm.selected_plan));
                            }
                        } else {
                            return plan;
                        }
                    })
                    .filter((precio) => {
                        if (precio.Desglose.moneda == "USD") {
                            if (
                                vm.convertToNumber(precio.Desglose.menorPrecio_mxn) >=
                                vm.rango_precio.min &&
                                vm.convertToNumber(precio.Desglose.menorPrecio_mxn) <=
                                vm.rango_precio.max
                            ) {
                                return precio;
                            }
                        } else {
                            if (
                                vm.convertToNumber(precio.Desglose.menorPrecio) >=
                                vm.rango_precio.min &&
                                vm.convertToNumber(precio.Desglose.menorPrecio) <=
                                vm.rango_precio.max
                            ) {
                                return precio;
                            }
                        }
                    })
                    .filter((id_hotel) => {
                        if (vm.select_hotel_destacado != "") {
                            return id_hotel.id_hotel
                                .toLowerCase()
                                .includes(vm.select_hotel_destacado.toLowerCase());
                        } else {
                            return id_hotel;
                        }
                    }).filter((outlet) => {
                        if (vm.only_outlet_rates) {
                            return vm.array_outlet_hotels.includes(outlet.id_hotel);
                        }
                        return outlet;
                    });

                this.contDestacados = tarifasFilter.filter((item) => {
                    return item.destacado === 1;
                });

                this.totalFilter = tarifasFilter.length;

                tarifasFilter = tarifasFilter.slice(0, this.display);

                if (this.loading_all_hotels == false) {
                }
                return tarifasFilter;
            }
        },
        validaBuenFin(proveedor, desglose) {
            if ((proveedor == 0 || proveedor == 2 || proveedor == 4 || proveedor == 5) &&
                (desglose.mejorPlan.toLocaleLowerCase().match(/.*todo incluido.*/) || desglose.mejorPlan.toLocaleLowerCase().match(/.*all inclusive.*/))) {
                return "text-align: left !important;";
            }
        },
        // check to see if we're at the bottom of the page
        scroll() {
            document.addEventListener("scroll", (evt) => {
                if (($(window).scrollTop() + $(window).innerHeight()) >= $(document).height() - 100) {
                    if (this.display < this.tarifas.length) {
                        this.display = this.display + this.offset;
                    } else {
                        this.end = true;
                    }
                }
            });
        },
        onHtmlClick: function(location_type, key) {
            var searchforzona,
                rowscount = this.tarifas.length;
            if (rowscount == 1) {
                searchforzona = false;
            } else {
                searchforzona = true;
            }

            this.hotelMark.id_hotel = key;
            var i_ubicacion = this.countHotels(key);
            if (i_ubicacion !== "") {
                onHtmlClick(location_type, i_ubicacion);
            }
        },
        crearPromocion: function(tarifa, hab, proveedor, plan) {
            var nombrePlan;
            nombrePlan = plan.nombrePlan;
            if (proveedor == "2") {
                nombrePlan = plan.tipo_plan;
            }

            var precio_normal = 0;
            if (plan.calendario.habitacion[1].Fechas[1]) {
                precio_normal = plan.calendario.habitacion[1].Fechas[1].Adultos;
            } else {
                precio_normal = plan.calendario.habitacion[1].Fechas[0].Adultos;
            }
            var promocion = {
                conectividad: 1,
                num_menores_gratis: 0,
                fecha_limite_h: plan.fecha_limiteH,
                fecha_limite: plan.fecha_limite,
                id_promocion_conectividad: 0,
                id_base_habitacion: plan.calendario.habitacion[1].resumen.adultos,
                precio_normal: precio_normal,
                nombre_hotel: tarifa.nombre_hotel,
                id_hotel: tarifa.id_hotel,
                code_hotel: tarifa.code_hotel,
                foto_principal_hotel: tarifa.foto.rutaImage,
                tipo_habitacion: tarifa.Habitaciones[hab].nombre_hab,
                tipo_plan: nombrePlan,
                url: window.location.href,
                estatus_tarifa: "1",
                tipo_precio: "PROMO",
                tipo_moneda: plan.moneda,
                proveedor: proveedor,
            };

            appPromocion.array_promocion = promocion;

            $("#fechas_promocion").modal("show");
        },
        verificaMarkup() {
            this.$http.get(this.rmtUrl + "/agenciasMarkup/markup").then(
                function(response) {
                    var response = response.body;
                    localStorage.setItem("markup", JSON.stringify(response));
                    if (response.markup != 0 && response.markup != null) {
                        this.markupAgencia = response.markup;
                    }

                    if (response.markupRmt != 0 && response.markupRmt != null) {
                        this.markupRmt = response.markupRmt;
                        this.tipoTarifa = response.tarifa;
                    }
                },
                function() {
                    console.log("Error");
                }
            );
            // }
        },
        aplicarMarkup(precio, id_hotel, operacion = 0) {
            var new_price = this.convertToNumber(precio);
            if (typeof localStorage.markup != "undefined") {
                var markup = this.agency_markup.markupAgencia;
                var markupRmt = this.agency_markup.markupRmt;
                if (new_price != 0) {
                    new_price = this.convertToNumber(precio);
                }
                new_price = parseFloat(new_price);
                if (markup != 0 && markup != null) {
                    markup = parseFloat(this.agency_markup.markupAgencia);
                    var ganancia = (100 - markup) / 100;
                    new_price = new_price / ganancia;
                }

                if (markupRmt != 0 && markupRmt != null) {
                    markupRmt = parseFloat(this.agency_markup.markupRmt);
                    var gananciaRmt = (100 - markupRmt) / 100;
                    new_price = new_price / gananciaRmt;
                }

                if (!operacion) {
                    new_price = this.formatPrice(new_price);
                }
            }

            return new_price;
        },
        printPrecio: function(precio, moneda, id_hotel, tasa_cambio = 0) {
            new_price = this.aplicarMarkup(precio, id_hotel, 1);
            if (moneda != appHeader.currency && appHeader.currency != "OR") {
                if (moneda == "USD" && appHeader.currency == "MXN") {
                    if (tasa_cambio > 1) {
                        new_price = new_price * this.convertToNumber(tasa_cambio);
                    } else {
                        new_price = new_price * appHeader.exchange_rates.usd.sale;
                    }
                } else if (moneda == "MXN" && appHeader.currency == "USD") {
                    if (tasa_cambio > 1) {
                        new_price = new_price / this.convertToNumber(tasa_cambio);
                    } else {
                        new_price = new_price / appHeader.exchange_rates.usd.purchase;
                    }
                } else if (moneda == "MXN" && appHeader.currency == "COP") {
                    new_price = new_price / appHeader.exchange_rates.cop.purchase;
                } else if (moneda == "USD" && appHeader.currency == "COP") {
                    if (tasa_cambio > 1) {
                        new_price = new_price * this.convertToNumber(tasa_cambio);
                        new_price = new_price / appHeader.exchange_rates.cop.purchase;
                    } else {
                        new_price = new_price * appHeader.exchange_rates.usd.sale;
                        new_price = new_price / appHeader.exchange_rates.cop.purchase;
                    }
                }
            }
            new_price = this.formatPrice(new_price);
            return new_price;
        },
        printMoneda: function(moneda) {
            new_currency = moneda;
            if (moneda != appHeader.currency && appHeader.currency != "OR") {
                if (appHeader.currency == "MXN" && moneda == "USD") {
                    new_currency = "MXN";
                } else if (appHeader.currency == "USD" && moneda == "MXN") {
                    new_currency = "USD";
                } else if (appHeader.currency == "COP" && (moneda == "MXN" || moneda == "USD")) {
                    new_currency = "COP";
                }
            }
            return new_currency;
        },
        formatPrice(cant_dinero) {
            let val = (cant_dinero / 1).toFixed(2).replace(",", ".");
            return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        },
        countHotels: function(id_hotel) {
            var i;
            this.map_data.hotel.forEach(function(x, index) {
                if (x.id_hotel === id_hotel) {
                    i = index;
                }
            });
            return i;
        },
        LoadProveedores(tarifa) {
            var proveedor = "";
            switch (tarifa.proveedor) {
                case "0":
                    proveedor = "Ruta Maya Travel";
                    break;
                case "1":
                    proveedor = "Ruta Maya Travel";
                    break;
                case "2":
                    break;
                case "3":
                    break;
                case "4":
                    break;
                case "5":
                    break;
                case "6":
                    break;

                default:
                    break;
            }
        },
        closeModalHotel: function (id_hotel) {
            $('#modal_info_hotel_'+id_hotel).modal('hide');
         }
    },
    computed: {
        // slice the array of data to display
        sliced() {
            var vm = this;
            var rowscount = vm.tarifas.length;
            if (rowscount == 1) {
                searchforzona = false;
            } else {
                searchforzona = true;
            }
            if (this.contador_total_hoteles > 0) {
                vm.tarifasFilter = this.filtros(this.tarifas, rowscount, searchforzona);
            }

            return vm.tarifasFilter;
        },
        suggestions() {
            var vm = this;
            var rowscount = vm.tarifasSamesHotels.length;
            if (rowscount > 0) {
                tarifasHotelFilter = this.filtros(
                    this.tarifasSamesHotels,
                    rowscount,
                    false
                );
            }

            return tarifasHotelFilter;
        },
        suggestionsDestination() {
            var vm = this;
            var rowscount = vm.tarifasSamesDestination.length;
            if (rowscount > 0) {
                tarifasDestinoFilter = this.filtros(
                    this.tarifasSamesDestination,
                    rowscount,
                    false
                );
            }

            return tarifasDestinoFilter;
        },

        destacadosTarifas() {
            var that = this;
            var contDestacados = that.tarifas.filter((item) => {
                return item.destacado === 1;
            });

            var length_destacados = contDestacados.length;
            if (length_destacados > 5) {
                var random = Math.floor(Math.random() * length_destacados);
                while ((random + 5) > length_destacados) {
                    random--;
                }
                return contDestacados.slice(random, (random + 5));
            }

            return contDestacados;
        },
    },
    mounted() {
        this.scroll();
        $('[data-toggle="tooltip"]').tooltip({
            container: "body",
        });
        $(".range").ionRangeSlider({
            hide_min_max: true,
            keyboard: true,
            type: "double",
            step: 1,
            prefix: "$ ",
            min: 0,
            max: 0,
            from: 0,
            to: 0,
            grid: true,
        });

        this.my_range = $(".range").data("ionRangeSlider");
        var that = this;
    },
});

$(".range").on("change", function() {
    var $inp = $(this);
    appRates.rango_precio = {
        min: $inp.data("from"),
        max: $inp.data("to"),
    };
});

$("body").on("click", ".calendario", function() {
    var hotel = $(this).attr("data-id");
    var tarifa = $(this).attr("data-tarifa");
    var tipohab = $(this).attr("data-hab");
    var allotment = $(this).attr("data-allotment");
    var rate = $(this).attr("data-rate");
    var fecha_inicial = $(this).attr("data-fecha_inicial");
    var noches = $(this).attr("data-noches");
    var btnColor = $(this).attr("data-btnColor");
    var tarifa_rmt = appRates.tarifas.filter(function(e) {
        return e.id_hotel == hotel;
    });
    if (tarifa_rmt.length == 0) {
        tarifa_rmt = appRates.tarifasSamesHotels.filter(function(e) {
            return e.id_hotel == hotel;
        });
    }
    if (tarifa_rmt.length == 0) {
        tarifa_rmt = appRates.tarifasSamesDestination.filter(function(e) {
            return e.id_hotel == hotel;
        });
    }

    var habitacion_tarifa = tarifa_rmt[0].Habitaciones.filter(function(hab) {
        return hab.tipo_hab == tipohab;
    });

    $("#calendario_fechas").empty();
    $("#calendario_fechas").html(
        "<div align='center' style='margin-top:20px'><img src='" +
        baseUrl +
        "/images/loader.gif'></div>"
    );
    if (allotment == 0) {
        $("#modal-disponibilidad .accept").attr("data-dismiss", "modal");
        $("#modal-disponibilidad .accept").removeAttr("href");
        $("#modal-disponibilidad").modal("show");
    } else {
        $("#modal-calendario").modal("show");
    }
    jQuery.ajax({
        type: "POST",
        data: {
            id_hotel: hotel,
            id_tarifa: tarifa,
            id_tipohab: tipohab,
            rate: rate,
            fecha_inicio: fecha_inicial,
            noches: noches,
            habitacion: Base64.encode(JSON.stringify(habitacion_tarifa)),
            btnColor: btnColor,
        },
        success: function(html) {
            $("#calendario_fechas").html(html);
        },
        url: "https://www.tarifasmx1.rutamayatravel.com/site/consultarfechas.html",
        cache: false,
    });
    return false;
});

$("#modal-disponibilidad").on("hidden.bs.modal", function() {
    $("#modal-calendario").modal("show");
});

function sendReservacionAux(event) {
    appRates.sendReservacion(event);
}

function hideAllMarkers() {
    for (var key in appRates.markers)
        appRates.markers[key].forEach(function(marker) {
            if (validateMark(marker) === false) {
                marker.setMap(null);
            }
        });
}

$("body").on("click", ".cmn-toggle-switch", function() {
    $(".main-menu").addClass("show");
});

$('[data-toggle="tooltip"]').tooltip();