Vue.use(VueInfiniteLoading, { /* options */ });
Vue.component('infinite-loading');

var baseUrl = "/sur4demo";
Vue.http.options.emulateJSON = true;

var app = new Vue({
    el: "#tarifasVue",
    data: {
        search:"",
        tarifas:[],
        datos:[], 
        hoteles_RQ:[],
        habs:[],
        frontformVue:[],
        responseVue: false,
        selectedEstrellas:[],
        priceFilter:'1',
        radio_proveedor:'all',
        fullPage: false,
        selectedPlan:'0',
        tarifas_filter:[],
        responseController:false,
        regcount:1,
        contador:0,
        hotelDo:[],
        hotelBeds:[],

        page: 1,
        page_filter: 1,
        tarifas_scroll: [],
        tarifas_filter: [],
        tarifas_aux: [],
        api_url: rmt_url + '/api/',
        categorias: [],
        planes: [],
        query: null,

        infiniteId: +new Date(),
    },
    created() {
        this.hoteles_RQ = hotelesRQ;
        this.habs = habitacionesRQ;
        this.frontformVue = front_form;
        this.loadCategorias();
        this.loadPlanes();
    },
    methods:{
        sendForm: function(){
            console.log(this.fecha_entrada);
        },
        uppercaseFirstLetter(description) {
            return description.charAt(0).toUpperCase() + description.slice(1);
        },
        loadCategorias: function() {
            this.$http.get(this.api_url + 'categorias?limit=5').then(function(response) {
                var response_categorias = response.body;
                this.categorias = response_categorias.data.categorias;
            }, function() {
                console.log('Error');
            });
        },
        loadPlanes: function() {
            var url_plan = this.api_url + 'plan' + '?filter=[{"property":"estatus","value":1,"operator":"="}]';
            this.$http.get(encodeURI(url_plan)).then(function(response) {
                var response_planes = response.body;
                this.planes = response_planes.data.plan;
            }, function() {
                console.log('Error');
            });
        },
        infiniteHandler($state) {
            if(Object.keys(this.tarifas).length > 0) {
                if(Object.keys(this.tarifas_filter).length > 0) { this.loadMoreFilter($state); }
                else { this.loadMore($state); }
            } else {
                var params = { hotelesRQ: this.hoteles_RQ, habitacionesRQ: this.habs, front_form: this.frontformVue };
                this.$http.post(baseUrl + "/site/getTarifasVue", params).then(function(response){
                    this.tarifas = response.body.tarifa;
                    this.loadMore($state);
                });
            }
        },
        loadMore: function($state) {
            setTimeout(() => {
                try {
                    console.log("load more");
                    this.tarifas_scroll.push(...Object.entries(this.tarifas).slice(((this.page - 1) * 10),(this.page * 10)).map(entry => entry[1]));
                    this.page += 1;
                    if(Object.keys(this.tarifas).length == Object.keys(this.tarifas_scroll).length) {
                        $(".infinite-status-prompt").css('display', 'none');
                        $(".infinite-status-prompt").eq(2).css('display', 'block');
                    }
                } catch(error) {
                    console.log(error);
                }
                $state.loaded();
            }, 1000);
        },
        loadMoreFilter: function($state) {
            setTimeout(() => {
                try {
                    console.log("load more filter");
                    this.tarifas_scroll.push(...Object.entries(this.tarifas_filter).slice(((this.page_filter - 1) * 10),(this.page_filter * 10)).map(entry => entry[1]));
                    this.page_filter += 1;
                    if(Object.keys(this.tarifas_scroll).length == Object.keys(this.tarifas_filter).length) {
                        $(".infinite-status-prompt").css('display', 'none');
                        $(".infinite-status-prompt").eq(2).css('display', 'block');
                    }
                } catch(error) {
                    console.log(error);
                }
                $state.loaded();
            }, 1000);
        },
        filtrarTarifas: function() {
            console.log("filtrarTarifas");
            this.page = 1;
            this.tarifas_filter = [];

            var vm = this;
            this.tarifas_filter = Object.filter(this.tarifas, hotel => hotel.id_hotel > parseInt(this.query));
            //var filtered = Object.filter(scores, score => score > 1);
            //console.log(this.tarifas_filter);

            /*this.tarifas_filter = this.tarifas.filter((tarifa) => { 
                return tarifa.nombre_hotel.toLowerCase().includes(this.query.toLowerCase());
            });*/
            this.tarifas_scroll = [];
            this.tarifas_scroll.push(...Object.entries(this.tarifas_filter).slice(((this.page_filter - 1) * 10),(this.page_filter * 10)).map(entry => entry[1]));
        }
    },
    computed:{
        getTarifas() {
            console.log("computed");
            var vm = this;
            vm.page=1;
            vm.tarifasFilter = [];
            vm.infiniteId += 1;
            vm.tarifasFilter = vm.tarifas.filter((tarifa) => { 
                //FILTRO BUSQUEDA
                return tarifa.nombre_hotel.toLowerCase().includes(vm.search.toLowerCase());
            }).filter((item)=>{
                // FILTRO ESTRELLAS
                if (vm.selectedEstrellas.length > 0) {
                    return vm.selectedEstrellas.includes(parseInt(item.estrellas));
                } else {
                    return item;
                }
            }).filter((radio_pro)=>{
                var rmt = [0,2,4,5,6];
                var broker = [1,3];
                // FILTRO PROVEEDOR
                if (vm.radio_proveedor=="rmt") {
                    return rmt.includes(parseInt(radio_pro.proveedor));
                } else if (vm.radio_proveedor=="broker") {
                    return broker.includes(parseInt(radio_pro.proveedor));
                } else {
                    return radio_pro;
                }
            }).filter((plan)=>{
                // FILTRO PLANES
                if (vm.selectedPlan!=0) {
                    planes = Object.values(plan.Filtro.planes);
                    return planes.includes(parseInt(vm.selectedPlan));
                } else {
                    return plan;
                }
            });

            // FILTRO PRECIO
            if (vm.priceFilter == 2 || vm.priceFilter == 1) {
                return vm.tarifasFilter.sort(function(a, b) {
                    return parseFloat(a.Desglose.menorPrecio) - parseFloat(b.Desglose.menorPrecio);
                });
            } else if (vm.priceFilter == 3) {
                return vm.tarifasFilter.sort(function(a, b) {
                    return parseFloat(b.Desglose.menorPrecio) - parseFloat(a.Desglose.menorPrecio);
                });
            }
        }
    }
});

Object.filter = (obj, predicate) => 
    Object.keys(obj)
        .filter( key => predicate(obj[key]) )
        .reduce( (res, key) => (res[key] = obj[key], res), {} );