var baseUrl = "/sur4agencias";
Vue.http.options.emulateJSON = true;

var mapOptions = {
    zoom: 13,
    center: new google.maps.LatLng(23.625269,-99.9478396),
    mapTypeId: google.maps.MapTypeId.ROADMAP,

    mapTypeControl: false,
    mapTypeControlOptions: {
        style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
        position: google.maps.ControlPosition.LEFT_CENTER
    },
    panControl: false,
    panControlOptions: {
        position: google.maps.ControlPosition.TOP_RIGHT
    },
    zoomControl: true,
    zoomControlOptions: {
        style: google.maps.ZoomControlStyle.LARGE,
        position: google.maps.ControlPosition.TOP_LEFT
    },
    scrollwheel: false,
    scaleControl: false,
    scaleControlOptions: {
        position: google.maps.ControlPosition.TOP_LEFT
    },
    streetViewControl: true,
    streetViewControlOptions: {
        position: google.maps.ControlPosition.LEFT_TOP
    },
    styles: [
    {
        "featureType": "administrative.country",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "administrative.province",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "administrative.locality",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "administrative.neighborhood",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "administrative.land_parcel",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "landscape.man_made",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "simplified"
        }
        ]
    },
    {
        "featureType": "landscape.natural.landcover",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "on"
        }
        ]
    },
    {
        "featureType": "landscape.natural.terrain",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "poi.attraction",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "poi.business",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "poi.government",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "poi.medical",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "poi.park",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "on"
        }
        ]
    },
    {
        "featureType": "poi.park",
        "elementType": "labels",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "poi.place_of_worship",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "poi.school",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "poi.sports_complex",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "road.highway",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "road.highway",
        "elementType": "labels",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "road.highway.controlled_access",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "road.arterial",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "simplified"
        }
        ]
    },
    {
        "featureType": "road.local",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "simplified"
        }
        ]
    },
    {
        "featureType": "transit.line",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "transit.station.airport",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "transit.station.bus",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "transit.station.rail",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    },
    {
        "featureType": "water",
        "elementType": "all",
        "stylers": [
        {
            "visibility": "on"
        }
        ]
    },
    {
        "featureType": "water",
        "elementType": "labels",
        "stylers": [
        {
            "visibility": "off"
        }
        ]
    }
    ]
};

var app = new Vue({
    el: "#tarifasVue",
    data: {
        //Variables para v-for's
        api_url: rmt_url + '/api/',
        categorias: [],
        planes: [],
        tarifas: [],
        fotos_hotel: [],
        servicios_hotel: [],
        no_result: false,

        //variables para tarifas base
        model_id_hotel: 0,
        model_id_tipo_habitacion: 0,
        model_combinar: false,
        model_response_tarifas_base: null,

        //Variables para consultar webservice
        hotelesRQ:[],
        habs:[],
        frontformVue:[],

        // variables para usar en el interfaz
        resultadoBusquedaHoteles:[],
        frontForm:[],

        //variables a enviar a reservacion
        proveedor: '',
        datos_generales: '',
        datos_api: '',
        id_hotel: '',
        nombrehotel: '',
        input_front_form:[],
        input_resultado_busqueda:[],
        roomRates:'',

        //Variables para infinite scroll
        show   : false, // display content after API request
        offset : 5,     // items to display after scroll
        display: 5,     // initial items
        trigger: 300,   // how far from the bottom to trigger infinite scroll
        items  : [],    // server response data
        end    : false, // no more resources
        
        //Variables para filtros
        selected_plan:'0',
        search: '',
        price_filter:'1',
        selected_estrellas: [],
        selected_proveedor: [],
        selected_other_filters: [],
        selected_maps:0,
        tarifasFilter:[],
        totalFilter: 0,

        //Variables para mapa
        marker: [],
        uluru: '',
        map: '',
        map_data: {},

        //loaders
        loading: true, //tarifas
        loading_fotos: false, //Fotos de los hoteles
        loading_servicios: false, //Servicios de los hoteles
        loading_tarifas_base: false, //Tarifas base del hotel
        loading_hoteles_do: false, //Tarifas base del hotel
        loading_mismoHotel: false,
        loading_mismoDestino: false,


        //habiliar formulario
        habilitarForm: false,
        sinDisponibilidad: false,

        //habilitar tarifas de hotel do si existen
        existHotelDo: false,

        //para ejecutar una sola vez la function
        existIdHotelDo: [],

        //array para tarifas hotel do
        tarifasHDo: [],

        //habilitar tarifas sin disponibilidad en rmt
        mostrarTodasCheck: '',

        //habilitar sugerencias
        mismoHotelesSugerencias: false,
        mismoDestinoSugerencias: false,
        tarifasSamesHotels:[], // tarifas mismo hotel
        tarifasSamesDestination:[], // tarifas destino
        no_result_hotel_sugerencias:'', //mensaje si no hay tarifas
        no_result_destino_sugerencias:'', // mensaje si no hay tarifas

        array_brokers:[1,3],
        array_propios:[0,2,4,5,6],
        array_conectividad:[2,4,5,6],

        ubicacion_maps:'',
        dragMapaResult: false,
        mapObject:[],
        marker:[],
        markers:[],
        filtrando:false,
    },
    created() {
        this.hotelesRQ = hotelesRQ;
        this.habs = habitacionesRQ;
        this.frontformVue = front_form;
        this.tarifasHDo = new Array();
        // this.loadCategorias();
        // this.loadPlanes();
        this.loadTarifas();
    },
    methods:{
        loadCategorias: function() {
            // this.$http.get(this.api_url + 'categorias?limit=5').then(function(response) {
            //     var response_categorias = response.body;
            //     this.categorias = response_categorias.data.categorias;
            // }, function() {
            //     console.log('Error');
            // });
        },
        loadPlanes: function() {
            var url_plan = this.api_url + 'plan' + '?filter=[{"property":"estatus","value":1,"operator":"="}]';
            // this.$http.get(encodeURI(url_plan)).then(function(response) {
            //     var response_planes = response.body;
            //     this.planes = response_planes.data.plan;
            // }, function() {
            //     console.log('Error');
            // });
        },
        loadTarifas: function() {
            console.log(this.api_url);
            var params = { hotelesRQ: this.hotelesRQ, habitacionesRQ: this.habs, front_form: this.frontformVue };
            this.$http.post(baseUrl + "/site/getTarifas", params).then(function(response){
                // this.tarifas = Object.values(response.body.tarifa);
                if (response.body.count>0) {
                    this.tarifas=[];

                    this.tarifas = Object.values(response.body.row);
                    var that = this;
                    // this.cargarMapa(this.tarifas);
                    this.show = true;
                    this.loading = false;
                    $('input').iCheck({
                        checkboxClass: 'icheckbox_square-grey',
                        radioClass: 'iradio_square-grey'
                    }).on('ifChecked ifUnchecked', function(){
                        $(this)[0].dispatchEvent(new Event("change"));
                    });
                    $('#chk_rmt').iCheck('check');
                    $('#chk_so').iCheck('check');
                    this.resultadoBusquedaHoteles=JSON.parse(this.habs);
                    this.frontForm=JSON.parse(this.frontformVue);
                    if (this.tarifas.length==1) {
                        // llamamos a sugerencias con el mismo nombre
                        this.loadSamesHotels();
                        var hotel = [];
                        tarifas = Object.values(response.body.row);
                        disponibilidadPropio = true; disponibilidadApis = false; disponibilidadOB = false;
                        if (tarifas[0].proveedor==0) {disponibilidadPropio = tarifas[0].Desglose.disponibilidad_hotel;}
                        if (tarifas[0].proveedor!=0 || tarifas[0].proveedor==2) {
                            if (typeof (tarifas[0].Warning) !== 'undefined') {
                                disponibilidadApis = tarifas[0].Warning.warning;
                            }
                        }
                        if (tarifas[0].proveedor==2) {disponibilidadOB = tarifas[0].Desglose.NoDisponible;}

                        if (disponibilidadPropio == false || disponibilidadApis == true || disponibilidadOB == true) {
                            this.loadSamesDestination();
                        }
                    }

                }else{
                    if (this.ubicacion_maps=='') {
                        this.show = true;
                        this.loading = false;
                        this.no_result = true;
                    }
                }
            });
        },
        loadSamesHotels: function(){
            this.loading_mismoHotel = true;
            var params = {destinoRQ: this.frontForm.destino, habitacionesRQ: this.habs, front_form: this.frontformVue };
            this.$http.post(baseUrl + "/site/getSamesHotels", params).then(function(response){
                if (response.body!=null) {
                    this.tarifasSamesHotels = Object.values(response.body);
                }else{
                    this.no_result_hotel_sugerencias = "<div style='margin-top: 30px;font-size:14px;' class='alert alert-danger '><p><b>No se encontraron hoteles disponibles con las mismas similitudes</b></p></div>";
                }
                    this.mismoHotelesSugerencias = true;
                    this.loading_mismoHotel = false;
            });
        },
        loadSamesDestination: function(){
            this.loading_mismoDestino = true;
            var params = {destinoRQ: this.frontForm.destino, habitacionesRQ: this.habs, front_form: this.frontformVue };
            this.$http.post(baseUrl + "/site/getSamesDestinations", params).then(function(response){
                if (response.body!=null) {
                    this.tarifasSamesDestination = Object.values(response.body);
                }else{
                    this.no_result_destino_sugerencias = "<div style='margin-top: 30px;font-size:14px;' class='alert alert-danger '><p><b>No se encontraron otros hoteles disponibles con el mismo destino solicitado.</b></p></div>";
                }
                    this.mismoDestinoSugerencias = true;
                    this.loading_mismoDestino = false;
            });
        },
        loadMapaHoteles: function(){
            if (this.ubicacion_maps!='') {
                console.log(this.ubicacion_maps + '.......');
                var params = {ubicacion: this.ubicacion_maps, habitacionesRQ: this.habs, front_form: this.frontformVue };
                this.$http.post(baseUrl + "/site/dragMaps", params).then(function(response){
                    
                    if (response.body.count>0) {
                        this.hotelesRQ = JSON.stringify(response.body.row);
                        this.loadTarifas();
                        // console.log(this.tarifas);
                    }

                });
            }
        },
        cargarMapa: function(tarifas,searchforzona){
            var that = this;
            // console.log(tarifas.length);
            if (searchforzona==true) {
                that.map_data = {};
            }
            tarifas.forEach(function(element, index) {

                // if( typeof element.ubicacion != null || element.ubicacion != "" || (typeof element.ubicacion === "undefined")) {
                if( element.ubicacion !== '' ) {
                    var array_ubicacion = element.ubicacion.split("/");
                    var menorPrecio = ''; var mejorHabitacion = ''; var mejorPlan = '';var proveedor='';
                    if (element.Desglose) {
                        menorPrecio = '$ ' + element.Desglose.menorPrecio + ' ' + element.Desglose.moneda;
                        mejorHabitacion = element.Desglose.mejorHabitacion;
                        mejorPlan = element.Desglose.mejorPlan;
                    }
                    proveedor = element.foto.prov;
                    if(typeof that.map_data["hotel"] == "undefined"){
                        that.map_data["hotel"] = [];
                        that.map_data["hotel"].push({
                            name: element.nombre_hotel,
                            location_latitude: array_ubicacion[1], 
                            location_longitude: array_ubicacion[0],
                            map_image_url: element.foto.rutaImage,
                            name_point: element.nombre_hotel,
                            best_room: mejorHabitacion,
                            lower_price: menorPrecio,
                            best_plan: mejorPlan,
                            get_directions_start_address: '',
                            url_point: 'single_hotel.html',
                            proveedor: element.foto.prov
                        });
                    } else {
                        that.map_data["hotel"].push({
                            name: element.nombre_hotel,
                            location_latitude: array_ubicacion[1], 
                            location_longitude: array_ubicacion[0],
                            map_image_url: element.foto.rutaImage,
                            name_point: element.nombre_hotel,
                            best_room: mejorHabitacion,
                            lower_price: menorPrecio,
                            best_plan: mejorPlan,
                            get_directions_start_address: '',
                            url_point: 'single_hotel.html',
                            proveedor: element.foto.prov
                        });
                    }
                }
            });
            $.getScript((rmt_url + "/vue/mapas_cotizador_hoteles.js"), function( data, textStatus, jqxhr ) {
                    // console.log(JSON.stringify(that.map_data));
                    // console.log( textStatus ); // Success
                    // console.log( jqxhr.status ); // 200
                });
        },
        getRatesHD: function(event){
            var btn_send = event.currentTarget;
            var proveedor = btn_send.getAttribute('data-proveedor');
            var codigo_hotel = btn_send.getAttribute('data-codigoHotel');
            var id_hotel = btn_send.getAttribute('data-idHotel');
            var dataHDo = { codigoHotel: codigo_hotel, idHotel: id_hotel, front_form: this.frontformVue, fecha_inicial: this.resultadoBusquedaHoteles.fecha_inicial };

            var tarifasHDo_aux = new Array();

            $("#hotelDo_"+id_hotel).html("<div align='center'><i class='fa fa-spinner fa-pulse fa-3x fa-fw'></i> Cargando...</div>");

            $.ajax({
                'url':baseUrl + "/travelSolution/getRatesHD",
                'type':'POST',
                'data': dataHDo,
                async: true,
            })
            .done(function(html){

                $("#hotelDo_"+id_hotel).html("");
                    $("#hotelDo_"+id_hotel).append(html); //imprimo el html
                    
                });

            if (this.existIdHotelDo.includes(id_hotel)===false) {

            }else{

                var html = this.tarifasHDo[id_hotel].html;
                console.log(html);
            }
        },
        loadFotosHotel: function() {
            element = event.currentTarget;
            var id_hotel = element.getAttribute('data-id_hotel');
            var proveedor = element.getAttribute('data-nuevo');
            $("#tab_hotel_"+id_hotel).html("<div align='center' style='margin-top:10px'><img src='/reservaciones/sur3/images/loader.gif'></div>");
            // var url_hotel_fotos = this.api_url + 'hotelesFotos?filter=[{"property":"id_hotel","value":' + id_hotel + ',"operator":=}]';
            var url_hotel_fotos = baseUrl + '/hotelesFotos/hotelesFotos';
            this.$http.post(url_hotel_fotos,{id_hotel:id_hotel,proveedor:proveedor}).then(function(response) {
                // console.log(response.body);
                if (response.body !== 'undefined' || response.body !== null) {
                    var html = "";
                    this.fotos_hotel = response.body.data.hotelesFotos;
                    this.loading_fotos = false;

                    if(proveedor==1)
                    {
                        var urlfoto = "https://photos.hotelbeds.com/giata/";
                        var medium ="medium/";
                        var bigger ="bigger/";
                    }
                    else if(proveedor==3 || proveedor==5 || proveedor == 2)
                    {
                        var urlfoto="";
                        var medium="";
                        var bigger="";                
                    }
                    else 
                    {
                        var urlfoto = "https://rutamayatravel.com/imagenes/";
                        var medium ="";
                        var bigger ="";                
                    }

                    $.each(this.fotos_hotel,function(index,value){
                        html += "<div class=\"col-3\"><a href=\""+urlfoto+bigger+value.foto+"\" data-toggle='lightbox' data-gallery='example-gallery' data-max-height='500'><img src=\""+urlfoto+medium+value.foto+"\" width='100%' /> </a> </div>";
                    });
                    $("#tab_hotel_"+id_hotel).html(html);
                }else{
                    $("#tab_hotel_"+id_hotel).html('');
                }

            }, function() {
                $("#tab_hotel_"+id_hotel).html('');
            });
        },
        loadServiciosHotel: function() {
            element = event.currentTarget;
            var id_hotel = element.getAttribute('data-id_hotel');
            var proveedor = element.getAttribute('data-nuevo');
            $("#tab_servicio_"+id_hotel).html("<div align='center' style='margin-top:10px'><img src='/reservaciones/sur3/images/loader.gif'></div>");
            // var url_hotel_servicio = this.api_url + 'hotelServDef?filter=[{"property":"id_hotel","value":' + id_hotel + ',"operator":=}]';
            var url_hotel_servicio = baseUrl + '/site/hotelServDef';
            this.$http.post(url_hotel_servicio,{id_hotel:id_hotel,proveedor:proveedor}).then(function(response) {
                $("#tab_servicio_"+id_hotel).html(response.body);
            }, function() {
                console.log('Error');
            });
        },
        loadMapaHotel: function() {
            element = event.currentTarget;
            var id_hotel = element.getAttribute('data-id_hotel');
            var info_ubicacion = this.tarifas.filter(function(i) {
                return i.id_hotel === id_hotel;
            });
            var array_ubicacion = info_ubicacion[0].ubicacion.split("/");
            this.uluru = { lat: parseFloat(array_ubicacion[1]), lng: parseFloat(array_ubicacion[0]) };
            this.map = new google.maps.Map(
                document.getElementById('map_' + id_hotel), {
                    zoom: 13,
                    center: this.uluru
            });
            this.marker = new google.maps.Marker({position: this.uluru, map: this.map, draggable: false, animation: google.maps.Animation.DROP});
        },
		hideAllMarkers: function() {
			for (var i = 0; i < this.markers.length; i++) {
				this.markers[i].setMap(null);
			}
			this.markers = [];
        },
        setIdHotel: function() {
        	element = event.currentTarget;
            this.model_id_hotel = element.getAttribute('data-id_hotel');
        },
        setIdTipoHabitacion: function() {
        	element = event.currentTarget;
            this.model_id_tipo_habitacion = element.getAttribute('data-id_tipo_habitacion');
            this.model_response_tarifas_base = null;
        },
        loadTarifasBaseHotel() {
            this.loading_tarifas_base = true;
        	element = event.currentTarget;
            var id_tarifa = element.getAttribute('data-id_tarifa');
            var fecha_inicial = JSON.parse(app.habs).fecha_final;
            var noches = JSON.parse(app.habs).noches;
			var postData = { "id_hotel": this.model_id_hotel, "id_tarifa": id_tarifa, "id_hab": this.model_id_tipo_habitacion, "fecha_inicio": fecha_inicial, "noches": noches, "combinar": false };
            this.$http.post('tarifasBase', postData).then(function(response) {
            	this.model_response_tarifas_base = response.body;
            	$("a").tooltip();
                this.loading_tarifas_base = false;
            }, function() {
                console.log('Error');
            });
        },
        ocultarBoton(id_hotel){
            $("#click_"+id_hotel).toggleClass('d-none');
        },
        convertToBase64Decode: function(data){
           var result = atob(data);
           return result;
        },
        convertToBase64Encode: function(data){
           var result = Base64.encode(data);
           return result;
        },
        convertToNumber: function(numero){
            var number = numero.replace(',','');
            return parseFloat(number);
        },
        buildJson: function(id_hotel,nombre_hotel,id_plan,tipo_plan,code_hotel,id_habitacion,precio,moneda,tarifa,markup){
            var data_general = new Array();

            data_general = {
                "id_hotel" : id_hotel,
                "nombre_hotel" : nombre_hotel,
                "id_plan" : id_plan,
                "tipo_plan" : tipo_plan,
                "code_hotel" : code_hotel,
                "id_habitacion" : id_habitacion,
                "precio" : this.convertToNumber(precio),
                "moneda" : moneda,
                "id_tarifa" : tarifa,
                "markup": markup
            }

            return Base64.encode(JSON.stringify(data_general));
        },
        convertToJsonApi: function(api){

            // return this.convertToBase64Encode(api);
            return Base64.encode(JSON.stringify(api));
        },
        sendReservacion: function(event){

            // console.log(event.currentTarget.getAttribute('data-id_hotel'));
            var btn = event.currentTarget;
            var id_hotel = btn.getAttribute('data-id_hotel');

            this.proveedor = btn.getAttribute('data-proveedor');

            if (this.proveedor==2 || this.proveedor==3) {
            	this.roomRates = $("#roomRates_"+id_hotel).val();
            }
            this.datos_generales = btn.getAttribute('data-general');
            this.datos_api = btn.getAttribute('data-api');
            this.input_front_form = this.convertToBase64Encode(this.frontformVue);
            this.input_resultado_busqueda = this.convertToBase64Encode(this.habs);

            this.sendForm();
        },
        sendForm: function(){
            
            setTimeout(function(){
            
            if (this.input_resultado_busqueda != '') {
                $("#formReservacion").submit();
            }

            },2000);
        },
        convertToJsonDecode: function(texto){
            return JSON.parse(texto);
        },
        convertToJsonEncode: function(texto){
            return JSON.stringify(texto);
        },
        mostrarTodas: function(id_hotel){
        	$(".ocultarTarifa_"+id_hotel).toggleClass('d-none');
        },
        filterMapaGoogle: function(nombre_hotel){
            console.log(nombre_hotel);
            this.search = nombre_hotel;
        },
        filtros: function(tarifas, rowscount,searchforzona){
            var vm = this;
            var tarifasFilter = [];
            this.filtrando = false;

            if (rowscount == 1) {
                // vm.tarifas.Warning && 
                this.cargarMapa(tarifas,searchforzona);
                return tarifas.slice(0, this.display);
            } else {
                // FILTRO PRECIO
                if (vm.price_filter == 2 || vm.price_filter == 1) {

                    var orderPrecio_a = 0; 
                    var orderPrecio_b = 0; 
                    tarifas.sort(function(a, b) {
                        if (a.Desglose.moneda=='USD') {
                            orderPrecio_a = a.Desglose.menorPrecio_mxn;
                        }else{
                            orderPrecio_a = a.Desglose.menorPrecio;
                        }

                        if (b.Desglose.moneda=='USD') {
                            orderPrecio_b = b.Desglose.menorPrecio_mxn;
                        }else{
                            orderPrecio_b = b.Desglose.menorPrecio;
                        }
                        return vm.convertToNumber(orderPrecio_a) - vm.convertToNumber(orderPrecio_b);
                    });
                } else if (vm.price_filter == 3) {
                    tarifas.sort(function(a, b) {
                        if (a.Desglose.moneda=='USD') {
                            orderPrecio_a = a.Desglose.menorPrecio_mxn;
                        }else{
                            orderPrecio_a = a.Desglose.menorPrecio;
                        }

                        if (b.Desglose.moneda=='USD') {
                            orderPrecio_b = b.Desglose.menorPrecio_mxn;
                        }else{
                            orderPrecio_b = b.Desglose.menorPrecio;
                        }
                        return vm.convertToNumber(orderPrecio_b) - vm.convertToNumber(orderPrecio_a);
                    });
                }

                tarifasFilter = tarifas.filter((tarifa) => { 
                    if (tarifa.proveedor == 3) {
                        $("#hotelDo_"+tarifa.id_hotel).html("");
                    }

                    if (tarifa.proveedor == 0) {

                    }
                    //FILTRO BUSQUEDA
                    if (vm.search!=='') {this.filtrando=true;}
                    return tarifa.nombre_hotel.toLowerCase().includes(vm.search.toLowerCase());
                }).filter((stars) => {
                    // FILTRO ESTRELLAS
                    if (vm.selected_estrellas.length > 0) {
                    	this.filtrando=true;
                        return vm.selected_estrellas.includes(parseInt(stars.estrellas));
                    } else {
                        return stars;
                    }
                }).filter((proveedor) => {
                    var rmt = [0, 2, 4, 5, 6];
                    var broker = [1, 3];
                    // FILTRO PROVEEDOR
                    if(vm.selected_proveedor.length == 1) {
                        if(vm.selected_proveedor[0] == "rmt") {
                            return rmt.includes(parseInt(proveedor.proveedor));
                        }
                        return broker.includes(parseInt(proveedor.proveedor));
                    } else {
                        return proveedor;
                    }
                }).filter((other) => {
                    if(vm.selected_other_filters.length > 0) {
                    	this.filtrando = true;
                        return other.Filtro.temas.toLowerCase().includes(vm.selected_other_filters);
                    }
                    return other;
                }).filter((plan) => {
                    // FILTRO PLANES
                    if (vm.selected_plan!=0) {
                    	this.filtrando=true;
                        planes = Object.values(plan.Filtro.planes);
                        return planes.includes(parseInt(vm.selected_plan));
                    } else {
                        return plan;
                    }
                });

                this.totalFilter = tarifasFilter.length;
                
                tarifasFilter = tarifasFilter.slice(0, this.display);
                
                this.cargarMapa(tarifasFilter,searchforzona);
                return tarifasFilter;
            }


        },
        // check to see if we're at the bottom of the page
        scroll() {
            var capa = document.getElementById('resultadoTarifas');
            capa.onscroll = ev => {
                if (
                	$('#resultadoTarifas').innerHeight() + $('#resultadoTarifas').scrollTop() >= 
                	($('#div_tarifas')[0].offsetHeight - this.trigger)
                ) {
                    if (this.display < this.tarifas.length) {
                        this.display = this.display + this.offset;
                    } else {
                        this.end = true;
                    }
                }
            };
        },
        onHtmlClick: function(location_type,key){
            onHtmlClick(location_type,key);
        },
        test_method: function() {
            console.log("change");
        }
    },
    computed: {
        // slice the array of data to display
        sliced() {
            var vm = this;
            var rowscount = vm.resultadoBusquedaHoteles.totalHoteles;
            if (rowscount==1) {searchforzona=false;}else{searchforzona=true;}
            vm.tarifasFilter = this.filtros(this.tarifas, rowscount,searchforzona);

            return vm.tarifasFilter;
        },
        suggestions() {
            var vm = this;
            var rowscount = vm.tarifasSamesHotels.length;
            if (rowscount>0) {
                tarifasHotelFilter = this.filtros(this.tarifasSamesHotels, rowscount,false);
            }

            return tarifasHotelFilter;
        },
        suggestionsDestination() {
            var vm = this;
            var rowscount = vm.tarifasSamesDestination.length;
            if (rowscount>0) {
             tarifasDestinoFilter = this.filtros(this.tarifasSamesDestination, rowscount,false);
            }

            return tarifasDestinoFilter;  
        }
    },
    mounted() {
        // track scroll event
        this.mapObject = new google.maps.Map(document.getElementById('map'), mapOptions);
        this.scroll();
    },
});


$('body').on('click','.calendario',function(){
    var hotel = $(this).attr("data-id");
    var tarifa = $(this).attr("data-tarifa");
    var tipohab = $(this).attr("data-hab");
    var allotment = $(this).attr("data-allotment");
    var rate = $(this).attr("data-rate");
    var fecha_inicial = $(this).attr("data-fecha_inicial");
    var noches = $(this).attr("data-noches");
    var btnColor = $(this).attr("data-btnColor");
    var tarifa_rmt = app.tarifas.filter(function(e) {
        return e.id_hotel == hotel;
    });

    var habitacion_tarifa = tarifa_rmt[0].Habitaciones.filter(function(hab) {
        return hab.tipo_hab == tipohab;
    });

    // console.log(habitacion_tarifa);

    $("#calendario_fechas").empty();
    $("#calendario_fechas").html("<div align='center' style='margin-top:20px'><img src='"+baseUrl+"/images/loader.gif'></div>");
    if(allotment == 0){
        $("#modal-disponibilidad .accept").attr('data-dismiss','modal');
        $("#modal-disponibilidad .accept").removeAttr('href');
        $("#modal-disponibilidad").modal('show');
    }else{
        $("#modal-calendario").modal('show');
    }
    jQuery.ajax({'type':'POST','data':{'id_hotel':hotel,'id_tarifa':tarifa,'id_tipohab':tipohab,'rate':rate,'fecha_inicio':fecha_inicial,'noches':noches, 'habitacion':Base64.encode(JSON.stringify(habitacion_tarifa)), 'btnColor':btnColor},'success':function(html){
        $("#calendario_fechas").html(html);
    },'url':baseUrl + '/site/consultarfechas.html','cache':false});return false;
});


$('#modal-disponibilidad').on('hidden.bs.modal', function () {
    $("#modal-calendario").modal('show');
});


app.mapObject.addListener('dragend', function() {
    var latlg = app.mapObject.getCenter();
    app.ubicacion_maps = latlg.lat() + '/' + latlg.lng();

    var pos = {
        lat: parseFloat(latlg.lat()),
        lng: parseFloat(latlg.lng())
    };

    var norte = pos['lat'] + 0.03;
    var sur = pos['lat'] - 0.03;

    var este = pos['lng']+ 0.02;
    var oeste = pos['lng'] - 0.02;

    var bounds = {
        north: norte,
        south: sur,
        east: este,
        west: oeste
    };


    rectangle = new google.maps.Rectangle({
        bounds: bounds,
        editable: false,
        draggable: false
    })

    // rectangle.setMap(app.mapObject);
    if (app.selected_maps!=0) {
        // console.log(app.selected_maps);
        app.loadMapaHoteles();
    }
});