var appTransaccionesKueskiPay = new Vue({
    el: "#transacciones_kueskipay",
    data: {
      baseUrl: baseUrl,
      array_transaccion: [],
      estatus: estatus,
      url_reserva:
        "https://www.rutamayatravel.com/sur4/reservacion/guardarBooking",
      url_sur4: "https://www.rutamayatravel.com/sur4/",
      datos_reserva: datos_reserva,
      datos_formulario: datos_formulario,
    },
    created: function () {
      console.log("creo componente");
      console.log("estatus: " + this.estatus);
      if (this.estatus == "1") {
        this.crearReservacion();
      }
    },
    methods: {
      crearReservacion: function () {
        console.log("entra crear reserva");
        var form = this.datos_formulario;
        var uniquekey = {
          name: "datos",
          value: this.datos_reserva,
        };
  
        form.push(uniquekey);
  
        $.ajax({
          url: this.url_reserva,
          type: "POST",
          data: form,
          dataType: "JSON",
  
          success: function (data) {
            console.log(data);
            if (data.cupon != null) {
              console.log(data);
              console.log(data.cupon);
              console.log("Se creo cupon");
              appTransaccionesKueskiPay.datosCliente(data.cupon);
              console.log("enviar correo");
            }
            appTransaccionesKueskiPay.emailOpenPay(data.cupon);
            appTransaccionesKueskiPay.sweetReservacion(data.cupon);
            // else {
            //     $("#modal-reservar .modal-body").append("<div class=\'alert alert-danger\'>HUBO UN ERROR AL INTENTAR CREAR SU RESERVACIÓN! FAVOR DE CONTACTAR A RUTA MAYA TRAVEL.</div>");
            // }
          },
          error: function (xhr) {
            console.log("ERROR: " + xhr.responseText);
            sweetError(
              xhr,
              "Ha ocurrido un error al tratar de realizar la reserva",
              "replace"
            );
          },
        });
      },
  
      sweetReservacion: function (cupon) {
        let timerInterval;
        Swal.fire({
          title: "!Reservación Creada!",
          text: "Estamos Redireccionando a su reservación...",
          timer: 3000,
          timerProgressBar: false,
          didOpen: () => {
            Swal.showLoading();
            timerInterval = setInterval(() => {
              const content = Swal.getHtmlContainer();
  
              Swal.getTimerLeft();
            }, 100);
          },
          willClose: () => {
            clearInterval(timerInterval);
          },
        }).then((result) => {
          if (result.dismiss === Swal.DismissReason.timer) {
            window.location.replace(
              this.baseUrl + "/reservacion/view/id/" + cupon
            );
            console.log("redireccionamiento al cupon: " + cupon);
            console.log(this.baseUrl);
          }
        });
      },
  
      datosCliente: function (cupon) {
        var paramscliente = new Object();
        paramscliente.id_reservacion = cupon;
        paramscliente.id_agencia =
          appTransaccionesKueskiPay.datos_formulario[5].value;
        paramscliente.telefono =
          appTransaccionesKueskiPay.datos_formulario[7].value;
        paramscliente.email = appTransaccionesKueskiPay.datos_formulario[8].value;
        console.log("paramsCliente: ");
        console.log(paramscliente);
        $.ajax({
          url: appTransaccionesKueskiPay.baseUrl + "/reservacion/datosCliente",
          type: "POST",
          data: paramscliente,
          success: function (data) {
            convertido = JSON.parse(data);
            appTransaccionesKueskiPay.emailCliente(
              convertido.id_datos_clientes,
              cupon
            );
          },
        });
      },
  
      emailCliente: function (id, cupon) {
        var url =
          appTransaccionesKueskiPay.url_sur4 +
          "/solicitudReservacion/enviarEmailCliente/id/" +
          id;
        $.ajax({
          url: url,
          data:
            "{id_reservacion:" +
            cupon +
            ", email:" +
            appTransaccionesKueskiPay.datos_formulario[8].value +
            ", telefono:" +
            appTransaccionesKueskiPay.datos_formulario[7].value +
            ", agencia:" +
            appTransaccionesKueskiPay.datos_formulario[5].value +
            "}",
          type: "post",
          success: function (e) {
            console.log("email Enviado al cliente");
          },
        });
      },
  
      emailOpenPay: function (cupon) {
        var params = new Object();
        params.cupon = cupon;
        params.id_agencia = appTransaccionesKueskiPay.datos_formulario[5].value;
        params.telefono = appTransaccionesKueskiPay.datos_formulario[7].value;
        params.correo = appTransaccionesKueskiPay.datos_formulario[8].value;
  
        $.ajax({
          url: appTransaccionesKueskiPay.baseUrl + "/reservacion/emailKueskiPay",
          type: "POST",
          data: params,
        });
      },
    },
  });
  