var appTransaccionesOpenpay = new Vue({
    el: '#transacciones_openpay',
    data: {
        baseUrl: baseUrl,
        id_transaccion: id_transaccion,
        array_transaccion: [],
        loaded: false,
        fallo: false,
        tarjeta_estatus: true,
        cont: 0,
        url_reserva: "https://www.rutamayatravel.com/sur4/reservacion/guardarBooking",
        url_sur4: "https://www.rutamayatravel.com/sur4",
        datos_reserva: datos_reserva,
        datos_formulario: datos_formulario
    },
    created: function () {
        this.getTransaccion();
    },

    methods: {
        getTransaccion: function () {
            this.loaded = true;
            if ((typeof this.array_transaccion.id_transaccion) == "undefined" && this.cont <= 6) {
                this.request();
            } else {
                this.tarjeta_estatus = false
                this.loaded = false;
                this.fallo = true;
            }
        },
        request: function () {
            setTimeout(() => {
                this.cont++;
                this.$http.get(this.baseUrl + "/reservacion/getTransaccionOpenpay?id=" + this.id_transaccion)
                    .then(function (response) {
                        if (response.data.success) {
                            this.array_transaccion = response.data.data;
                            this.loaded = false;
                            if (this.array_transaccion.estatus == "charges.3ds.authenticated" || this.array_transaccion.estatus == "charge.succeeded") {
                                this.crearReservacion();
                            }
                        } else {
                            this.getTransaccion();
                        }
                    })
            }, 10000);
        },

        crearReservacion: function () {
            var form = this.datos_formulario;
            var uniquekey = {
                name: "datos",
                value: this.datos_reserva
            };

            form.push(uniquekey);

            $.ajax({
                url: appTransaccionesOpenpay.url_reserva,
                type: "POST",
                data: form,
                dataType: "JSON",

                success: function (data) {
                    if (data.cupon != null) {
                        appTransaccionesOpenpay.datosCliente(data.cupon);
                    }
                    appTransaccionesOpenpay.emailOpenpay(data.cupon);
                    appTransaccionesOpenpay.sweetReservacion(data.cupon);
                    // else {
                    //     $("#modal-reservar .modal-body").append("<div class=\'alert alert-danger\'>HUBO UN ERROR AL INTENTAR CREAR SU RESERVACIÓN! FAVOR DE CONTACTAR A RUTA MAYA TRAVEL.</div>");
                    // }
                },
                error: function (xhr) {
                    console.log("ERROR: " + xhr.responseText);
                    sweetError(xhr, "A ocurrido un error al tratar de realizar la reserva", "replace");
                }
            })
        },

        sweetReservacion: function (cupon) {
            let timerInterval
            Swal.fire({
                title: '!Reservación Creada!',
                text: 'Estamos Redireccionando a su reservación...',
                timer: 3000,
                timerProgressBar: false,
                imageUrl: 'https://rutamayatravel.com/images/onboarding/pose2-2.png',
                imageWidth: 200,
                imageAlt: 'Reservación creada',
                didOpen: () => {
                    Swal.showLoading()
                    timerInterval = setInterval(() => {
                        const content = Swal.getHtmlContainer()

                        Swal.getTimerLeft()


                    }, 100)
                },
                willClose: () => {
                    clearInterval(timerInterval)
                }
            }).then((result) => {
                if (result.dismiss === Swal.DismissReason.timer) {
                    window.location.replace(this.baseUrl + '/reservacion/view/id/' + cupon);
                    console.log("no redirecciona xd");
                }

            })
        },

        datosCliente: function (cupon) {
            var paramscliente = new Object();
            paramscliente.id_reservacion = cupon;
            paramscliente.id_agencia = appTransaccionesOpenpay.datos_formulario[5].value;
            paramscliente.telefono = appTransaccionesOpenpay.datos_formulario[7].value;
            paramscliente.email = appTransaccionesOpenpay.datos_formulario[8].value;

            $.ajax({
                url: appTransaccionesOpenpay.baseUrl + "/reservacion/datosCliente",
                type: "POST",
                data: paramscliente,
                success: function (data) {
                    convertido = JSON.parse(data); 
                    appTransaccionesOpenpay.emailCliente(convertido.id_datos_clientes, cupon);
                }
            })

        },

        emailCliente: function (id, cupon) {
            console.log("Entra a la funcion de email cliente");
            console.log("id del cliente: "+id);
            console.log("id reservacion"+ cupon);
            var url = appTransaccionesOpenpay.url_sur4 + "/solicitudReservacion/enviarEmailCliente/id/" + id;
            $.ajax({
                url: url,
                data: '{id_reservacion:' + cupon + ', email:' + appTransaccionesOpenpay.datos_formulario[8].value + ', telefono:' + appTransaccionesOpenpay.datos_formulario[7].value + ', agencia:' + appTransaccionesOpenpay.datos_formulario[5].value + '}',
                type: 'post',
                success: function (e) {
                    console.log("email Enviado al cliente");

                }
            })
        },

        emailOpenpay: function (cupon) {
            var params = new Object();
            params.cupon = cupon;
            params.id_agencia = appTransaccionesOpenpay.datos_formulario[5].value;
            params.telefono = appTransaccionesOpenpay.datos_formulario[7].value;
            params.correo = appTransaccionesOpenpay.datos_formulario[8].value;

            $.ajax({
                url: appTransaccionesOpenpay.baseUrl + "/reservacion/emailOpenpay",
                type: "POST",
                data: params,
            })
        },

    },
});