Vue.component("v-multiselect", window.VueMultiselect.default);
Vue.http.options.emulateJSON = true;
var transportacionv1 = new Vue({
  el: "#transportacionv1",
  data: {
    rmt_url: "https://rutamayatravel.com/sur4agencias",
    tipo_viaje: true,
    model_destino: "",
    model_ciudad: "",
    options: [],
    isLoading: false,
    model_rango_estancia: "",
    rango_estancia: {
      fecha_entrada: "",
      fecha_salida: "",
    },
    hdp: false,
    tipo_viaje: false,
    tipo_servicio: false,
    modo: {
      inicio: "Aeropuerto",
      fin: "Hotel",
    },
    pasajeros: {
      cantidad: 1,
    },
    codescity: [
      {
        code: 'CUN',
        name: 'Cancún/Riviera Maya'
      },
      {
        code: 'MID',
        name: 'Mérida'
      },
      {
        code: 'COZ',
        name: 'Cozumel'
      },
      {
        code: 'CAB',
        name: 'Los Cabos'
      }
    ],
    options_ciudad: [],
    availRequest: {
      codecity: '',
      idtour: null,
      direccion: null,
      id_hotel: null,
      nombre_hotel: null,
      code: null,
      zona: null,
      city: "",
      tipo_servicio: "",
      adultos: 1,
      fecha_salida: "",
      fecha_llegada: "",
      deluxe: 0,
      tarifa_neta: "",
      total: "",
      moneda: "MXN",
      okpass: 0,
    },
    responseAvail: [],
    changedInfo: false,
    updateInfo: false,
    cantidad_de_dias: 0,
    selectedDestino: "",
    selectedCiudad: "",
    settings_date: fechaPermitido,
  },
  created() {
    this.loadInfo();
    if (this.settings_date !== "") {
      this.settings_date = moment(this.settings_date, "DD/MM/YYYY").format(
        "DD/MM/YYYY"
      );
    }
    // this.validarTipoServicio();
    if (this.tipo_viaje) {
      this.btnSencillo();
    } else {
      this.btnRedondo();
    }
    if (this.tipo_servicio) {
      this.btnDeluxe();
    } else {
      this.btnRegular();
    }
  },
  methods: {
    loadDestinations: function (query) {
      this.initOptions();
      if (query.length >= 3) {
        this.isLoading = true;
        this.$http
          .post(
            this.rmt_url + "/transportacion/SearchDestinationsv2",
            { search: query },
            {
              before(request) {
                if (this.previousRequest) {
                  this.previousRequest.abort();
                }
                this.previousRequest = request;
              },
            }
          )
          .then(
            function (response) {
              this.isLoading = false;
              var response_var = response.body;
              var array_destinos = response_var;
              var that = this;
              array_destinos.forEach(function (element) {
                // if (element.City == that.availRequest.codecity) {
                that.options[0].opciones.push(element);
                // }
              });
            },
            function () {
              // console.log('Error');
            }
          );
      }
    },
    loadCiudades: function () {
      this.options_ciudad = [];
      this.options_ciudad.push({
        tipo_destino: "Ciudades",
        opciones: [{
          code: 'CUN',
          name: 'Cancún/Riviera Maya'
        },
        {
          code: 'MID',
          name: 'Mérida'
        },
        {
          code: 'COZ',
          name: 'Cozumel'
        },
        {
          code: 'CAB',
          name: 'Los Cabos'
        }],
      });
    },
    setCiudad: function (selectedOption, id) {
      console.log("option", selectedOption);
      console.log("id", id);
      var destino;
      destino = selectedOption.code;
      this.availRequest.codecity = selectedOption.code;

    },
    setDestino: function (selectedOption, id) {
      var destino;
      destino = selectedOption.Codigo;
      this.selectedDestino = selectedOption;
      // console.log(this.selectedDestino);
      this.limpiarPrecio();
    },

    initOptions: function () {
      this.options = [];
      this.options.push({
        tipo_destino: "Hoteles",
        opciones: [],
      });
    },
    loadInfo() {
      var fecha_entrada = moment().format("DD/MM/YYYY");
      var fecha_salida = moment()
        .add(3, "days")
        .format("DD/MM/YYYY");
      if (this.settings_date !== "") {
        fecha_entrada = moment(this.settings_date, "DD/MM/YYYY").format(
          "DD/MM/YYYY"
        );
        fecha_salida = moment(this.settings_date, "DD/MM/YYYY")
          .add(3, "days")
          .format("DD/MM/YYYY");
      }
      // console.log('fecha_salida' + fecha_salida)
      this.model_rango_estancia = fecha_entrada + " - " + fecha_salida;
      this.rango_estancia = {
        fecha_entrada: fecha_entrada,
        fecha_salida: fecha_salida,
      };
    },
    toggleInput: function () {
      if (this.hdp == false) {
        $("#datepicker-dp_estancia_web").toggle();
        $(".datepicker__inner").toggle();
        this.hdp = true;
      }
    },

    calculardiferencia: function (d1, d2) {
      var entrada = new Date(
        d1.split("/")[2],
        d1.split("/")[1],
        d1.split("/")[0]
      );
      var salida = new Date(
        d2.split("/")[2],
        d2.split("/")[1],
        d2.split("/")[0]
      );
      var t2 = salida.getTime();
      var t1 = entrada.getTime();

      return parseInt((t2 - t1) / (24 * 3600 * 1000));
    },
    sumar3dias: function (d1, d2) {
      var entrada = new Date(
        d1.split("/")[2],
        d1.split("/")[1],
        d1.split("/")[0]
      );
      var salida = new Date(
        d2.split("/")[2],
        d2.split("/")[1],
        d2.split("/")[0]
      );
      fecha.setDate(entrada.getDate() + 3);
      return entrada;
    },
    btnSencillo() {
      $("#viaje_sencillo").addClass("selected_transporte");
      $("#viaje_redondo").removeClass("selected_transporte");
      this.tipo_viaje = false;
      $("#estancia_sencillo").removeClass("d-none");
      $("#estancia_redondo").addClass("d-none");

      this.model_rango_estancia = $("#dp_estancia_web").val();
      var rango = this.model_rango_estancia.split("-");
      this.rango_estancia.fecha_entrada = rango[0].replace(/\s/g, "");
      this.rango_estancia.fecha_salida = rango[1].replace(/\s/g, "");

      $("#fechaIni").datepicker("setDate", this.rango_estancia.fecha_entrada);
      $("#fechaFin").datepicker("setDate", this.rango_estancia.fecha_salida);
      // console.log("fecha " + this.rango_estancia.fecha_entrada);
      // console.log("fecha2 " + this.model_rango_estancia);
      this.limpiarPrecio();
    },
    btnRedondo() {
      $("#viaje_sencillo").removeClass("selected_transporte");
      $("#viaje_redondo").addClass("selected_transporte");
      this.tipo_viaje = true;
      $("#estancia_sencillo").addClass("d-none");
      $("#estancia_redondo").removeClass("d-none");
      this.limpiarPrecio();
    },

    btnRegular() {
      $("#pasajeros_aumentar").prop("disabled", false);
      $("#tipo_regular").addClass("selected_transporte");
      $("#tipo_deluxe").removeClass("selected_transporte");
      this.tipo_servicio = true;
      this.limpiarPrecio();
    },
    btnDeluxe() {
      if (this.pasajeros.cantidad > 5) {
        this.pasajeros.cantidad = 5;
      }
      $("#tipo_regular").removeClass("selected_transporte");
      $("#tipo_deluxe").addClass("selected_transporte");
      this.tipo_servicio = false;
      this.limpiarPrecio();
    },
    changeModo() {
      if (this.modo.inicio == "Aeropuerto") {
        this.modo.inicio = "Hotel";
        this.modo.fin = "Aeropuerto";

        $("#fechaFin").attr("type", "text");
        $("#fechaIni").attr("type", "hidden");
      } else {
        this.modo.inicio = "Aeropuerto";
        this.modo.fin = "Hotel";

        $("#fechaFin").attr("type", "hidden");
        $("#fechaIni").attr("type", "text");
      }

      this.limpiarPrecio();
    },
    btnAumentarPasajero() {
      if (this.tipo_servicio == false && this.pasajeros.cantidad < 5) {
        this.pasajeros.cantidad = this.pasajeros.cantidad + 1;
      } else if (this.tipo_servicio == true && this.pasajeros.cantidad < 14) {
        this.pasajeros.cantidad = this.pasajeros.cantidad + 1;
      }
      if (this.tipo_servicio == false && this.pasajeros.cantidad == 5) {
        $("#pasajeros_aumentar").prop("disabled", true);
      }
      this.limpiarPrecio();
    },
    btnReducirPasajero() {
      if (this.pasajeros.cantidad > 1) {
        this.pasajeros.cantidad = this.pasajeros.cantidad - 1;
      }
      if (this.tipo_servicio == false && this.pasajeros.cantidad < 5) {
        $("#pasajeros_aumentar").prop("disabled", false);
      }
      this.limpiarPrecio();
    },
    validarTipoServicio() {
      // False = Deluxe
      // True = Regular
      if (this.tipo_servicio === false) {
        // this.pasajeros.cantidad = 5;
        // $("#pasajeros_aumentar").prop("disabled", true);
      } else {
        // $("#pasajeros_aumentar").prop("disabled", false);
      }
    },
    toggleCalendarios() {
      $("#estancia_sencillo").toggleClass("d-none");
      $("#estancia_redondo").toggleClass("d-none");
      this.limpiarPrecio();
    },

    validarTipoRuta() {
      if (this.modo.inicio === "Hotel" && this.modo.fin === "Aeropuerto") {
        $("#viaje_redondo").prop("disabled", true);
        this.btnSencillo();
      } else {
        $("#viaje_redondo").prop("disabled", false);
      }
      this.limpiarPrecio();
    },
    formatPrice(value) {
      //redondea siempre para arriba
      // var redondear = Math.ceil(value);
      let val = (value / 1).toFixed(2).replace(",", ".");
      return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    },
    fillAvailRequest() {
      this.availRequest.idtour = "0";
      // console.log(this.selectedDestino);
      this.availRequest.direccion =
        this.modo.inicio == "Aeropuerto" ? "desdeAeropuerto" : "alAeropuerto";
      this.availRequest.id_hotel = this.selectedDestino.Codigo;
      this.availRequest.nombre_hotel = this.selectedDestino.Nombre;
      this.availRequest.code = this.selectedDestino.codeStore;
      this.availRequest.zona = this.selectedDestino.Zona;
      this.availRequest.city = this.selectedDestino.City;
      this.availRequest.tipo_servicio = this.tipo_viaje
        ? "redondo"
        : "sencillo";
      this.availRequest.adultos = this.pasajeros.cantidad;
      // console.log(this.rango_estancia)
      this.availRequest.fecha_salida = $("#fechaFin").val();
      this.availRequest.fecha_llegada = $("#fechaIni").val();
      this.availRequest.deluxe = this.tipo_servicio ? 0 : 1;
    },
    actionAvailRequest() {
      this.fillAvailRequest();
      var that = this;
      this.updateInfo = true;
      that.availRequest.okpass = 0;
      this.$http
        .post(this.rmt_url + "/transportacion/avail", this.availRequest, {
          emulateJSON: true,

        })
        .then(
          function (response) {
            that.availRequest.tarifa_neta = response.data.avail.precio;
            that.availRequest.total = response.data.avail.publica;

            that.updateInfo = false;
            that.changedInfo = false;
            that.responseAvail = response.data;
            that.availRequest.okpass = 1;
          },
          function (response) {
            // console.log(response.data);
          }
        );
    },
    limpiarPrecio() {
      this.changedInfo = true;
      this.availRequest.total = 0;
    },
    enviarFormulario() {
      // console.log(this.availRequest.total);
      if (this.availRequest.total > 0 && this.availRequest.id_hotel != null) {
        $("#btn_enviarForm").html("<span class=\'spinner-border spinner-border-sm\' role=\'status\' aria-hidden=\'true\'></span> PROCESANDO...");
        $("#btn_enviarForm").prop('disabled', true);
        setTimeout(function () {
          $("#form-transportacion").submit();
        }, 1000);
      } else {
        alert("Click en cotizar para proceder con su reserva");
        return false;
      }
    },
  },
});

var dp_web = document.getElementById("dp_estancia_web");

var settings_dp = {
  format: "DD/MM/YYYY",
  startOfWeek: "sunday",
  startDate: transportacionv1.settings_date,
  i18n: {
    night: "Noche",
    nights: "Noches",
    button: "Cerrar",
    "day-names-short": ["Dom", "Lun", "Mar", "Mie", "Jue", "Vie", "Sab"],
    "day-names": [
      "Domingo",
      "Lunes",
      "Martes",
      "Miércoles",
      "Jueves",
      "Viernes",
      "Sábado",
    ],
    "month-names-short": [
      "Ene",
      "Feb",
      "Mar",
      "Abr",
      "Mar",
      "Jun",
      "Jul",
      "Ago",
      "Sep",
      "Oct",
      "Nov",
      "Dic",
    ],
    "month-names": [
      "Enero",
      "Febrero",
      "Marzo",
      "Abril",
      "Mayo",
      "Junio",
      "Julio",
      "Agosto",
      "Septiembre",
      "Octubre",
      "Noviembre",
      "Diciembre",
    ],
    "info-more": "Por favor seleccione la fecha de su estancia",
  },
  moveBothMonths: true,
};

var datepicker_web = new HotelDatepicker(dp_web, settings_dp);
$("#fechaIni").datepicker(
  "setDate",
  transportacionv1.rango_estancia.fecha_entrada
);
$("#fechaFin").datepicker(
  "setDate",
  transportacionv1.rango_estancia.fecha_salida
);
dp_web.addEventListener(
  "afterClose",
  function () {
    transportacionv1.model_rango_estancia = $("#dp_estancia_web").val();
    var rango = transportacionv1.model_rango_estancia.split("-");
    transportacionv1.rango_estancia.fecha_entrada = rango[0].replace(/\s/g, "");
    transportacionv1.rango_estancia.fecha_salida = rango[1].replace(/\s/g, "");
    $("#fechaIni").datepicker(
      "setDate",
      transportacionv1.rango_estancia.fecha_entrada
    );
    $("#fechaFin").datepicker(
      "setDate",
      transportacionv1.rango_estancia.fecha_salida
    );
    transportacionv1.limpiarPrecio();
  },
  false
);

function availTransportacion() {
  $.ajax({
    type: "POST",
    url: rmt_url + "/transportacion/avail",
    data: $(".eventus").serialize(),
    dataType: "json",
    success: function (data) {
      var response = data;
    },
  });
}

$("#btn_reservar").click(function (event) {
  if ($("#hotel").val() !== "") {
    var tipo_servicio = $("#servicio").val();
    $("input[name=servicio]").val(tipo_servicio);
    setTimeout(function () {
      $("#form-transportacion").submit();
    }, 1000);
  } else {
    alert("Elige destino para continuar");
    return false;
  }
});

$("#fechaIni")
  .datepicker({
    language: "es",
    startDate: "-0d",
    format: "dd/mm/yyyy",
    minDate: "dateToday",
  })
  .on("changeDate", function (e) {
    transportacionv1.limpiarPrecio();
  });

$("#fechaFin").datepicker({
  language: "es",
  format: "dd/mm/yyyy",
  minDate: "dateToday",
}).on("changeDate", function (e) {
  transportacionv1.limpiarPrecio();
});

$("#fechaIni").datepicker("setStartDate", transportacionv1.settings_date);
$("#fechaFin").datepicker("setStartDate", transportacionv1.settings_date);
function currentdaymas3dias(fecha_current) {
  var dia = parseInt(fecha_current.split("/")[0]) + 3;
  var mes = parseInt(fecha_current.split("/")[1]) - 1;
  var año = parseInt(fecha_current.split("/")[2]);
  if (dia > 31) {
    dia = dia - 31;
    if (mes > 12) {
      mes = 1;
      año++;
    } else {
      mes++;
    }
  }
  return moment(new Date(año, mes, dia)).format("DD/MM/YYYY");
}
;