var app_promo = new Vue({
    el: '#apppromociones',
    data: {
        array_promociones: [],
        nombre_hotel: '',
        vista: false,
        price_sort: 'lower',
        estrellas_cant: '0',
        NUM_RESULTS: 3, // Numero de resultados por página
        pag: 1, // Página inicial
    },
    created: function () {

    },
    mounted: function () {
        this.loadPromociones();

    },
    methods: {

        orderBy: function (sorKey) {
            this.sortKey = sorKey
            this.sortSettings[sorKey] = !this.sortSettings[sorKey]
            this.desc = this.sortSettings[sorKey]

        },

        formatPrice(value) {
            //redondea siempre para arriba
            var redondear = Math.ceil(value);
            let val = (redondear / 1).toFixed(2).replace(',', '.')
            return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        },

        loadPromociones: function () {
            this.$http.get(encodeURI('https://www.rutamayatravel.com/sur4agencias/tarifasFlyers/getListaActivados')).then(function (response) {
                this.array_promociones = response.body;
                Vue.nextTick(function () {
                    $('.owl-carousel').owlCarousel({
                        loop: true,

                        margin: 30,
                        nav: false,
                        dots: false,
                        autoplay: true,
                        autoplayTimeout: 1500,
                        smartSpeed: 250,
                        autoplayHoverPause: true,
                        responsive: {
                            0: {
                                items: 1
                            },
                            600: {
                                items: 1
                            },
                            1000: {
                                items: 4
                            }
                        }

                    });
                });

            }, function () {
                console.log('Error');
            });
        },
        cambiarVistaCuadros() {

            this.vista = true;

        },
        cambiarVistaLista() {

            this.vista = false;

        },

    },
    computed: {
        //icon_search
        buscar_promociones: function () {

            var self = this;
            if (this.price_sort == "lower") {
                this.array_promociones.sort(function (a, b) {
                    return parseFloat(a.precio_normal) > parseFloat(b.precio_normal) ? 1 : parseFloat(a.precio_normal) < parseFloat(b.precio_normal) ? -1 : 0;
                })
            } else {
                this.array_promociones.sort(function (a, b) {
                    return parseFloat(a.precio_normal) > parseFloat(b.precio_normal) ? -1 : parseFloat(a.precio_normal) < parseFloat(b.precio_normal) ? 1 : 0;
                })
            }

            return this.array_promociones.filter(function (tarifa) {

                if (self.estrellas_cant > 0) {
                    this.pag = 1;
                    return tarifa.estrellas_hotel.toLowerCase().includes(self.estrellas_cant.toLowerCase()) &&
                        tarifa.nombre_hotel.toLowerCase().includes(self.nombre_hotel.toLowerCase())
                        ;
                }
                else {
                    this.pag = 1;
                    return tarifa.nombre_hotel.toLowerCase().includes(self.nombre_hotel.toLowerCase());
                }

            });

        },

    }

})
